/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.explosionVisualizer.simulate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.explosionVisualizer.explosoionBehaviors.EntityExplosionBehaviorManager;
import mypals.ml.features.explosionVisualizer.explosoionBehaviors.ExplosionBehaviorManager;
import mypals.ml.features.explosionVisualizer.explosoionBehaviors.TntMinecartExplosionBehaviorManager;
import mypals.ml.features.explosionVisualizer.explosoionBehaviors.WindChargeExplosionBehaviorManager;
import mypals.ml.features.explosionVisualizer.explosoionBehaviors.WindChargeTrigger;
import mypals.ml.features.explosionVisualizer.explosoionBehaviors.WitherSkullExplosionBehaviorManager;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.EntityToDamage;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.SamplePointsData.RayCastPointInfo.RayCastData;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.SamplePointsData.SamplePointData;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionAffectedObjects;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionCastLines.ExplosionCastLine;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionCastLines.PointsOnLine.CastPoint;
import net.minecraft.class_1297;
import net.minecraft.class_1687;
import net.minecraft.class_1701;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_8956;
import net.minecraft.class_9238;
import org.jetbrains.annotations.Nullable;

public class ExplosionSimulator {
    @Nullable
    private static class_1297 thisEntity;
    private static boolean ignorSelf;
    private final class_1937 world;
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final ExplosionAffectedObjects affected = new ExplosionAffectedObjects(null, null, null, null, null);

    public ExplosionSimulator(class_1297 thisEntity, boolean ignorSelf, class_1937 world, float x, float y, float z, float power) {
        ExplosionSimulator.thisEntity = thisEntity;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.power = power;
        ExplosionSimulator.ignorSelf = ignorSelf;
    }

    public void simulate() {
        this.collectBlocksAndDamageEntities();
    }

    public Optional<Float> getBlastResistance(class_2338 pos, class_2680 blockState, class_3610 fluidState) {
        return blockState.method_26215() && fluidState.method_15769() ? Optional.empty() : Optional.of(Float.valueOf(Math.max(blockState.method_26204().method_9520(), fluidState.method_15760())));
    }

    private void collectBlocksAndDamageEntities() {
        HashSet<class_2338> blocksToDestroy = new HashSet<class_2338>();
        HashSet<class_2338> blocksShouldBeFine = new HashSet<class_2338>();
        SamplePointData sampleData = new SamplePointData(new ArrayList<RayCastData>());
        float blastRadius = this.power * 2.0f;
        int minX = class_3532.method_15357((double)(this.x - (double)blastRadius - 1.0));
        int maxX = class_3532.method_15357((double)(this.x + (double)blastRadius + 1.0));
        int minY = class_3532.method_15357((double)(this.y - (double)blastRadius - 1.0));
        int maxY = class_3532.method_15357((double)(this.y + (double)blastRadius + 1.0));
        int minZ = class_3532.method_15357((double)(this.z - (double)blastRadius - 1.0));
        int maxZ = class_3532.method_15357((double)(this.z + (double)blastRadius + 1.0));
        List entities = this.world.method_8335(null, new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        class_243 explosionCenter = new class_243(this.x, this.y, this.z);
        this.affected.explotionCenters.add(explosionCenter);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    if (!this.isEdge(x, y, z) || !LucidityConfig.showBlockDestroyInfo && !LucidityConfig.showExplosionBlockDamageRayInfo) continue;
                    this.processExplosion(thisEntity, ignorSelf, explosionCenter, entities, x, y, z, blastRadius, blocksToDestroy, blocksShouldBeFine);
                }
            }
        }
        this.affected.blocksToDestriy.addAll(blocksToDestroy);
        this.affected.blocksShouldBeFine.addAll(blocksShouldBeFine);
        for (class_1297 e : entities) {
            if (!LucidityConfig.showDamageInfo && !LucidityConfig.showRayCastInfo || e == thisEntity) continue;
            float damage = this.calculateDamage(explosionCenter, this.power, e, sampleData);
            this.affected.entityToDamage.add(new EntityToDamage(e, damage, sampleData));
        }
        for (EntityToDamage e : this.affected.entityToDamage) {
            this.affected.samplePointData.add(e.getPointData());
        }
    }

    private boolean isEdge(int x, int y, int z) {
        return x == 0 || x == 15 || y == 0 || y == 15 || z == 0 || z == 15;
    }

    private int getColorForRays(class_2382 p, int colorWith) {
        LucidityConfig.CONFIG_HANDLER.instance();
        int rgb = 0;
        switch (colorWith) {
            case 0: {
                int r = p.method_10263() * 255 / 16;
                int g = p.method_10264() * 255 / 16;
                int b = p.method_10260() * 255 / 16;
                rgb = r << 16 | g << 8 | b;
                break;
            }
            case 1: {
                if (p.method_10263() == 0) {
                    rgb = LucidityConfig.Colored_FRONT.getRGB();
                    break;
                }
                if (p.method_10263() == 15) {
                    rgb = LucidityConfig.Colored_BACK.getRGB();
                    break;
                }
                if (p.method_10264() == 0) {
                    rgb = LucidityConfig.Colored_DOWN.getRGB();
                    break;
                }
                if (p.method_10264() == 15) {
                    rgb = LucidityConfig.Colored_UP.getRGB();
                    break;
                }
                if (p.method_10260() == 0) {
                    rgb = LucidityConfig.Colored_LEFT.getRGB();
                    break;
                }
                if (p.method_10260() != 15) break;
                rgb = LucidityConfig.Colored_RIGHT.getRGB();
                break;
            }
            case 2: {
                rgb = LucidityConfig.Single_Color.getRGB();
            }
        }
        return rgb;
    }

    public static class_2561 getColoringTypeForRays(int colorWith) {
        class_5250 type = class_2561.method_43470((String)"UNKNOWN!");
        switch (colorWith) {
            case 0: {
                type = class_2561.method_43471((String)"config.option.type.direction_based");
                break;
            }
            case 1: {
                type = class_2561.method_43471((String)"config.option.type.face_based");
                break;
            }
            case 2: {
                type = class_2561.method_43471((String)"config.option.type.single_color");
            }
        }
        return type;
    }

    private void processExplosion(class_1297 thisEntity, boolean ignorScourcePos, class_243 explotionScource, List<class_1297> entities, int x, int y, int z, float blastRadius, Set<class_2338> blocksToDestroy, Set<class_2338> blocksShouldBeFine) {
        ArrayList<CastPoint> castedPoints = new ArrayList<CastPoint>();
        LucidityConfig.CONFIG_HANDLER.instance();
        int rgb = this.getColorForRays(new class_2382(x, y, z), LucidityConfig.ColorType);
        double dx = (float)x / 15.0f * 2.0f - 1.0f;
        double dy = (float)y / 15.0f * 2.0f - 1.0f;
        double dz = (float)z / 15.0f * 2.0f - 1.0f;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= distance;
        dy /= distance;
        dz /= distance;
        float initialBlastStrength = this.power * (0.7f + this.world.field_9229.method_43057() * 0.6f);
        double currentX = this.x;
        double currentY = this.y;
        double currentZ = this.z;
        int layer = 0;
        for (float blastStrength = initialBlastStrength; blastStrength > 0.0f; blastStrength -= 0.22500001f) {
            class_2338 currentPos = class_2338.method_49637((double)currentX, (double)currentY, (double)currentZ);
            class_2680 blockState = this.world.method_8320(currentPos);
            class_3610 fluidState = this.world.method_8316(currentPos);
            if (this.inRange(x, y, z) && this.inLayer(layer) && LucidityConfig.showExplosionBlockDamageRayInfo && !new class_243(explotionScource.field_1352, explotionScource.field_1351, explotionScource.field_1350).equals((Object)new class_243(currentX, currentY, currentZ)) && (!ignorScourcePos || !currentPos.equals((Object)class_2338.method_49638((class_2374)explotionScource)))) {
                castedPoints.add(new CastPoint(new class_243(currentX, currentY, currentZ), blastStrength));
            }
            if (!this.world.method_24794(currentPos)) break;
            Optional<Float> blastResistance = Optional.of(Float.valueOf(0.0f));
            if (thisEntity != null) {
                if (thisEntity instanceof class_1701) {
                    EManager = new TntMinecartExplosionBehaviorManager();
                    blastResistance = ((EntityExplosionBehaviorManager)EManager).getBlastResistance(this.world, currentPos, this.world.method_8320(currentPos), this.world.method_8316(currentPos));
                } else if (thisEntity instanceof class_1687) {
                    EManager = new WitherSkullExplosionBehaviorManager();
                    ((WitherSkullExplosionBehaviorManager)EManager).witherSkull = (class_1687)thisEntity;
                    blastResistance = ((EntityExplosionBehaviorManager)EManager).getBlastResistance(this.world, currentPos, this.world.method_8320(currentPos), this.world.method_8316(currentPos));
                } else if (thisEntity instanceof class_8956 || thisEntity instanceof class_9238) {
                    EManager = new WindChargeExplosionBehaviorManager(true);
                    blastResistance = ((WindChargeExplosionBehaviorManager)EManager).getBlastResistance(this.world, currentPos, this.world.method_8320(currentPos), this.world.method_8316(currentPos));
                } else {
                    EManager = new EntityExplosionBehaviorManager();
                    blastResistance = ((EntityExplosionBehaviorManager)EManager).getBlastResistance(this.world, currentPos, this.world.method_8320(currentPos), this.world.method_8316(currentPos));
                }
            } else {
                EManager = new ExplosionBehaviorManager();
                blastResistance = EManager.getBlastResistance(this.world, currentPos, this.world.method_8320(currentPos), this.world.method_8316(currentPos));
            }
            if (blastResistance.isPresent()) {
                boolean isSourcePos = currentPos.equals((Object)class_2338.method_49638((class_2374)explotionScource));
                blastStrength = isSourcePos && ignorScourcePos ? (blastStrength -= 0.0f) : (blastStrength -= (blastResistance.get().floatValue() + 0.3f) * 0.3f);
            }
            if (blastStrength > 0.0f && !blockState.method_26215() && fluidState.method_15769()) {
                if (thisEntity != null) {
                    if (thisEntity instanceof class_1701) {
                        TntMinecartExplosionBehaviorManager EManager = new TntMinecartExplosionBehaviorManager();
                        if (EManager.canExplosionDestroyBlock(this.world, currentPos, this.world.method_8320(currentPos))) {
                            blocksToDestroy.add(currentPos);
                        } else {
                            blocksShouldBeFine.add(currentPos);
                        }
                    } else if (thisEntity instanceof class_8956 || thisEntity instanceof class_9238) {
                        if (WindChargeTrigger.canTriggerBlocks(currentPos, this.world)) {
                            blocksToDestroy.add(currentPos);
                        } else {
                            blocksShouldBeFine.add(currentPos);
                        }
                    } else if (!ignorScourcePos || !currentPos.equals((Object)class_2338.method_49638((class_2374)explotionScource))) {
                        blocksToDestroy.add(currentPos);
                    }
                } else if (!ignorScourcePos || !currentPos.equals((Object)class_2338.method_49638((class_2374)explotionScource))) {
                    blocksToDestroy.add(currentPos);
                }
            }
            currentX += dx * (double)0.3f;
            currentY += dy * (double)0.3f;
            currentZ += dz * (double)0.3f;
            ++layer;
        }
        this.affected.blockDestructionRays.add(new ExplosionCastLine(initialBlastStrength, rgb, castedPoints));
    }

    public float calculateDamage(class_243 pos, float power, class_1297 entity, SamplePointData sampleData) {
        float explosionPower = power * 2.0f;
        class_243 explosionPosition = pos;
        double normalizedDistance = Math.sqrt(entity.method_5707(explosionPosition)) / (double)explosionPower;
        class_2338 ignor = new class_2338((class_2382)class_2338.method_49638((class_2374)explosionPosition));
        double exposureEffect = (1.0 - normalizedDistance) * (double)ExplosionSimulator.getExposure(explosionPosition, entity, ignor, sampleData);
        return (float)((exposureEffect * exposureEffect + exposureEffect) / 2.0 * 7.0 * (double)explosionPower + 1.0);
    }

    public static float getExposure(class_243 source, class_1297 entity, class_2338 ignoreBlock, SamplePointData sampleData) {
        class_238 boundingBox = entity.method_5829();
        double xStep = 1.0 / ((boundingBox.field_1320 - boundingBox.field_1323) * 2.0 + 1.0);
        double yStep = 1.0 / ((boundingBox.field_1325 - boundingBox.field_1322) * 2.0 + 1.0);
        double zStep = 1.0 / ((boundingBox.field_1324 - boundingBox.field_1321) * 2.0 + 1.0);
        double xOffset = (1.0 - Math.floor(1.0 / xStep) * xStep) / 2.0;
        double zOffset = (1.0 - Math.floor(1.0 / zStep) * zStep) / 2.0;
        if (xStep >= 0.0 && yStep >= 0.0 && zStep >= 0.0) {
            int visiblePointsCount = 0;
            int totalPointsCount = 0;
            for (double xFraction = 0.0; xFraction <= 1.0; xFraction += xStep) {
                for (double yFraction = 0.0; yFraction <= 1.0; yFraction += yStep) {
                    for (double zFraction = 0.0; zFraction <= 1.0; zFraction += zStep) {
                        boolean isClientPlayer;
                        double x = class_3532.method_16436((double)xFraction, (double)boundingBox.field_1323, (double)boundingBox.field_1320);
                        double y = class_3532.method_16436((double)yFraction, (double)boundingBox.field_1322, (double)boundingBox.field_1325);
                        double z = class_3532.method_16436((double)zFraction, (double)boundingBox.field_1321, (double)boundingBox.field_1324);
                        class_243 point = new class_243(x + xOffset, y, z + zOffset);
                        class_3965 hitResult = entity.method_37908().method_17742(new class_3959(point, source, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
                        boolean bl = isClientPlayer = entity instanceof class_746 && !class_310.method_1551().field_1773.method_19418().method_19333();
                        if (hitResult.method_17783() == class_239.class_240.field_1333) {
                            ++visiblePointsCount;
                            if (!(entity instanceof class_746) || !isClientPlayer) {
                                sampleData.castPointData.add(new RayCastData(point, source, true));
                            }
                        } else if (hitResult.method_17783() == class_239.class_240.field_1332) {
                            class_2338 hitPos = hitResult.method_17777();
                            if (ignoreBlock.equals((Object)hitPos) && ignorSelf) {
                                ++visiblePointsCount;
                                if (!(entity instanceof class_746) || !isClientPlayer) {
                                    sampleData.castPointData.add(new RayCastData(point, source, true));
                                }
                            } else if (!(entity instanceof class_746) || !isClientPlayer) {
                                sampleData.castPointData.add(new RayCastData(point, hitResult.method_17784(), false));
                            }
                        }
                        ++totalPointsCount;
                    }
                }
            }
            return (float)visiblePointsCount / (float)totalPointsCount;
        }
        return 0.0f;
    }

    public ExplosionAffectedObjects getAffected() {
        return this.affected;
    }

    public boolean inRange(int x, int y, int z) {
        LucidityConfig.CONFIG_HANDLER.instance();
        if (LucidityConfig.invert) {
            return LucidityConfig.Xmin > x || LucidityConfig.Xmax < x || LucidityConfig.Ymin > y || LucidityConfig.Ymax < y || LucidityConfig.Zmin > z || LucidityConfig.Zmax < z;
        }
        return LucidityConfig.Xmin <= x && LucidityConfig.Xmax >= x && LucidityConfig.Ymin <= y && LucidityConfig.Ymax >= y && LucidityConfig.Zmin <= z && LucidityConfig.Zmax >= z;
    }

    public boolean inLayer(int layer) {
        return LucidityConfig.LayerMin <= layer && LucidityConfig.LayerMax >= layer;
    }

    static {
        ignorSelf = false;
    }
}

