/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.mobFollowRange;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mypals.ml.config.LucidityConfig;
import mypals.ml.rendering.InformationRender;
import mypals.ml.rendering.shapes.LineShape;
import mypals.ml.rendering.shapes.OnGroundMarker;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_1588;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_5134;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class MobFollowRangeScanner {
    public static void onClientTick(int scanRadius) {
        class_638 world = class_310.method_1551().field_1687;
        class_2338 centerPos = class_310.method_1551().field_1724.method_24515();
        for (Map.Entry<class_2338, class_2338> entry : MobFollowRangeScanner.scanNearbyMobFollowRanges((class_1937)world, centerPos, scanRadius).entrySet()) {
            class_2338 surfacePos = entry.getValue();
            InformationRender.addOnGroundMarker(new OnGroundMarker(surfacePos, Color.ORANGE, 0.3f, false));
        }
    }

    public static Map<class_2338, class_2338> scanNearbyMobFollowRanges(class_1937 world, class_2338 centerPos, int scanRadius) {
        HashMap<class_2338, class_2338> blockSurfaceMap = new HashMap<class_2338, class_2338>();
        class_238 searchBox = new class_238(centerPos.method_10069(-scanRadius, -scanRadius, -scanRadius).method_46558(), centerPos.method_10069(scanRadius, scanRadius, scanRadius).method_46558());
        List mobs = world.method_8390(class_1308.class, searchBox, mob -> mob instanceof class_1588 || mob instanceof class_1439);
        List potentialTargets = world.method_8390(class_1309.class, searchBox, entity -> entity instanceof class_1657 || entity instanceof class_1473 || entity instanceof class_1646 || entity instanceof class_1439);
        for (class_1308 mob2 : mobs) {
            double followRange = MobFollowRangeScanner.getFollowRangeEstimate(mob2);
            if (LucidityConfig.renderMobChaseRange) {
                class_2338 mobPos = mob2.method_24515();
                List<class_2338> circleBlocks = MobFollowRangeScanner.getCircleBlocks(mobPos, followRange);
                for (class_2338 blockPos : circleBlocks) {
                    class_2338 surfacePos = MobFollowRangeScanner.findClosestSurface(world, blockPos);
                    boolean pathfindThrough = mob2.method_37908().method_8320(blockPos).method_26171(class_10.field_50);
                    if (surfacePos == null || !pathfindThrough) continue;
                    blockSurfaceMap.put(blockPos, surfacePos);
                }
            }
            if (!LucidityConfig.renderMobEyeLineConnection) continue;
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return blockSurfaceMap;
            }
            for (class_1309 target : potentialTargets) {
                class_239 hitResult = MobFollowRangeScanner.canSeeTarget((class_1309)mob2, target);
                if (!((double)mob2.method_5739((class_1297)target) < followRange)) continue;
                if (target == player) {
                    class_243 targetPos = MobFollowRangeScanner.getTargetPosition((class_1657)player);
                    if (hitResult.method_17783() == class_239.class_240.field_1333) {
                        InformationRender.addLine(new LineShape(mob2.method_33571(), targetPos, Color.GREEN, 1.0f, true));
                        continue;
                    }
                    InformationRender.addLine(new LineShape(mob2.method_33571(), hitResult.method_17784(), Color.RED, 1.0f, true));
                    continue;
                }
                if (mob2 != target && hitResult.method_17783() == class_239.class_240.field_1333) {
                    InformationRender.addLine(new LineShape(mob2.method_33571(), target.method_33571(), Color.GREEN, 1.0f, true));
                    continue;
                }
                InformationRender.addLine(new LineShape(mob2.method_33571(), hitResult.method_17784(), Color.RED, 1.0f, true));
            }
        }
        return blockSurfaceMap;
    }

    private static class_243 getTargetPosition(class_1657 player) {
        class_310 client = class_310.method_1551();
        if (client.field_1690.method_31044().method_31034()) {
            class_243 viewDirection = player.method_5828(1.0f);
            return player.method_33571().method_1019(viewDirection.method_1021(0.5));
        }
        return player.method_33571();
    }

    public static class_239 canSeeTarget(class_1309 mob, class_1309 target) {
        class_243 mobEyes = mob.method_33571();
        class_243 targetPos = target.method_33571();
        return mob.method_37908().method_17742(new class_3959(mobEyes, targetPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)mob));
    }

    private static double getFollowRangeEstimate(class_1308 mob) {
        double followRange = mob.method_45325(class_5134.field_23717);
        if (followRange <= 0.0) {
            if (mob.method_5864().toString().contains("dragon")) {
                return 128.0;
            }
            return 0.0;
        }
        return followRange;
    }

    private static List<class_2338> getCircleBlocks(class_2338 center, double radius) {
        ArrayList<class_2338> blocks = new ArrayList<class_2338>();
        int r = (int)Math.ceil(radius);
        for (int dx = -r; dx <= r; ++dx) {
            for (int dz = -r; dz <= r; ++dz) {
                if (!((double)(dx * dx + dz * dz) <= radius * radius)) continue;
                blocks.add(center.method_10069(dx, 0, dz));
            }
        }
        return blocks;
    }

    private static class_2338 findClosestSurface(class_1937 world, class_2338 mobPos) {
        class_2338 belowPos;
        class_2338 checkPos;
        int y;
        int startY = mobPos.method_10264();
        int maxY = Math.min(world.method_31605(), startY + 30);
        int minY = Math.max(world.method_31607(), startY - 30);
        for (y = startY; y <= maxY; ++y) {
            checkPos = new class_2338(mobPos.method_10263(), y, mobPos.method_10260());
            belowPos = checkPos.method_10074();
            if (!world.method_8320(checkPos).method_26215() || world.method_8320(belowPos).method_26215()) continue;
            return belowPos;
        }
        for (y = startY - 1; y >= minY; --y) {
            checkPos = new class_2338(mobPos.method_10263(), y, mobPos.method_10260());
            belowPos = checkPos.method_10074();
            if (!world.method_8320(checkPos).method_26215() || world.method_8320(belowPos).method_26215()) continue;
            return belowPos;
        }
        return null;
    }
}

