/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.pastBlockEvents;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.selectiveRendering.AreaBox;
import mypals.ml.rendering.InformationRender;
import mypals.ml.rendering.shapes.TextShape;
import net.minecraft.class_156;
import net.minecraft.class_1919;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class ClientsideBlockEventManager {
    private static final ConcurrentHashMap<Long, List<class_1919>> blockEventGroups = new ConcurrentHashMap();

    public static void onClientTick() {
        ClientsideBlockEventManager.removeExpired(LucidityConfig.renderBlockEventsExpiredTime);
        for (List<class_1919> blockEvents : blockEventGroups.values()) {
            int i = 0;
            while (i < blockEvents.size()) {
                final class_1919 blockEvent = blockEvents.get(i);
                InformationRender.addAreaBox(new AreaBox(blockEvent.comp_60(), blockEvent.comp_60(), LucidityConfig.renderBlockEventsColor, (float)LucidityConfig.renderBlockEventsColor.getAlpha() / 255.0f, false));
                final int finalI = i++;
                InformationRender.addText(new TextShape(new ArrayList<String>(){
                    {
                        this.add("Order:" + finalI);
                        this.add(class_2561.method_43471((String)blockEvent.comp_61().method_63499()).getString());
                        this.add(blockEvent.comp_60().method_10263() + ", " + blockEvent.comp_60().method_10264() + ", " + blockEvent.comp_60().method_10260());
                        this.add("Type:" + blockEvent.comp_62());
                        this.add("Data:" + blockEvent.comp_63());
                    }
                }, blockEvent.comp_60().method_46558(), 0.01f, new ArrayList<Color>(){
                    {
                        this.add(Color.white);
                        this.add(Color.red);
                        this.add(Color.yellow);
                        this.add(Color.cyan);
                        this.add(Color.green);
                    }
                }, 1.0f, true));
            }
        }
    }

    public static void addSyncedBlockEvent(class_2338 pos, class_2248 block, int type, int data) {
        class_310.method_1551().execute(() -> {
            long time = class_156.method_658();
            if (blockEventGroups.containsKey(time)) {
                blockEventGroups.get(time).add(new class_1919(pos, block, type, data));
            } else {
                ArrayList<class_1919> l = new ArrayList<class_1919>();
                l.add(new class_1919(pos, block, type, data));
                blockEventGroups.put(time, l);
            }
        });
    }

    public static void removeExpired(double expiry) {
        long time = class_156.method_658();
        ArrayList<Long> toRemoves = new ArrayList<Long>();
        for (Map.Entry<Long, List<class_1919>> entry : blockEventGroups.entrySet()) {
            if (!((double)(time - entry.getKey()) > expiry)) continue;
            toRemoves.add(entry.getKey());
        }
        toRemoves.forEach(toRemove -> blockEventGroups.remove(toRemove));
    }
}

