/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.selectiveRendering;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.selectiveRendering.AreaBox;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SelectiveRenderingManager {
    public static Map<Integer, Map<class_2769, Object>> selectedBlockTypes = new HashMap<Integer, Map<class_2769, Object>>();
    public static List<Integer> selectedEntityTypes = new CopyOnWriteArrayList<Integer>();
    public static List<Integer> selectedParticleTypes = new CopyOnWriteArrayList<Integer>();
    public static List<AreaBox> selectedAreas = new CopyOnWriteArrayList<AreaBox>();
    public static class_1792 wand;
    public static RenderMode blockRenderMode;
    public static RenderMode entityRenderMode;
    public static RenderMode particleRenderMode;

    public static void resolveSelectedBlockStatesFromString(List<String> blockStrings) {
        selectedBlockTypes.clear();
        LucidityConfig.CONFIG_HANDLER.instance();
        blockStrings.forEach(blockString -> {
            try {
                class_2960 blockId;
                class_2248 block;
                blockString = blockString.replace(" ", "");
                String[] parts = blockString.split("\\[", 2);
                Object blockIdString = parts[0];
                if (!((String)blockIdString).contains(":")) {
                    blockIdString = "minecraft:" + (String)blockIdString;
                }
                if ((block = (class_2248)class_7923.field_41175.method_63535(blockId = class_2960.method_60654((String)blockIdString))) == null) {
                    return;
                }
                HashMap<class_2769, String> states = new HashMap<class_2769, String>();
                boolean hasState = false;
                class_2487 w = new class_2487();
                if (parts.length > 1) {
                    String[] properties;
                    String propertiesString = parts[1].replace("]", "");
                    for (String property : properties = propertiesString.split(",")) {
                        String[] keyValue = property.split("=");
                        if (keyValue.length != 2) continue;
                        String key = keyValue[0];
                        String value = keyValue[1];
                        class_2769 blockProperty = block.method_9595().method_11663(key);
                        if (blockProperty == null) continue;
                        states.put(blockProperty, value);
                        hasState = true;
                    }
                }
                if (hasState) {
                    selectedBlockTypes.put(class_7923.field_41175.method_10206((Object)block), states);
                } else {
                    selectedBlockTypes.put(class_7923.field_41175.method_10206((Object)block), null);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to parse block state: " + blockString);
            }
        });
    }

    public static void resolveSelectedEntityTypesFromString(List<String> entityStrings) {
        selectedEntityTypes.clear();
        LucidityConfig.CONFIG_HANDLER.instance();
        entityStrings.forEach(entityString -> {
            class_2960 entityId;
            class_1299 targetEntity;
            if (!((String)entityString).contains(":")) {
                entityString = "minecraft:" + (String)entityString;
            }
            if ((targetEntity = (class_1299)class_7923.field_41177.method_63535(entityId = class_2960.method_60654((String)entityString))) == null) {
                entityStrings.remove(entityId);
            } else {
                selectedEntityTypes.add(class_7923.field_41177.method_10206((Object)targetEntity));
            }
        });
    }

    public static void resolveSelectedParticleTypesFromString(List<String> particleStrings) {
        selectedParticleTypes.clear();
        LucidityConfig.CONFIG_HANDLER.instance();
        particleStrings.forEach(particleString -> {
            class_2960 particleId;
            class_2396 targetParticle;
            if (!((String)particleString).contains(":")) {
                particleString = "minecraft:" + (String)particleString;
            }
            if ((targetParticle = (class_2396)class_7923.field_41180.method_63535(particleId = class_2960.method_60654((String)particleString))) == null) {
                particleStrings.remove(particleId);
            } else {
                selectedParticleTypes.add(class_7923.field_41180.method_10206((Object)targetParticle));
            }
        });
    }

    public static void resolveSelectedWandFromString(String name) {
        class_2960 id;
        class_1792 nweWand;
        class_1792 last_wind = wand;
        if (!((String)name).contains(":")) {
            name = "minecraft:" + (String)name;
        }
        wand = (nweWand = (class_1792)class_7923.field_41178.method_63535(id = class_2960.method_60654((String)name))) == null ? last_wind : nweWand;
    }

    public static String resolveSelectiveRenderingMode(int index, RenderMode[] modes, Consumer<RenderMode> modeSetter) {
        if (index >= 0 && index < modes.length) {
            RenderMode mode = modes[index];
            modeSetter.accept(mode);
            return mode.getTranslationKey();
        }
        return "-";
    }

    public static String resolveSelectiveBlockRenderingMode(int index) {
        return SelectiveRenderingManager.resolveSelectiveRenderingMode(index, RenderMode.values(), mode -> {
            blockRenderMode = mode;
        });
    }

    public static String resolveSelectiveEntityRenderingMode(int index) {
        return SelectiveRenderingManager.resolveSelectiveRenderingMode(index, RenderMode.values(), mode -> {
            entityRenderMode = mode;
        });
    }

    public static String resolveSelectiveParticleRenderingMode(int index) {
        return SelectiveRenderingManager.resolveSelectiveRenderingMode(index, RenderMode.values(), mode -> {
            particleRenderMode = mode;
        });
    }

    public static void resolveSelectedAreasFromString(List<String> areaStrings) {
        selectedAreas.clear();
        areaStrings.forEach(areaString -> {
            try {
                AreaBox area = SelectiveRenderingManager.parseAABB(areaString);
                selectedAreas.add(area);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to parse area: " + areaString + " -> " + e.getMessage());
            }
        });
    }

    private static AreaBox parseAABB(String areaString) throws IllegalArgumentException {
        String[] parts = areaString.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid format. Expected x1,y1,z1:x2,y2,z2");
        }
        String[] startCoords = parts[0].split(",");
        String[] endCoords = parts[1].split(",");
        if (startCoords.length != 3 || endCoords.length != 3) {
            throw new IllegalArgumentException("Invalid coordinates. Expected x1,y1,z1:x2,y2,z2");
        }
        try {
            Random rand = new Random();
            int x1 = Integer.parseInt(startCoords[0].trim());
            int y1 = Integer.parseInt(startCoords[1].trim());
            int z1 = Integer.parseInt(startCoords[2].trim());
            int x2 = Integer.parseInt(endCoords[0].trim());
            int y2 = Integer.parseInt(endCoords[1].trim());
            int z2 = Integer.parseInt(endCoords[2].trim());
            int hash = new class_2338(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2)).hashCode();
            float hue = (float)(hash % 360) / 360.0f;
            float saturation = 1.0f;
            float brightness = 1.0f;
            Color color = Color.getHSBColor(hue, saturation, brightness);
            return new AreaBox(new class_2338(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2)), new class_2338(Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2)), color, 0.2f, false);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format in input: " + areaString, e);
        }
    }

    public static boolean shouldRenderBlock(class_2680 block, class_2338 pos) {
        return SelectiveRenderingManager.shouldRender(blockRenderMode, block, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()), blockType -> class_7923.field_41175.method_10206((Object)block.method_26204()), null, selectedBlockTypes);
    }

    public static boolean shouldRenderEntity(class_1299 entity, class_243 pos) {
        return SelectiveRenderingManager.shouldRender(entityRenderMode, entity, pos, entityType -> class_7923.field_41177.method_10206((Object)entity), selectedEntityTypes, null);
    }

    public static boolean shouldRenderParticle(class_2396 particle, class_243 pos) {
        return SelectiveRenderingManager.shouldRender(particleRenderMode, particle, pos, particleType -> class_7923.field_41180.method_10206((Object)particle), selectedParticleTypes, null);
    }

    private static <T> boolean shouldRender(RenderMode renderMode, T type, class_243 pos, Function<T, Integer> getIdFunction, @Nullable List<Integer> selectedTypes, @Nullable Map<Integer, Map<class_2769, Object>> selectedBlockStates) {
        boolean isSelected;
        if (renderMode == RenderMode.OFF) {
            return true;
        }
        if (selectedBlockStates == null) {
            if (selectedTypes == null) {
                return true;
            }
            isSelected = SelectiveRenderingManager.isSelectedType(getIdFunction.apply(type), selectedTypes);
        } else {
            isSelected = SelectiveRenderingManager.isSelectedTypeAndState((class_2680)type, selectedBlockStates);
        }
        boolean isInArea = SelectiveRenderingManager.isSelectedArea(pos);
        switch (renderMode.ordinal()) {
            case 1: {
                return isInArea && isSelected;
            }
            case 2: {
                return !isInArea && isSelected;
            }
            case 3: {
                return !isInArea || !isSelected;
            }
            case 4: {
                return !isSelected || isInArea;
            }
            case 5: {
                return isSelected;
            }
            case 6: {
                return !isSelected;
            }
            case 7: {
                return isInArea;
            }
            case 8: {
                return !isInArea;
            }
            case 9: {
                return isInArea && !isSelected;
            }
            case 10: {
                return !isInArea && !isSelected;
            }
        }
        return true;
    }

    public static boolean isSelectedType(int id, List<Integer> selectedTypes) {
        return selectedTypes.contains(id);
    }

    public static boolean isSelectedTypeAndState(class_2680 state, Map<Integer, Map<class_2769, Object>> selectedTypes) {
        for (Map.Entry<Integer, Map<class_2769, Object>> entry : selectedTypes.entrySet()) {
            Integer blockId = entry.getKey();
            Map<class_2769, Object> properties = entry.getValue();
            if (!blockId.equals(class_7923.field_41175.method_10206((Object)state.method_26204()))) continue;
            if ((properties == null || properties.isEmpty()) && class_7923.field_41175.method_10206((Object)state.method_26204()) == blockId.intValue()) {
                return true;
            }
            boolean hasAllProperties = true;
            for (Map.Entry<class_2769, Object> property : properties.entrySet()) {
                Optional stateProperty = state.method_28500(property.getKey());
                if (!stateProperty.isPresent()) {
                    hasAllProperties = false;
                    break;
                }
                if (stateProperty.get().toString().equals(property.getValue())) continue;
                hasAllProperties = false;
                break;
            }
            if (!hasAllProperties) continue;
            return true;
        }
        return false;
    }

    public static boolean isSelectedArea(class_243 blockPos) {
        for (AreaBox selectedArea : selectedAreas) {
            if (!SelectiveRenderingManager.isInsideArea(blockPos, selectedArea)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInsideArea(class_243 pos, AreaBox areaBox) {
        return (double)areaBox.minPos.method_10263() <= pos.method_10216() && pos.method_10216() <= (double)areaBox.maxPos.method_10263() && (double)areaBox.minPos.method_10264() <= pos.method_10214() && pos.method_10214() <= (double)areaBox.maxPos.method_10264() && (double)areaBox.minPos.method_10260() <= pos.method_10215() && pos.method_10215() <= (double)areaBox.maxPos.method_10260();
    }

    static {
        blockRenderMode = RenderMode.OFF;
        entityRenderMode = RenderMode.OFF;
        particleRenderMode = RenderMode.OFF;
    }

    public static enum RenderMode {
        OFF("config.lucidity.render_mode.off", "textures/gui/rendering_mode/render_mode_off.png"),
        RENDER_INSIDE_INCLUDE("config.lucidity.render_mode.render_inside_include", "textures/gui/rendering_mode/render_mode_1.png"),
        RENDER_OUTSIDE_INCLUDE("config.lucidity.render_mode.render_outside_include", "textures/gui/rendering_mode/render_mode_2.png"),
        RENDER_INSIDE_EXCLUDE("config.lucidity.render_mode.render_inside_exclude", "textures/gui/rendering_mode/render_mode_3.png"),
        RENDER_OUTSIDE_EXCLUDE("config.lucidity.render_mode.render_outside_exclude", "textures/gui/rendering_mode/render_mode_4.png"),
        RENDER_ONLY_SPECIFIC("config.lucidity.render_mode.render_only_specific", "textures/gui/rendering_mode/render_mode_5.png"),
        RENDER_EXCLUDE_SPECIFIC("config.lucidity.render_mode.render_exclude_specific", "textures/gui/rendering_mode/render_mode_6.png"),
        RENDER_INSIDE_ALL("config.lucidity.render_mode.render_inside_all", "textures/gui/rendering_mode/render_mode_7.png"),
        RENDER_OUTSIDE_ALL("config.lucidity.render_mode.render_outside_all", "textures/gui/rendering_mode/render_mode_8.png"),
        RENDER_INSIDE_EXCLUDE_SPECIFIC("config.lucidity.render_mode.render_inside_exclude_specific", "textures/gui/rendering_mode/render_mode_9.png"),
        RENDER_OUTSIDE_EXCLUDE_SPECIFIC("config.lucidity.render_mode.render_outside_exclude_specific", "textures/gui/rendering_mode/render_mode_10.png");

        private final String translationKey;
        private final String icon;

        private RenderMode(String translationKey, String icon) {
            this.translationKey = translationKey;
            this.icon = icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getIcon() {
            return this.icon;
        }
    }
}

