/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.soundListener3D;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.selectiveRendering.AreaBox;
import mypals.ml.rendering.InformationRender;
import mypals.ml.rendering.shapes.TextShape;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1145;
import net.minecraft.class_1146;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class SoundListener
implements class_1145 {
    List<SoundEventEntry> soundEntries = Lists.newArrayList();
    private boolean enabled;

    public void method_4884(class_1113 sound, class_1146 soundSet, float range) {
        if (soundSet.method_4886() != null) {
            class_2561 text = soundSet.method_4886();
            this.soundEntries.add(new SoundEventEntry(text, range, new class_243(sound.method_4784(), sound.method_4779(), sound.method_4778())));
        }
    }

    public void onClientTick() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1773.method_19418() == null) {
            return;
        }
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        class_1144 soundManager = client.method_1483();
        if (!this.enabled && LucidityConfig.renderSoundEvents) {
            soundManager.method_4878((class_1145)this);
            this.enabled = true;
        } else if (this.enabled && !LucidityConfig.renderSoundEvents) {
            soundManager.method_4866((class_1145)this);
            this.enabled = false;
        }
        if (this.enabled) {
            for (final SoundEventEntry soundEventEntry : this.soundEntries) {
                final SoundEntry soundEntry = soundEventEntry.getNearestSound(cameraPos);
                if (soundEntry == null) continue;
                class_243 soundPos = soundEntry.location;
                class_2338 blockPos = new class_2338(class_3532.method_15357((double)soundPos.field_1352), class_3532.method_15357((double)soundPos.field_1351), class_3532.method_15357((double)soundPos.field_1350));
                InformationRender.addAreaBox(new AreaBox(blockPos, blockPos, LucidityConfig.renderSoundEventsColor, (float)LucidityConfig.renderSoundEventsColor.getAlpha() / 255.0f, false));
                InformationRender.addText(new TextShape(new ArrayList<String>(){
                    {
                        this.add(soundEventEntry.getText().getString());
                        this.add(soundEntry.location.toString());
                    }
                }, soundPos, 0.01f, new ArrayList<Color>(){
                    {
                        this.add(new Color(LucidityConfig.renderSoundEventsColor.getRed(), LucidityConfig.renderSoundEventsColor.getGreen(), LucidityConfig.renderSoundEventsColor.getBlue(), 1));
                        this.add(new Color(LucidityConfig.renderSoundEventsColor.getRed(), LucidityConfig.renderSoundEventsColor.getGreen(), LucidityConfig.renderSoundEventsColor.getBlue(), 1));
                    }
                }, 255.0f, true));
                soundEventEntry.removeExpired(LucidityConfig.renderSoundEventsExpiredTime);
            }
        }
    }

    static class SoundEventEntry {
        private final class_2561 text;
        private final float range;
        private final List<SoundEntry> sounds = new ArrayList<SoundEntry>();

        public SoundEventEntry(class_2561 text, float range, class_243 pos) {
            this.text = text;
            this.range = range;
            this.sounds.add(new SoundEntry(pos, class_156.method_658()));
        }

        public class_2561 getText() {
            return this.text;
        }

        public SoundEntry getNearestSound(class_243 pos) {
            if (this.sounds.isEmpty()) {
                return null;
            }
            return this.sounds.size() == 1 ? this.sounds.getFirst() : (SoundEntry)this.sounds.stream().min(Comparator.comparingDouble(soundPos -> soundPos.location().method_1022(pos))).orElse(null);
        }

        public void reset(class_243 pos) {
            this.sounds.removeIf(sound -> pos.equals((Object)sound.location()));
            this.sounds.add(new SoundEntry(pos, class_156.method_658()));
        }

        public boolean canHearFrom(class_243 pos) {
            if (Float.isInfinite(this.range)) {
                return true;
            }
            if (this.sounds.isEmpty()) {
                return false;
            }
            SoundEntry soundEntry = this.getNearestSound(pos);
            return soundEntry != null && pos.method_24802((class_2374)soundEntry.location, (double)this.range);
        }

        public void removeExpired(double expiry) {
            long l = class_156.method_658();
            this.sounds.removeIf(sound -> (double)(l - sound.time()) > expiry);
        }

        public boolean hasSounds() {
            return !this.sounds.isEmpty();
        }
    }

    record SoundEntry(class_243 location, long time) {
    }
}

