/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.trajectory;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mypals.ml.config.LucidityConfig;
import mypals.ml.rendering.InformationRender;
import mypals.ml.rendering.shapes.LineStrip;
import mypals.ml.rendering.shapes.ShineMarker;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1680;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5575;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class TrajectoryManager {
    public static Set<class_1792> Type1 = new HashSet<class_1792>();
    public static Set<class_1792> Type2 = new HashSet<class_1792>();
    public static boolean showInfo = false;
    public static int handSide = 1;
    public static class_243 hitPoint = new class_243(0.0, 0.0, 0.0);

    public static void init() {
        Type1.add(class_1802.field_8634.method_8389());
        Type1.add(class_1802.field_8543.method_8389());
        Type1.add(class_1802.field_8803.method_8389());
        Type2.add(class_1802.field_8102.method_8389());
        Type2.add(class_1802.field_8547.method_8389());
        Type2.add(class_1802.field_8399.method_8389());
    }

    private static boolean isNormalProjectile(class_1799 stack) {
        return Type1.contains(stack.method_7909());
    }

    private static boolean isComplexProjectile(class_1799 stack) {
        return Type2.contains(stack.method_7909());
    }

    public static void onClientTick(class_310 client) {
        class_638 world = client.field_1687;
        TrajectoryManager.ForThisPlayer();
        TrajectoryManager.ForOtherPlayers();
        TrajectoryManager.ForOtherEntitys();
        assert (world != null);
        TrajectoryManager.ForProjectiles((class_2394)class_2398.field_11240, (class_2394)class_2398.field_29644, (class_2394)class_2398.field_38908, (class_1937)world, 128.0f);
    }

    public static void ForThisPlayer() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        class_638 world = client.field_1687;
        assert (player != null);
        float pitch = player.method_36455();
        float yaw = player.method_36454();
        class_1799 itemStack = player.method_6047();
        class_1799 itemStackAlt = player.method_6079();
        if (player != null) {
            if (TrajectoryManager.isNormalProjectile(itemStack) || TrajectoryManager.isComplexProjectile(itemStack)) {
                handSide = 1;
                showInfo = true;
            } else if (TrajectoryManager.isNormalProjectile(itemStackAlt) || TrajectoryManager.isComplexProjectile(itemStackAlt)) {
                handSide = -1;
                showInfo = true;
            } else {
                showInfo = false;
            }
            if (TrajectoryManager.isNormalProjectile(itemStack) || TrajectoryManager.isNormalProjectile(itemStackAlt)) {
                float speed = 1.5f;
                float gravity = 0.03f;
                TrajectoryManager.renderTrajectoryWithParticles(LucidityConfig.selfTrajectoryColor, LucidityConfig.selfTrajectoryColor, (class_1937)world, (class_1309)player, pitch, yaw, speed, gravity, true);
            } else if (TrajectoryManager.isComplexProjectile(itemStack) || TrajectoryManager.isComplexProjectile(itemStackAlt)) {
                float bowMultiplier = (72000.0f - (float)player.method_6014()) / 20.0f;
                if ((bowMultiplier = (bowMultiplier * bowMultiplier + bowMultiplier * 2.0f) / 3.0f) > 1.0f) {
                    bowMultiplier = 1.0f;
                }
                float gravity = 0.05f;
                float speed = bowMultiplier * 3.0f;
                if (player.method_6014() == 0) {
                    speed = 0.0f;
                }
                TrajectoryManager.renderTrajectoryWithParticles(LucidityConfig.selfTrajectoryColor, LucidityConfig.selfTrajectoryColor, (class_1937)world, (class_1309)player, pitch, yaw, speed, gravity, true);
            }
        }
    }

    public static void ForOtherPlayers() {
        class_310 client = class_310.method_1551();
        class_746 currentPlayer = client.field_1724;
        class_638 world = client.field_1687;
        if (client.field_1687 != null) {
            List players = client.field_1687.method_18456();
            for (class_1657 p : players) {
                float gravity;
                if (p == currentPlayer || p == null) continue;
                float pitch = p.method_36455();
                float yaw = p.method_36454();
                class_1799 itemStack = p.method_6047();
                class_1799 itemStackAlt = p.method_6079();
                if (TrajectoryManager.isNormalProjectile(itemStack) || TrajectoryManager.isNormalProjectile(itemStack)) {
                    handSide = 1;
                } else if (TrajectoryManager.isNormalProjectile(itemStackAlt) || TrajectoryManager.isNormalProjectile(itemStackAlt)) {
                    handSide = -1;
                }
                if (TrajectoryManager.isNormalProjectile(itemStack) || TrajectoryManager.isNormalProjectile(itemStackAlt)) {
                    float speed = 1.5f;
                    gravity = 0.03f;
                    TrajectoryManager.renderTrajectoryWithParticles(LucidityConfig.playerTrajectoryColor, LucidityConfig.playerTrajectoryColor, (class_1937)world, (class_1309)p, pitch, yaw, speed, gravity, false);
                    continue;
                }
                if (!TrajectoryManager.isComplexProjectile(itemStack) && !TrajectoryManager.isComplexProjectile(itemStackAlt)) continue;
                float bowMultiplier = (72000.0f - (float)p.method_6014()) / 20.0f;
                if ((bowMultiplier = (bowMultiplier * bowMultiplier + bowMultiplier * 2.0f) / 3.0f) > 1.0f) {
                    bowMultiplier = 1.0f;
                }
                gravity = 0.05f;
                float speed = bowMultiplier * 3.0f;
                if (p.method_6014() == 0) {
                    speed = 0.0f;
                }
                TrajectoryManager.renderTrajectoryWithParticles(LucidityConfig.playerTrajectoryColor, LucidityConfig.playerTrajectoryColor, (class_1937)world, (class_1309)p, pitch, yaw, speed, gravity, false);
            }
        }
    }

    public static void ForOtherEntitys() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (client.field_1687 != null) {
            for (class_1297 entity : client.field_1687.method_18112()) {
                float gravity;
                if (entity instanceof class_1657 || !(entity instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                float pitch = livingEntity.method_36455();
                float yaw = livingEntity.method_36454();
                class_1799 itemStack = livingEntity.method_6047();
                class_1799 itemStackAlt = livingEntity.method_6079();
                if (TrajectoryManager.isNormalProjectile(itemStack) || TrajectoryManager.isNormalProjectile(itemStack)) {
                    handSide = 1;
                } else if (TrajectoryManager.isNormalProjectile(itemStackAlt) || TrajectoryManager.isNormalProjectile(itemStackAlt)) {
                    handSide = -1;
                }
                if (TrajectoryManager.isNormalProjectile(itemStack) || TrajectoryManager.isNormalProjectile(itemStackAlt)) {
                    float speed = 1.5f;
                    gravity = 0.03f;
                    TrajectoryManager.renderTrajectoryWithParticles(LucidityConfig.mobTrajectoryColor, LucidityConfig.mobTrajectoryColor, (class_1937)world, livingEntity, pitch, yaw, speed, gravity, false);
                    continue;
                }
                if (!TrajectoryManager.isComplexProjectile(itemStack) && !TrajectoryManager.isComplexProjectile(itemStackAlt)) continue;
                float bowMultiplier = (72000.0f - (float)livingEntity.method_6014()) / 20.0f;
                if ((bowMultiplier = (bowMultiplier * bowMultiplier + bowMultiplier * 2.0f) / 3.0f) > 1.0f) {
                    bowMultiplier = 1.0f;
                }
                gravity = 0.05f;
                float speed = bowMultiplier * 3.0f;
                if (livingEntity.method_6014() == 0) {
                    speed = 0.0f;
                }
                TrajectoryManager.renderTrajectoryWithParticles(LucidityConfig.mobTrajectoryColor, LucidityConfig.mobTrajectoryColor, (class_1937)world, livingEntity, pitch, yaw, speed, gravity, false);
            }
        }
    }

    public static ArrayList<class_243> calculateTrajectory(Color colorHit, class_1937 world, float pitch, float yaw, class_1309 player, float speed, float gravity) {
        if (speed > 0.0f) {
            ArrayList<class_243> trajectoryPoints = new ArrayList<class_243>();
            double posX = player.method_23317();
            double posY = player.method_23318();
            double posZ = player.method_23321();
            float drag = 0.99f;
            float VX = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
            float VY = -class_3532.method_15374((float)(pitch * ((float)Math.PI / 180)));
            float VZ = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
            class_243 speedVecC = new class_243((double)VX, (double)VY, (double)VZ).method_1029().method_1021((double)speed);
            class_243 Velocity = new class_243(speedVecC.field_1352, speedVecC.field_1351, speedVecC.field_1350);
            class_243 entityPos = new class_243(0.0, 1.5, 0.0);
            class_1680 modleEntity = new class_1680(class_1299.field_6068, world);
            for (int i = 0; i < 100; ++i) {
                class_3965 hitResult = world.method_17742(new class_3959(new class_243(posX + entityPos.field_1352, posY + entityPos.field_1351, posZ + entityPos.field_1350), new class_243(posX + entityPos.field_1352, posY + entityPos.field_1351, posZ + entityPos.field_1350).method_1019(Velocity), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)modleEntity));
                if (hitResult.method_17783() != class_239.class_240.field_1333) {
                    hitPoint = new class_243(hitResult.method_17784().field_1352, hitResult.method_17784().field_1351, hitResult.method_17784().field_1350);
                    InformationRender.addShineMarker(new ShineMarker(new class_243(hitResult.method_17784().field_1352, hitResult.method_17784().field_1351, hitResult.method_17784().field_1350), colorHit, 0.1f, 2.0f, 30, 114514L, false, false), 1);
                    break;
                }
                entityPos = entityPos.method_1019(Velocity);
                Velocity = Velocity.method_1021((double)drag);
                Velocity = new class_243(Velocity.field_1352, Velocity.field_1351 - (double)gravity, Velocity.field_1350);
                class_243 startPos = new class_243(posX + entityPos.field_1352, posY + entityPos.field_1351, posZ + entityPos.field_1350);
                trajectoryPoints.add(new class_243(startPos.field_1352, startPos.field_1351, startPos.field_1350));
            }
            return trajectoryPoints;
        }
        return new ArrayList<class_243>();
    }

    public static ArrayList<class_243> calculateTrajectoryForEntity(Color colorHit, class_1297 entity, class_1937 world, double gravity, float drag) {
        ArrayList<class_243> trajectoryPoints = new ArrayList<class_243>();
        double posX = entity.method_23317();
        double posY = entity.method_23318();
        double posZ = entity.method_23321();
        class_243 velocity = entity.method_18798();
        for (int i = 0; i < 100; ++i) {
            class_243 newPosition = new class_243(posX, posY, posZ).method_1019(velocity);
            class_3965 hitResult = world.method_17742(new class_3959(new class_243(posX, posY, posZ), newPosition, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, entity));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                InformationRender.addShineMarker(new ShineMarker(new class_243(hitResult.method_17784().field_1352, hitResult.method_17784().field_1351, hitResult.method_17784().field_1350), colorHit, 0.1f, 2.0f, 30, 114514L, false, false), 1);
                break;
            }
            trajectoryPoints.add(newPosition);
            posX = newPosition.field_1352;
            posY = newPosition.field_1351;
            posZ = newPosition.field_1350;
            velocity = velocity.method_1021((double)drag);
            velocity = new class_243(velocity.field_1352, velocity.field_1351 - gravity, velocity.field_1350);
        }
        return trajectoryPoints;
    }

    public static ArrayList<class_243> applyRightOffset(class_1309 owner, ArrayList<class_243> points, double maxOffset) {
        int n = points.size() - 1;
        ArrayList<class_243> offsetPoints = new ArrayList<class_243>();
        double yaw = Math.toRadians(owner.method_36454());
        double forwardDirectionX = -Math.cos(yaw);
        double forwardDirectionZ = -Math.sin(yaw);
        for (int i = 0; i <= n; ++i) {
            class_243 point = points.get(i);
            double offset = maxOffset * (1.0 - (double)i / (double)n);
            class_243 offsetPoint = new class_243(point.field_1352 + offset * forwardDirectionX, point.field_1351, point.field_1350 + offset * forwardDirectionZ);
            offsetPoints.add(offsetPoint);
        }
        return offsetPoints;
    }

    public static void ForProjectiles(class_2394 mark, class_2394 particleTrace, class_2394 particleHit, class_1937 world, float boxSize) {
        ArrayList<class_243> points;
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        class_238 searchBox = new class_238(player.method_23317() - (double)boxSize, player.method_23318() - (double)boxSize, player.method_23321() - (double)boxSize, player.method_23317() + (double)boxSize, player.method_23318() + (double)boxSize, player.method_23321() + (double)boxSize);
        ArrayList projectilesSimple = new ArrayList();
        ArrayList projectilesComplex = new ArrayList();
        ArrayList projectilesStrate = new ArrayList();
        projectilesSimple.addAll(world.method_18023((class_5575)class_1299.field_6068, searchBox, entity -> true));
        projectilesSimple.addAll(world.method_18023((class_5575)class_1299.field_6144, searchBox, entity -> true));
        projectilesSimple.addAll(world.method_18023((class_5575)class_1299.field_56254, searchBox, entity -> true));
        projectilesSimple.addAll(world.method_18023((class_5575)class_1299.field_6082, searchBox, entity -> true));
        projectilesComplex.addAll(world.method_18023((class_5575)class_1299.field_6127, searchBox, trident -> !trident.method_24828()));
        projectilesComplex.addAll(world.method_18023((class_5575)class_1299.field_6135, searchBox, spectralArrow -> !spectralArrow.method_24828()));
        projectilesComplex.addAll(world.method_18023((class_5575)class_1299.field_6122, searchBox, arrow -> !arrow.method_24828()));
        projectilesStrate.addAll(world.method_18023((class_5575)class_1299.field_6066, searchBox, entity -> true));
        projectilesStrate.addAll(world.method_18023((class_5575)class_1299.field_6129, searchBox, entity -> true));
        projectilesStrate.addAll(world.method_18023((class_5575)class_1299.field_6049, searchBox, entity -> true));
        projectilesStrate.addAll(world.method_18023((class_5575)class_1299.field_47243, searchBox, entity -> true));
        projectilesStrate.addAll(world.method_18023((class_5575)class_1299.field_6130, searchBox, entity -> true));
        projectilesStrate.addAll(world.method_18023((class_5575)class_1299.field_6100, searchBox, entity -> true));
        projectilesStrate.addAll(world.method_18023((class_5575)class_1299.field_49075, searchBox, entity -> true));
        for (class_1297 projectile : projectilesSimple) {
            points = TrajectoryManager.calculateTrajectoryForEntity(LucidityConfig.nearTrajectoryColor, projectile, world, 0.03f, 0.99f);
            InformationRender.addLine(new LineStrip(points, Color.YELLOW, 0.9f, false));
        }
        for (class_1297 projectile : projectilesComplex) {
            points = TrajectoryManager.calculateTrajectoryForEntity(LucidityConfig.farTrajectoryColor, projectile, world, 0.05f, 0.99f);
            InformationRender.addLine(new LineStrip(points, Color.RED, 0.9f, false));
        }
        for (class_1297 projectile : projectilesStrate) {
            points = TrajectoryManager.calculateTrajectoryForEntity(LucidityConfig.linerTrajectoryColor, projectile, world, 0.0, 0.99f);
            InformationRender.addLine(new LineStrip(points, Color.CYAN, 0.9f, false));
        }
    }

    public static void renderTrajectoryWithParticles(Color colorTrace, Color colorHit, class_1937 world, class_1309 owner, float pitch, float yaw, float speed, float gravity, boolean doOffset) {
        ArrayList<class_243> points = TrajectoryManager.calculateTrajectory(colorHit, world, pitch, yaw, owner, speed, gravity);
        if (doOffset) {
            points = handSide == 1 ? TrajectoryManager.applyRightOffset(owner, points, 1.0) : TrajectoryManager.applyRightOffset(owner, points, -1.0);
        }
        InformationRender.addLine(new LineStrip(points, colorTrace, 1.0f, false));
    }
}

