/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.mixin.compat;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.selectiveRendering.SelectiveRenderingManager;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline.DefaultFluidRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DefaultFluidRenderer.class})
public class DefaultFluidRendererMixin {
    @Shadow
    @Final
    private int[] quadColors;

    @Inject(at={@At(value="RETURN")}, method={"isFullBlockFluidOccluded(Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/Direction;Lnet/minecraft/block/BlockState;Lnet/minecraft/fluid/FluidState;)Z"}, cancellable=true)
    private void isFullBlockFluidOccluded(class_1920 world, class_2338 pos, class_2350 dir, class_2680 blockState, class_3610 fluid, CallbackInfoReturnable<Boolean> cir) {
        if (!SelectiveRenderingManager.blockRenderMode.equals((Object)SelectiveRenderingManager.RenderMode.OFF) && !SelectiveRenderingManager.shouldRenderBlock(world.method_8320(pos.method_10093(dir)), pos.method_10093(dir))) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"isSideExposed(Lnet/minecraft/world/BlockRenderView;IIILnet/minecraft/util/math/Direction;F)Z"}, cancellable=true)
    private void isSideExposed(class_1920 world, int x, int y, int z, class_2350 dir, float height, CallbackInfoReturnable<Boolean> cir) {
        class_2338 pos;
        if (!SelectiveRenderingManager.blockRenderMode.equals((Object)SelectiveRenderingManager.RenderMode.OFF) && !SelectiveRenderingManager.shouldRenderBlock(world.method_8320((pos = new class_2338(x, y, z)).method_10093(dir)), pos.method_10093(dir))) {
            cir.setReturnValue((Object)true);
        }
    }

    @WrapOperation(method={"writeQuad"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/vertex/builder/ChunkMeshBufferBuilder;push([Lnet/caffeinemc/mods/sodium/client/render/chunk/vertex/format/ChunkVertexEncoder$Vertex;Lnet/caffeinemc/mods/sodium/client/render/chunk/terrain/material/Material;)V")})
    private void wrapVertex(ChunkMeshBufferBuilder instance, ChunkVertexEncoder.Vertex[] vertices, Material material, Operation<Void> original) {
        float alpha = LucidityConfig.fluidTransparency;
        if (alpha == 1.01f) {
            original.call(new Object[]{instance, vertices, material});
        } else {
            if (material.isTranslucent()) {
                for (int i = 0; i < 4; ++i) {
                    int color = this.quadColors[i];
                    int r = color & 0xFF;
                    int g = color >> 8 & 0xFF;
                    int b = color >> 16 & 0xFF;
                    int a = (int)(alpha * 255.0f) & 0xFF;
                    this.quadColors[i] = a << 24 | b << 16 | g << 8 | r;
                    vertices[i].color = this.quadColors[i];
                }
            }
            original.call(new Object[]{instance, vertices, material});
        }
    }
}

