/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.rendering;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import mypals.ml.Lucidity;
import mypals.ml.config.Keybinds;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.ImageRendering.ImageDataParser;
import mypals.ml.features.ImageRendering.ImageRenderer;
import mypals.ml.features.ImageRendering.configuration.MediaEntry;
import mypals.ml.features.selectiveRendering.AreaBox;
import mypals.ml.features.selectiveRendering.SelectiveRenderingManager;
import mypals.ml.features.selectiveRendering.WandActionsManager;
import mypals.ml.rendering.ShapeRender;
import mypals.ml.rendering.shapes.BoxShape;
import mypals.ml.rendering.shapes.CubeShape;
import mypals.ml.rendering.shapes.LineShape;
import mypals.ml.rendering.shapes.LineStrip;
import mypals.ml.rendering.shapes.OnGroundMarker;
import mypals.ml.rendering.shapes.ShineMarker;
import mypals.ml.rendering.shapes.TextShape;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_9779;
import org.joml.Vector2d;

public class InformationRender {
    public static List<BoxShape> boxes = new CopyOnWriteArrayList<BoxShape>();
    public static ConcurrentHashMap<class_2338, CubeShape> cubes = new ConcurrentHashMap();
    public static List<LineShape> lines = new CopyOnWriteArrayList<LineShape>();
    public static List<LineStrip> multiPointLines = new CopyOnWriteArrayList<LineStrip>();
    public static Map<Color, ConcurrentHashMap<class_243, ShineMarker>> shineMarkers = new ConcurrentHashMap<Color, ConcurrentHashMap<class_243, ShineMarker>>();
    public static ConcurrentHashMap<class_243, TextShape> texts = new ConcurrentHashMap();
    public static ConcurrentHashMap<Map.Entry<class_2338, class_2338>, AreaBox> areaBoxes = new ConcurrentHashMap();
    public static ConcurrentHashMap<class_2338, OnGroundMarker> onGroundMarkers = new ConcurrentHashMap();

    public static boolean isIrisShaderUsed() {
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            return IrisApi.getInstance() != null && IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean isSodiumUsed() {
        return FabricLoader.getInstance().isModLoaded("sodium");
    }

    public static void addBox(BoxShape box) {
        if (!boxes.contains(box)) {
            boxes.add(box);
        }
    }

    public static void addText(TextShape text) {
        texts.put(text.pos, text);
    }

    public static void addCube(CubeShape cube) {
        cubes.put(cube.pos, cube);
    }

    public static void addLine(LineShape line) {
        lines.add(line);
    }

    public static void addLine(LineStrip line) {
        multiPointLines.add(line);
    }

    public static void addShineMarker(ShineMarker shineMarker, int time) {
        ConcurrentHashMap markers = shineMarkers.computeIfAbsent(shineMarker.color, k -> new ConcurrentHashMap());
        markers.compute(shineMarker.pos, (pos, existingMarker) -> {
            if (existingMarker != null) {
                existingMarker.lifeTime = time;
                existingMarker.color = shineMarker.color;
                return existingMarker;
            }
            shineMarker.lifeTime = time;
            return shineMarker;
        });
    }

    public static void addAreaBox(AreaBox areaBox) {
        areaBoxes.put(Map.entry(areaBox.minPos, areaBox.maxPos), areaBox);
    }

    public static void addOnGroundMarker(OnGroundMarker onGroundMarker) {
        onGroundMarkers.put(onGroundMarker.pos, onGroundMarker);
    }

    public static void render(class_4587 matrixStack, class_9779 counter) {
        if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1773.method_19418().method_19332()) {
            try {
                for (MediaEntry mediaEntry : ImageDataParser.images.values()) {
                    ImageRenderer.renderPictureWorldSpace(matrixStack, mediaEntry, new class_243(mediaEntry.getPos()[0], mediaEntry.getPos()[1], mediaEntry.getPos()[2]), new class_243(mediaEntry.getRotation()[0], mediaEntry.getRotation()[1], mediaEntry.getRotation()[2]), new Vector2d(mediaEntry.getScale()[0], mediaEntry.getScale()[1]), LucidityConfig.pixelsPerBlock, 15720000, class_4608.field_21444, counter.method_60636(), false);
                }
                for (BoxShape boxShape : boxes) {
                    boxShape.draw(matrixStack);
                }
                CubeShape.drawCubes(matrixStack, cubes, 0.01f, counter.method_60636());
                InformationRender.drawLines(matrixStack);
                for (Map.Entry entry : shineMarkers.entrySet()) {
                    ShineMarker.drawMultiple(matrixStack, ((ConcurrentHashMap)entry.getValue()).values().stream().toList(), class_310.method_1551().field_1719.field_6012, (Color)entry.getKey());
                }
                OnGroundMarker.drawMultiple(matrixStack, onGroundMarkers.values().stream().toList());
                TextShape.drawMultiple(matrixStack, texts.values().stream().toList(), counter.method_60636());
                for (AreaBox areaBox : areaBoxes.values()) {
                    areaBox.draw(matrixStack, false);
                }
                InformationRender.drawSelectedAreas(matrixStack);
            }
            catch (Exception e) {
                Lucidity.LOGGER.info(e.toString());
            }
        }
    }

    public static void clear() {
        boxes.clear();
        lines.clear();
        cubes.clear();
        texts.clear();
        multiPointLines.clear();
        areaBoxes.clear();
        onGroundMarkers.clear();
        shineMarkers.entrySet().removeIf(entry -> {
            Map markerSet = (Map)entry.getValue();
            markerSet.entrySet().removeIf(marker -> {
                --((ShineMarker)marker.getValue()).lifeTime;
                return ((ShineMarker)marker.getValue()).lifeTime <= 0;
            });
            return markerSet.isEmpty();
        });
    }

    private static void drawSelectedAreas(class_4587 matrixStack) {
        if (class_310.method_1551().field_1724 != null && (class_310.method_1551().field_1724.method_6047().method_7909() == SelectiveRenderingManager.wand || class_310.method_1551().field_1724.method_7325() && LucidityConfig.selectInSpectator.booleanValue())) {
            class_2338 lookingAt;
            class_3965 result = Lucidity.getPlayerLookedBlock((class_1657)class_310.method_1551().field_1724, (class_1937)class_310.method_1551().field_1687);
            class_2338 class_23382 = lookingAt = result.method_17783() == class_239.class_240.field_1332 ? result.method_17777() : class_2338.method_49638((class_2374)result.method_17784());
            if (LucidityConfig.renderSelectionMarker) {
                CubeShape.drawSingle(matrixStack, lookingAt, 0.01f, 0.0f, WandActionsManager.deleteMode ? Color.red : Color.white, 0.2f, false);
            }
            if (WandActionsManager.pos1 != null) {
                ShapeRender.renderSelectionBox(matrixStack, class_310.method_1551().field_1773.method_19418(), 0.0f);
            }
            List<AreaBox> areasToDelete = WandActionsManager.getAreasToDelete(lookingAt, false);
            if (Keybinds.deleteArea.method_1434()) {
                for (AreaBox selectedArea : SelectiveRenderingManager.selectedAreas) {
                    if (areasToDelete.contains(selectedArea)) {
                        selectedArea.draw(matrixStack, Color.red, 0.1f, true);
                        continue;
                    }
                    selectedArea.draw(matrixStack, Color.white, 0.01f, true);
                }
            }
        }
    }

    private static void drawLines(class_4587 matrixStack) {
        LineShape.drawLines(matrixStack, lines);
        LineStrip.drawLineStrips(matrixStack, multiPointLines);
    }
}

