/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.rendering.shapes;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class LineShape {
    private static double lastTickPosX;
    private static double lastTickPosY;
    private static double lastTickPosZ;
    public class_243 start;
    public class_243 end;
    public float alpha;
    public Color color;
    public boolean seeThrough;

    public LineShape(class_243 start, class_243 end, Color color, float alpha, boolean seeThrough) {
        this.start = start;
        this.end = end;
        this.alpha = alpha;
        this.color = color;
        this.seeThrough = seeThrough;
    }

    public static void drawLines(class_4587 matrixStack, List<LineShape> lines) {
        class_287 buffer;
        class_289 tessellator;
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.method_1561().field_4692 == null || client.field_1724 == null) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        matrixStack.method_22903();
        GlStateManager._enableBlend();
        RenderSystem.lineWidth((float)5.0f);
        List opaqueLines = lines.stream().filter(line -> !line.seeThrough).collect(Collectors.toList());
        List seeThroughLines = lines.stream().filter(line -> line.seeThrough).collect(Collectors.toList());
        if (!opaqueLines.isEmpty()) {
            tessellator = class_289.method_1348();
            buffer = tessellator.method_60827(VertexFormat.class_5596.field_29344, class_290.field_1576);
            for (LineShape line2 : opaqueLines) {
                lastTickPosX = camera.method_19326().method_10216();
                lastTickPosY = camera.method_19326().method_10214();
                lastTickPosZ = camera.method_19326().method_10215();
                float x = (float)(line2.start.method_10216() - class_3532.method_16436((double)0.0, (double)lastTickPosX, (double)camera.method_19326().method_10216()));
                float y = (float)(line2.start.method_10214() - class_3532.method_16436((double)0.0, (double)lastTickPosY, (double)camera.method_19326().method_10214()));
                float z = (float)(line2.start.method_10215() - class_3532.method_16436((double)0.0, (double)lastTickPosZ, (double)camera.method_19326().method_10215()));
                float red = (float)(line2.color.getRGB() >> 16 & 0xFF) / 255.0f;
                float green = (float)(line2.color.getRGB() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(line2.color.getRGB() & 0xFF) / 255.0f;
                matrixStack.method_22903();
                matrixStack.method_46416(x, y, z);
                Matrix4f modelViewMatrix = matrixStack.method_23760().method_23761();
                buffer.method_22918(modelViewMatrix, 0.0f, 0.0f, 0.0f).method_22915(red, green, blue, line2.alpha);
                buffer.method_22918(modelViewMatrix, (float)(line2.end.field_1352 - line2.start.field_1352), (float)(line2.end.field_1351 - line2.start.field_1351), (float)(line2.end.field_1350 - line2.start.field_1350)).method_22915(red, green, blue, line2.alpha);
                matrixStack.method_22909();
            }
            GlStateManager._enableDepthTest();
            class_1921.method_49043((double)2.0).method_60895(buffer.method_60800());
        }
        if (!seeThroughLines.isEmpty()) {
            tessellator = class_289.method_1348();
            buffer = tessellator.method_60827(VertexFormat.class_5596.field_29344, class_290.field_1576);
            for (LineShape line2 : seeThroughLines) {
                double x = line2.start.method_10216() - cameraPos.method_10216();
                double y = line2.start.method_10214() - cameraPos.method_10214();
                double z = line2.start.method_10215() - cameraPos.method_10215();
                float red = (float)(line2.color.getRGB() >> 16 & 0xFF) / 255.0f;
                float green = (float)(line2.color.getRGB() >> 8 & 0xFF) / 255.0f;
                float blue = (float)(line2.color.getRGB() & 0xFF) / 255.0f;
                matrixStack.method_22903();
                matrixStack.method_22904(x, y, z);
                Matrix4f modelViewMatrix = matrixStack.method_23760().method_23761();
                buffer.method_22918(modelViewMatrix, 0.0f, 0.0f, 0.0f).method_22915(red, green, blue, line2.alpha);
                buffer.method_22918(modelViewMatrix, (float)(line2.end.field_1352 - line2.start.field_1352), (float)(line2.end.field_1351 - line2.start.field_1351), (float)(line2.end.field_1350 - line2.start.field_1350)).method_22915(red, green, blue, line2.alpha);
                matrixStack.method_22909();
            }
            GlStateManager._disableDepthTest();
            class_1921.method_49043((double)2.0).method_60895(buffer.method_60800());
            GlStateManager._enableDepthTest();
        }
        GlStateManager._disableBlend();
        matrixStack.method_22909();
    }

    public static void draw(class_4587 matrixStack, class_243 start, class_243 end, Color color, float alpha, boolean seeThrough) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (camera.method_19332() && client.method_1561().field_4692 != null && client.field_1724 != null) {
            double x = start.method_10216() - camera.method_19326().method_10216();
            double y = start.method_10214() - camera.method_19326().method_10214();
            double z = start.method_10215() - camera.method_19326().method_10215();
            float red = (float)(color.getRGB() >> 16 & 0xFF) / 255.0f;
            float green = (float)(color.getRGB() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color.getRGB() & 0xFF) / 255.0f;
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_60827(VertexFormat.class_5596.field_29344, class_290.field_1576);
            matrixStack.method_22903();
            matrixStack.method_22904(x, y, z);
            Matrix4f modelViewMatrix = matrixStack.method_23760().method_23761();
            buffer.method_22918(modelViewMatrix, 0.0f, 0.0f, 0.0f).method_22915(red, green, blue, alpha);
            buffer.method_22918(modelViewMatrix, (float)(end.field_1352 - start.field_1352), (float)(end.field_1351 - start.field_1351), (float)(end.field_1350 - start.field_1350)).method_22915(red, green, blue, alpha);
            GlStateManager._enableBlend();
            RenderSystem.lineWidth((float)2.0f);
            if (seeThrough) {
                GlStateManager._disableDepthTest();
            }
            class_1921.method_49043((double)2.0).method_60895(buffer.method_60800());
            GlStateManager._enableDepthTest();
            GlStateManager._disableBlend();
            matrixStack.method_22909();
        }
    }
}

