/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.rendering.shapes;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class QuadShape {
    public class_243 c1;
    public class_243 c2;
    public Color color;
    public float alpha;
    public boolean seeThrough;

    public QuadShape(class_243 c1, class_243 c2, Color color, float alpha, boolean seeThrough) {
        this.c1 = c1;
        this.c2 = c2;
        this.color = color;
        this.alpha = alpha;
        this.seeThrough = seeThrough;
    }

    public static void drawMultiple(class_4587 matrixStack, List<QuadShape> quads) {
        class_287 buffer;
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.method_1561().field_4692 == null || client.field_1724 == null || quads.isEmpty()) {
            return;
        }
        matrixStack.method_22903();
        class_243 cameraPos = camera.method_19326();
        GlStateManager._enableBlend();
        GlStateManager._disableCull();
        List<QuadShape> opaqueQuads = quads.stream().filter(m -> !m.seeThrough).collect(Collectors.toList());
        List<QuadShape> seeThroughQuads = quads.stream().filter(m -> m.seeThrough).collect(Collectors.toList());
        if (!opaqueQuads.isEmpty()) {
            buffer = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            QuadShape.drawQuads(matrixStack, opaqueQuads, cameraPos, buffer);
            GlStateManager._enableDepthTest();
            class_1921.method_49042().method_60895(buffer.method_60800());
        }
        if (!seeThroughQuads.isEmpty()) {
            buffer = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            QuadShape.drawQuads(matrixStack, seeThroughQuads, cameraPos, buffer);
            GlStateManager._disableDepthTest();
            class_1921.method_49042().method_60895(buffer.method_60800());
            GlStateManager._enableDepthTest();
        }
        GlStateManager._enableCull();
        GlStateManager._disableBlend();
        matrixStack.method_22909();
    }

    private static void drawQuads(class_4587 matrixStack, List<QuadShape> quads, class_243 cameraPos, class_287 buffer) {
        for (QuadShape quad : quads) {
            float x = (float)(quad.c1.field_1352 - cameraPos.method_10216());
            float y = (float)(quad.c1.field_1351 - cameraPos.method_10214());
            float z = (float)(quad.c1.field_1350 - cameraPos.method_10215());
            float minX = (float)quad.c1.field_1352;
            float maxX = (float)quad.c2.field_1352;
            float minY = (float)quad.c1.field_1351;
            float maxY = (float)quad.c2.field_1351;
            float minZ = (float)quad.c1.field_1350;
            float maxZ = (float)quad.c2.field_1350;
            float red = (float)quad.color.getRed() / 255.0f;
            float green = (float)quad.color.getGreen() / 255.0f;
            float blue = (float)quad.color.getBlue() / 255.0f;
            float alpha = quad.alpha;
            matrixStack.method_22903();
            matrixStack.method_46416(x, y, z);
            Matrix4f modelViewMatrix = matrixStack.method_23760().method_23761();
            buffer.method_22918(modelViewMatrix, minX, minY, minZ).method_22915(red, green, blue, alpha);
            buffer.method_22918(modelViewMatrix, maxX, minY, minZ).method_22915(red, green, blue, alpha);
            buffer.method_22918(modelViewMatrix, maxX, maxY, maxZ).method_22915(red, green, blue, alpha);
            buffer.method_22918(modelViewMatrix, minX, maxY, maxZ).method_22915(red, green, blue, alpha);
            matrixStack.method_22909();
        }
    }
}

