/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.rendering.shapes;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ShineMarker {
    public class_243 pos;
    public Boolean autoAlpha;
    public Color color;
    public float size;
    public long seed;
    public int lights;
    public float speed;
    public int lifeTime;
    public boolean seeThrough;
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public ShineMarker(class_243 pos, Color color, float size, float speed, int lights, long seed, boolean autoAlpha, boolean seeThrough) {
        this.pos = pos;
        this.color = color;
        this.size = size;
        this.speed = speed;
        this.lights = lights;
        this.seed = seed;
        this.autoAlpha = autoAlpha;
        this.seeThrough = seeThrough;
    }

    public void draw(class_4587 matrixStack, float time, int alpha, Color color) {
        ShineMarker.drawSingle(matrixStack, this, time, color);
    }

    private static void drawSingle(class_4587 matrixStack, ShineMarker marker, float time, Color color) {
        ShineMarker.drawMultiple(matrixStack, Collections.singletonList(marker), time, color);
    }

    public static void drawMultiple(class_4587 matrixStack, List<ShineMarker> markers, float time, Color color) {
        class_287 buffer;
        class_310 client = class_310.method_1551();
        class_4184 cam = client.field_1773.method_19418();
        if (!cam.method_19332() || client.field_1724 == null || markers.isEmpty()) {
            return;
        }
        matrixStack.method_22903();
        class_243 cameraPos = cam.method_19326();
        float lastTickPosX = (float)cameraPos.method_10216();
        float lastTickPosY = (float)cameraPos.method_10214();
        float lastTickPosZ = (float)cameraPos.method_10215();
        GlStateManager._enableBlend();
        GlStateManager._enableDepthTest();
        List<ShineMarker> opaqueMarkers = markers.stream().filter(m -> !m.seeThrough).collect(Collectors.toList());
        List<ShineMarker> seeThroughMarkers = markers.stream().filter(m -> m.seeThrough).collect(Collectors.toList());
        if (!opaqueMarkers.isEmpty()) {
            buffer = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            ShineMarker.drawMarkers(matrixStack, opaqueMarkers, time, cameraPos, lastTickPosX, lastTickPosY, lastTickPosZ, buffer);
            GlStateManager._enableDepthTest();
            ShineMarker.setShaderColor(client, false, color);
            class_1921.method_49042().method_60895(buffer.method_60800());
        }
        if (!seeThroughMarkers.isEmpty()) {
            buffer = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            ShineMarker.drawMarkers(matrixStack, seeThroughMarkers, time, cameraPos, lastTickPosX, lastTickPosY, lastTickPosZ, buffer);
            GlStateManager._disableDepthTest();
            ShineMarker.setShaderColor(client, true, color);
            class_1921.method_49042().method_60895(buffer.method_60800());
            GlStateManager._enableDepthTest();
        }
        GlStateManager._disableBlend();
        matrixStack.method_22909();
    }

    private static void drawMarkers(class_4587 matrixStack, List<ShineMarker> markers, float time, class_243 cameraPos, float lastTickPosX, float lastTickPosY, float lastTickPosZ, class_287 buffer) {
        Random random = new Random();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Quaternionf quaternionf = new Quaternionf();
        for (ShineMarker marker : markers) {
            random.setSeed(marker.seed);
            float time1 = time * marker.speed * 0.05f;
            float scale = Math.min(marker.size, ShineMarker.calculateScale(class_310.method_1551().method_1560().method_19538(), marker.pos)) * (0.9f + random.nextFloat() * 0.2f);
            int alpha = marker.autoAlpha != false ? (int)(ShineMarker.calculateAlpha(class_310.method_1551().field_1719.method_19538(), marker.pos, marker.lifeTime) * 255.0f) : 255;
            float x = (float)(marker.pos.method_10216() - class_3532.method_16436((double)0.0, (double)lastTickPosX, (double)cameraPos.method_10216()));
            float y = (float)(marker.pos.method_10214() - class_3532.method_16436((double)0.0, (double)lastTickPosY, (double)cameraPos.method_10214()));
            float z = (float)(marker.pos.method_10215() - class_3532.method_16436((double)0.0, (double)lastTickPosZ, (double)cameraPos.method_10215()));
            matrixStack.method_22903();
            matrixStack.method_46416(x, y, z);
            for (int i = 0; i < marker.lights; ++i) {
                matrixStack.method_22903();
                quaternionf.rotationXYZ(random.nextFloat() * ((float)Math.PI * 2) + (float)Math.sin((double)time1 * 0.1), random.nextFloat() * ((float)Math.PI * 2) + (float)Math.cos((double)time1 * 0.1), random.nextFloat() * ((float)Math.PI * 2) + (float)Math.sin((double)time1 * 0.2)).rotateXYZ(random.nextFloat() * ((float)Math.PI * 2) + (float)Math.cos((double)time1 * 0.15), random.nextFloat() * ((float)Math.PI * 2) + (float)Math.sin((double)time1 * 0.15), random.nextFloat() * ((float)Math.PI * 2) + (float)Math.cos((double)time1 * 0.2));
                float length = random.nextFloat(0.6f, 1.0f) * 2.0f;
                float width = random.nextFloat(0.6f, 1.0f) * 6.0f;
                vector3f2.set(-HALF_SQRT_3 * length, width, -0.5f * length);
                vector3f3.set(HALF_SQRT_3 * length, width, -0.5f * length);
                vector3f4.set(0.0f, width, 0.5f * length);
                matrixStack.method_22907((Quaternionfc)quaternionf);
                matrixStack.method_22905(scale, scale, scale);
                class_4587.class_4665 positionMatrix = matrixStack.method_23760();
                buffer.method_61032(positionMatrix, vector3f).method_1336(255, 255, 255, alpha).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f).method_1336(255, 255, 255, alpha).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f2).method_1336(marker.color.getRed(), marker.color.getGreen(), marker.color.getBlue(), 0).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f3).method_1336(marker.color.getRed(), marker.color.getGreen(), marker.color.getBlue(), 0).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f).method_1336(255, 255, 255, alpha).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f).method_1336(255, 255, 255, alpha).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f3).method_1336(marker.color.getRed(), marker.color.getGreen(), marker.color.getBlue(), 0).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f4).method_1336(marker.color.getRed(), marker.color.getGreen(), marker.color.getBlue(), 0).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f).method_1336(255, 255, 255, alpha).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f).method_1336(255, 255, 255, alpha).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f4).method_1336(marker.color.getRed(), marker.color.getGreen(), marker.color.getBlue(), 0).method_60803(240);
                buffer.method_61032(positionMatrix, vector3f2).method_1336(marker.color.getRed(), marker.color.getGreen(), marker.color.getBlue(), 0).method_60803(240);
                matrixStack.method_22909();
            }
            matrixStack.method_22909();
        }
    }

    private static void setShaderColor(class_310 client, boolean seeThrough, Color color) {
    }

    public static float calculateScale(class_243 viewPos, class_243 pos) {
        double maxDist = 500.0;
        double dist = Math.min(viewPos.method_1022(pos), maxDist);
        float f = (float)Math.pow(Math.sin(dist / maxDist * Math.PI), 0.5);
        return f * 3.0f;
    }

    public static float calculateAlpha(class_243 viewPos, class_243 pos, double lifeTime) {
        double maxDist = 5.0;
        double dist = Math.min(viewPos.method_1022(pos), maxDist);
        double a = dist >= maxDist ? ShineMarker.mapAlpha(lifeTime, 0.0f, 30.0f) : dist / maxDist;
        return (float)a;
    }

    public static double mapAlpha(double x, float min, float max) {
        if (x < (double)min) {
            x = min;
        }
        if (x > (double)max) {
            x = max;
        }
        return (x - (double)min) / (double)(max - min);
    }
}

