/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.rendering.shapes;

import com.mojang.blaze3d.opengl.GlStateManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mypals.ml.rendering.ShapeRender;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class TextShape {
    private static double lastTickPosX;
    private static double lastTickPosY;
    private static double lastTickPosZ;
    public ArrayList<String> texts;
    public class_243 pos;
    public float size;
    public ArrayList<Color> color;
    public float alpha;
    public boolean seeThrough;

    public TextShape(ArrayList<String> text, class_243 pos, float size, ArrayList<Color> color, float alpha, boolean seeThrough) {
        this.texts = text;
        this.pos = pos;
        this.size = size;
        this.color = color;
        this.alpha = alpha;
        this.seeThrough = seeThrough;
    }

    public static void drawMultiple(class_4587 matrices, List<TextShape> shapes, float tickDelta) {
        class_4597.class_4598 immediate;
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.method_1561().field_4692 == null || client.field_1724 == null || shapes.isEmpty()) {
            return;
        }
        matrices.method_22903();
        class_243 cameraPos = camera.method_19326();
        class_327 textRenderer = client.field_1772;
        GlStateManager._enableBlend();
        List<TextShape> opaqueShapes = shapes.stream().filter(shape -> !shape.seeThrough).collect(Collectors.toList());
        List<TextShape> seeThroughShapes = shapes.stream().filter(shape -> shape.seeThrough).collect(Collectors.toList());
        if (!opaqueShapes.isEmpty()) {
            immediate = ShapeRender.getVertexConsumer();
            TextShape.drawShapes(matrices, opaqueShapes, tickDelta, cameraPos, textRenderer, (class_4597)immediate, false);
            GlStateManager._enableDepthTest();
            immediate.method_22993();
        }
        if (!seeThroughShapes.isEmpty()) {
            immediate = ShapeRender.getVertexConsumer();
            TextShape.drawShapes(matrices, seeThroughShapes, tickDelta, cameraPos, textRenderer, (class_4597)immediate, true);
            GlStateManager._disableDepthTest();
            immediate.method_22993();
            GlStateManager._enableDepthTest();
        }
        GlStateManager._disableBlend();
        matrices.method_22909();
    }

    private static void drawShapes(class_4587 matrices, List<TextShape> shapes, float tickDelta, class_243 cameraPos, class_327 textRenderer, class_4597 immediate, boolean seeThrough) {
        for (TextShape shape : shapes) {
            if (shape.texts.isEmpty()) continue;
            matrices.method_22903();
            float x = (float)(shape.pos.method_10216() - cameraPos.method_10216());
            float y = (float)(shape.pos.method_10214() - cameraPos.method_10214());
            float z = (float)(shape.pos.method_10215() - cameraPos.method_10215());
            matrices.method_46416(x, y, z);
            matrices.method_22907((Quaternionfc)class_310.method_1551().field_1773.method_19418().method_23767());
            matrices.method_22905(shape.size, -shape.size, 1.0f);
            Matrix4f modelViewMatrix = matrices.method_23760().method_23761();
            float[] lineHeights = new float[shape.texts.size()];
            float totalHeight = 0.0f;
            for (int i = 0; i < shape.texts.size(); ++i) {
                lineHeights[i] = (float)textRenderer.method_1713(shape.texts.get(i), Integer.MAX_VALUE) * 1.25f;
                totalHeight += lineHeights[i];
            }
            float renderYBase = -totalHeight / 2.0f;
            for (int i = 0; i < shape.texts.size(); ++i) {
                String text = shape.texts.get(i);
                float renderX = (float)(-textRenderer.method_1727(text)) * 0.5f;
                float renderY = renderYBase + (i > 0 ? lineHeights[i - 1] : 0.0f);
                int colorValue = shape.color.size() > i && shape.color.get(i) != null ? shape.color.get(i).getRGB() : Color.WHITE.getRGB();
                textRenderer.method_27521(text, renderX, renderY, colorValue, true, modelViewMatrix, immediate, seeThrough ? class_327.class_6415.field_33994 : class_327.class_6415.field_33993, 0, 0xF000F0);
                if (i <= 0) continue;
                renderYBase += lineHeights[i - 1];
            }
            matrices.method_22909();
        }
    }
}

