/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.ImageRendering;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import mypals.ml.Lucidity;
import mypals.ml.features.ImageRendering.ImageDataParser;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class GIFHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GifFrameData createGifTextures(String source, String baseName) {
        ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
        ArrayList<Integer> delays = new ArrayList<Integer>();
        class_1060 textureManager = class_310.method_1551().method_1531();
        ImageInputStream imageInputStream = null;
        ImageReader reader = null;
        InputStream inputStream = null;
        try {
            Object file;
            if (source.startsWith("http://") || source.startsWith("https://")) {
                URL imageUrl = new URL(source);
                HttpURLConnection connection = (HttpURLConnection)imageUrl.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(5000);
                String contentType = connection.getContentType();
                if (contentType == null || !contentType.toLowerCase().contains("gif")) {
                    Lucidity.LOGGER.warn("URL {} \u4e0d\u6307\u5411 GIF \u6587\u4ef6 (Content-Type: {})", (Object)source, (Object)contentType);
                    identifiers.add(ImageDataParser.LOST);
                    connection.disconnect();
                    GifFrameData gifFrameData = new GifFrameData(identifiers, delays);
                    return gifFrameData;
                }
                inputStream = new BufferedInputStream(connection.getInputStream());
                byte[] data = inputStream.readAllBytes();
                imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
                connection.disconnect();
            } else {
                file = new File(source);
                if (!((File)file).exists() || !((File)file).isFile()) {
                    Lucidity.LOGGER.warn("\u6587\u4ef6 {} \u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6587\u4ef6", (Object)source);
                    identifiers.add(ImageDataParser.LOST);
                    GifFrameData connection = new GifFrameData(identifiers, delays);
                    return connection;
                }
                inputStream = new BufferedInputStream(Files.newInputStream(((File)file).toPath(), new OpenOption[0]));
                byte[] data = inputStream.readAllBytes();
                imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            }
            reader = GIFHandler.getGifReader(imageInputStream);
            if (reader == null) {
                identifiers.add(ImageDataParser.LOST);
                file = new GifFrameData(identifiers, delays);
                return file;
            }
            int frameCount = reader.getNumImages(true);
            BufferedImage previousFrame = null;
            for (int i = 0; i < frameCount; ++i) {
                BufferedImage frame = reader.read(i);
                IIOMetadata metadata = reader.getImageMetadata(i);
                String metaFormat = metadata.getNativeMetadataFormatName();
                IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metaFormat);
                IIOMetadataNode imgDescr = (IIOMetadataNode)root.getElementsByTagName("ImageDescriptor").item(0);
                int x = Integer.parseInt(imgDescr.getAttribute("imageLeftPosition"));
                int y = Integer.parseInt(imgDescr.getAttribute("imageTopPosition"));
                IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                String disposalMethod = gce.getAttribute("disposalMethod");
                int delay = Integer.parseInt(gce.getAttribute("delayTime")) * 10;
                BufferedImage fullFrame = GIFHandler.mergeFrames(previousFrame, frame, disposalMethod, reader, i, x, y);
                class_1011 nativeImage = GIFHandler.convertBufferedImageToNativeImage(fullFrame);
                class_2960 frameIdentifier = class_2960.method_60655((String)"lucidity", (String)("textures/temp/" + baseName + "_frame_" + i));
                identifiers.add(frameIdentifier);
                delays.add(delay);
                previousFrame = !disposalMethod.equals("restoreToBackgroundColor") ? GIFHandler.copyBufferedImage(fullFrame) : null;
                class_1011 finalNativeImage = nativeImage;
                class_2960 finalFrameIdentifier = frameIdentifier;
                class_310.method_1551().execute(() -> textureManager.method_4616(finalFrameIdentifier, (class_1044)new class_1043(() -> ((class_2960)frameIdentifier).method_42094(), finalNativeImage)));
            }
        }
        catch (IOException e) {
            Lucidity.LOGGER.error("\u65e0\u6cd5\u4ece {} \u521b\u5efa GIF \u7eb9\u7406: {}", (Object)source, (Object)e.getMessage());
            e.printStackTrace();
            identifiers.add(ImageDataParser.LOST);
        }
        finally {
            try {
                if (reader != null) {
                    reader.dispose();
                }
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Lucidity.LOGGER.error("\u5173\u95ed\u8d44\u6e90\u65f6\u51fa\u9519: {}", (Object)e.getMessage());
            }
        }
        if (identifiers.isEmpty()) {
            identifiers.add(ImageDataParser.LOST);
        }
        return new GifFrameData(identifiers, delays);
    }

    private static ImageReader getGifReader(ImageInputStream imageInputStream) {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("gif");
        if (!readers.hasNext()) {
            Lucidity.LOGGER.error("\u672a\u627e\u5230 GIF\u7684ImageReader");
            return null;
        }
        ImageReader reader = readers.next();
        reader.setInput(imageInputStream);
        return reader;
    }

    private static BufferedImage mergeFrames(BufferedImage previousFrame, BufferedImage currentFrame, String disposalMethod, ImageReader reader, int index, int x, int y) throws IOException {
        IIOMetadataNode root;
        IIOMetadataNode gce;
        IIOMetadata metadata;
        int width = reader.getWidth(0);
        int height = reader.getHeight(0);
        BufferedImage fullFrame = new BufferedImage(width, height, 2);
        if (previousFrame != null && !disposalMethod.equals("restoreToBackgroundColor")) {
            fullFrame.getGraphics().drawImage(previousFrame, 0, 0, null);
        } else if (disposalMethod.equals("restoreToBackgroundColor") && (metadata = reader.getStreamMetadata()) != null && (gce = (IIOMetadataNode)(root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName())).getElementsByTagName("GlobalColorTable").item(0)) != null) {
            fullFrame.getGraphics().setColor(new Color(0, 0, 0, 0));
            fullFrame.getGraphics().fillRect(0, 0, width, height);
        }
        fullFrame.getGraphics().drawImage(currentFrame, x, y, null);
        return fullFrame;
    }

    private static BufferedImage copyBufferedImage(BufferedImage source) {
        if (source == null) {
            return null;
        }
        BufferedImage copy = new BufferedImage(source.getWidth(), source.getHeight(), 2);
        copy.getGraphics().drawImage(source, 0, 0, null);
        return copy;
    }

    private static class_1011 convertBufferedImageToNativeImage(BufferedImage bufferedImage) {
        class_1011 nativeImage = new class_1011(class_1011.class_1012.field_4997, bufferedImage.getWidth(), bufferedImage.getHeight(), false);
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                int argb = bufferedImage.getRGB(x, y);
                nativeImage.method_61941(x, y, argb);
            }
        }
        return nativeImage;
    }

    public static class GifFrameData {
        public List<class_2960> identifiers;
        public List<Integer> delays;

        public GifFrameData(List<class_2960> identifiers, List<Integer> delays) {
            this.identifiers = identifiers;
            this.delays = delays;
        }
    }
}

