/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.ImageRendering;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import mypals.ml.Lucidity;

public class MediaTypeDetector {
    /*
     * Enabled aggressive exception aggregation
     */
    public static MediaType detectMediaType(String source) {
        MediaType typeByExtension = MediaTypeDetector.guessMediaTypeByExtension(source);
        Lucidity.LOGGER.debug("Guessed media type by extension for {}: {}", (Object)source, (Object)typeByExtension);
        try {
            if (source.startsWith("http://") || source.startsWith("https://")) {
                URL url = new URL(source);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                connection.setConnectTimeout(5000);
                String contentType = connection.getContentType();
                MediaType typeByContentType = MediaTypeDetector.guessMediaTypeByContentType(contentType);
                if (typeByContentType == MediaType.VIDEO || typeByContentType == MediaType.GIF) {
                    connection.disconnect();
                    return typeByContentType;
                }
                try {
                    MediaType mediaType;
                    block20: {
                        InputStream inputStream = connection.getInputStream();
                        try {
                            MediaType typeByHeader;
                            mediaType = typeByHeader = MediaTypeDetector.detectMediaTypeByHeader(inputStream);
                            if (inputStream == null) break block20;
                        }
                        catch (Throwable throwable) {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    return mediaType;
                }
                finally {
                    connection.disconnect();
                }
            }
            File file = new File(source);
            if (!file.exists() || !file.isFile()) {
                return MediaType.UNKNOWN;
            }
            try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                MediaType typeByHeader;
                MediaType mediaType = typeByHeader = MediaTypeDetector.detectMediaTypeByHeader(inputStream);
                return mediaType;
            }
        }
        catch (IOException e) {
            return MediaType.UNKNOWN;
        }
    }

    private static MediaType guessMediaTypeByExtension(String source) {
        String lowerSource = source.toLowerCase();
        if (lowerSource.endsWith(".png") || lowerSource.endsWith(".jpg") || lowerSource.endsWith(".jpeg") || lowerSource.endsWith(".webp") || lowerSource.endsWith(".bmp")) {
            return MediaType.IMAGE;
        }
        if (lowerSource.endsWith(".gif")) {
            return MediaType.GIF;
        }
        if (lowerSource.endsWith(".mp4") || lowerSource.endsWith(".avi") || lowerSource.endsWith(".mov")) {
            return MediaType.VIDEO;
        }
        return MediaType.UNKNOWN;
    }

    private static MediaType guessMediaTypeByContentType(String contentType) {
        if (contentType == null) {
            return MediaType.UNKNOWN;
        }
        if ((contentType = contentType.toLowerCase()).contains("image/gif")) {
            return MediaType.GIF;
        }
        if (contentType.contains("image/")) {
            return MediaType.IMAGE;
        }
        if (contentType.contains("video/")) {
            return MediaType.VIDEO;
        }
        return MediaType.UNKNOWN;
    }

    private static MediaType detectMediaTypeByHeader(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(32);
        byte[] header = new byte[32];
        int bytesRead = inputStream.read(header);
        inputStream.reset();
        if (bytesRead < 8) {
            return MediaType.UNKNOWN;
        }
        if (header[0] == 71 && header[1] == 73 && header[2] == 70 && header[3] == 56) {
            return MediaType.GIF;
        }
        if (header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71) {
            return MediaType.IMAGE;
        }
        if (header[0] == -1 && header[1] == -40) {
            return MediaType.IMAGE;
        }
        if (header[0] == 82 && header[1] == 73 && header[2] == 70 && header[3] == 70 && header[8] == 87 && header[9] == 69 && header[10] == 66 && header[11] == 80) {
            return MediaType.IMAGE;
        }
        if (header[0] == 66 && header[1] == 77) {
            return MediaType.IMAGE;
        }
        if (header[4] == 102 && header[5] == 116 && header[6] == 121 && header[7] == 112) {
            return MediaType.VIDEO;
        }
        if (header[0] == 82 && header[1] == 73 && header[2] == 70 && header[3] == 70 && header[8] == 65 && header[9] == 86 && header[10] == 73) {
            return MediaType.VIDEO;
        }
        return MediaType.UNKNOWN;
    }

    public static enum MediaType {
        IMAGE("IMAGE"),
        GIF("GIF"),
        VIDEO("VIDEO"),
        UNKNOWN("UNKNOWN");

        private final String key;

        private MediaType(String value) {
            this.key = value;
        }

        public String getKey() {
            return this.key;
        }
    }
}

