/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.OreFinder;

import java.awt.Color;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.OreFinder.MineralFinder;
import mypals.ml.rendering.InformationRender;
import mypals.ml.rendering.shapes.ShineMarker;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class OreResolver {
    public static ConcurrentHashMap<class_2338, Color> recordedOres = new ConcurrentHashMap();

    public static void onClientTick() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        Random random = new Random();
        if (world == null || client.field_1724 == null) {
            return;
        }
        class_2338 playerPos = client.field_1724.method_24515();
        for (Map.Entry<class_2338, Color> entry : recordedOres.entrySet()) {
            class_243 pos = entry.getKey().method_10062().method_46558();
            if (!OreResolver.isInDistance(class_2338.method_49638((class_2374)pos), LucidityConfig.oreHighlightRange)) continue;
            InformationRender.addShineMarker(new ShineMarker(pos, entry.getValue(), 0.4f, random.nextInt(1, 3), random.nextInt(5, 7), entry.getKey().hashCode(), true, false), 30);
        }
    }

    public static int[] decodeColor(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new int[]{red, green, blue, alpha};
    }

    public static boolean isInDistance(class_2338 blockPos, double maxDistance) {
        class_746 player = class_310.method_1551().field_1724;
        double playerX = player.method_23317();
        double playerZ = player.method_23321();
        double blockX = (double)blockPos.method_10263() + 0.5;
        double blockZ = (double)blockPos.method_10260() + 0.5;
        double distance = Math.sqrt(Math.pow(playerX - blockX, 2.0) + Math.pow(playerZ - blockZ, 2.0));
        return distance <= maxDistance;
    }

    public static void tryAddToRecordedOreListOrRemove(class_2338 pos) {
        if (MineralFinder.isExposedMineral((class_1937)class_310.method_1551().field_1687, pos)) {
            class_2248 block = class_310.method_1551().field_1687.method_8320(pos).method_26204();
            boolean haveOreNearBy = false;
            Color color = MineralFinder.MINERAL_BLOCKS.get(block);
            for (class_2350 direction2 : class_2350.values()) {
                if (!recordedOres.containsKey(pos.method_10093(direction2)) || !recordedOres.get(pos.method_10093(direction2)).equals(color)) continue;
                haveOreNearBy = true;
            }
            if (!haveOreNearBy) {
                recordedOres.put(pos, color);
            }
        } else {
            recordedOres.remove(pos);
        }
    }
}

