/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.arrowCamera;

import java.util.HashSet;
import java.util.Set;
import mypals.ml.features.arrowCamera.ArrowCameraEntity;
import mypals.ml.features.arrowCamera.ArrowCameraEntityRender;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1667;
import net.minecraft.class_1676;
import net.minecraft.class_1679;
import net.minecraft.class_1685;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ArrowCamera {
    public static ArrowCamera instance;
    public static final class_2960 ARROW_CAMERA_ID;
    public static final class_5321<class_1299<?>> ARROW_CAMERA_KEY;
    public static final class_1299<ArrowCameraEntity> ARROW_CAMERA_ENTITY;
    private static ArrowCameraEntity camera;
    private static boolean hideGUI;
    public static int fovSetting;
    public static int thirdPersonView;
    private static final Set<class_1297> trackedEntities;

    public ArrowCamera() {
        instance = this;
    }

    public static void onClientTick() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (client.field_1690.field_1832.method_1436() && camera != null) {
            ArrowCamera.stopArrowCam();
        }
        if (world != null && client.field_1724 != null) {
            for (class_1297 entity : world.method_18112()) {
                if (!(entity instanceof class_1676)) continue;
                class_1676 arrow = (class_1676)entity;
                if (trackedEntities.contains(entity)) continue;
                if (client.field_1690.field_1867.method_1434() && arrow.method_24921() == client.field_1724) {
                    ArrowCamera.startArrowCam(arrow);
                }
                trackedEntities.add(entity);
            }
        }
        if (camera != null && camera.method_31481()) {
            ArrowCamera.stopArrowCam();
        }
    }

    public static void onInitialize() {
        EntityRendererRegistry.register(ARROW_CAMERA_ENTITY, ArrowCameraEntityRender::new);
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ArrowCamera.stopArrowCam();
            System.out.println("Player disconnected from the server.");
        });
    }

    public static void startArrowCam(class_1676 arrow) {
        if (!ArrowCamera.isInArrowCam()) {
            camera = new ArrowCameraEntity(ARROW_CAMERA_ENTITY, arrow);
            class_310 mc = class_310.method_1551();
            class_638 world = mc.field_1687;
            if (world != null) {
                world.method_53875((class_1297)camera);
                class_315 options = mc.field_1690;
                hideGUI = options.field_1842;
                fovSetting = (Integer)options.method_41808().method_41753();
                thirdPersonView = options.method_31044().method_31034() ? 0 : (options.method_31044().method_31035() ? 1 : 2);
                options.method_31043(class_5498.field_26665);
                options.field_1842 = true;
                options.method_41808().method_41748((Object)((Integer)options.method_41808().method_41753() + 1));
                mc.method_1504((class_1297)camera);
            } else {
                camera = null;
            }
        }
    }

    public static void stopArrowCam() {
        if (ArrowCamera.isInArrowCam()) {
            class_310 mc = class_310.method_1551();
            class_315 options = mc.field_1690;
            options.field_1842 = hideGUI;
            options.method_41808().method_41748((Object)fovSetting);
            if (thirdPersonView == 0) {
                options.method_31043(class_5498.field_26664);
            } else {
                options.method_31043(thirdPersonView == 1 ? class_5498.field_26665 : class_5498.field_26666);
            }
            mc.method_1504((class_1297)mc.field_1724);
            if (camera != null && !camera.method_31481()) {
                camera.method_31472();
            }
            camera = null;
        }
    }

    public static boolean isInArrowCam() {
        return camera != null;
    }

    public boolean isArrowInGround(class_1676 projectile) {
        if (projectile instanceof class_1667 || projectile instanceof class_1679 || projectile instanceof class_1685) {
            class_243 end;
            class_310 client = class_310.method_1551();
            if (client == null) {
                return true;
            }
            class_243 start = projectile.method_19538();
            class_3965 result = client.field_1687.method_17742(new class_3959(start, end = start.method_1019(projectile.method_18798().method_1029().method_1021(projectile.method_18798().method_1033())), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)projectile));
            return result.method_17783() == class_239.class_240.field_1332;
        }
        return false;
    }

    static {
        ARROW_CAMERA_ID = class_2960.method_60655((String)"lucidity", (String)"arrow-camera");
        ARROW_CAMERA_KEY = class_5321.method_29179((class_5321)class_7923.field_41177.method_46765(), (class_2960)ARROW_CAMERA_ID);
        ARROW_CAMERA_ENTITY = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)ARROW_CAMERA_ID, (Object)class_1299.class_1300.method_5903(ArrowCameraEntity::new, (class_1311)class_1311.field_17715).method_17687(0.0f, 0.0f).method_5905(ARROW_CAMERA_KEY));
        trackedEntities = new HashSet<class_1297>();
    }
}

