/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.commandHelper.CommandParsers;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import mypals.ml.features.commandHelper.CommandParsers.BasicParsers;
import net.minecraft.class_1297;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7924;

public class ParticleCommandParser {
    public static void parseParticleCommand(String command) {
        Map<String, Object> parameters = ParticleCommandParser.parseParticleCommandParameters(command);
        if (parameters == null) {
            return;
        }
        String name = (String)parameters.get("name");
        double[] position = (double[])parameters.get("position");
        double[] delta = (double[])parameters.get("delta");
        double speed = (Double)parameters.get("speed");
        int count = (Integer)parameters.get("count");
        boolean forceMode = (Boolean)parameters.get("forceMode");
        class_638 world = class_310.method_1551().field_1687;
        if (world == null || name == null || position.length < 3 || delta.length < 3) {
            return;
        }
        class_2394 particle = ParticleCommandParser.getParticleByName(name);
        if (particle == null) {
            return;
        }
        if (count == 0) {
            double dx = delta[0] * speed;
            double dy = delta[1] * speed;
            double dz = delta[2] * speed;
            world.method_8466(particle, forceMode, false, position[0], position[1], position[2], dx, dy, dz);
        } else {
            for (int i = 0; i < count; ++i) {
                double offsetX = ParticleCommandParser.gaussianOffset(position[0], delta[0]);
                double offsetY = ParticleCommandParser.gaussianOffset(position[1], delta[1]);
                double offsetZ = ParticleCommandParser.gaussianOffset(position[2], delta[2]);
                double dx = ParticleCommandParser.gaussianOffset(0.0, speed);
                double dy = ParticleCommandParser.gaussianOffset(0.0, speed);
                double dz = ParticleCommandParser.gaussianOffset(0.0, speed);
                world.method_8466(particle, forceMode, false, offsetX, offsetY, offsetZ, dx, dy, dz);
            }
        }
    }

    private static double gaussianOffset(double mean, double stddev) {
        Random random = new Random();
        return mean + random.nextGaussian() * Math.abs(stddev);
    }

    private static class_2394 getParticleByName(String name) {
        class_2960 id;
        class_2378 particleRegistry = class_310.method_1551().method_1562().method_29091().method_30530(class_7924.field_41210);
        class_2396 type = (class_2396)particleRegistry.method_63535(id = class_2960.method_60654((String)name));
        if (type == null) {
            return null;
        }
        return (class_2394)type;
    }

    public static Map<String, Object> parseParticleCommandParameters(String command) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String[] parts = command.trim().split("\\s+");
        if (parts.length < 2 || !parts[0].equalsIgnoreCase("/particle")) {
            System.out.println("Invalid command format. Expected 'particle <name> <args>'");
            return null;
        }
        parameters.put("name", parts[1]);
        class_746 playerEntity = class_310.method_1551().field_1724;
        double[] position = new double[]{0.0, 0.0, 0.0};
        if (parts.length > 2) {
            position[0] = BasicParsers.parseCoordinate(parts[2], (class_1297)playerEntity, 0);
        }
        if (parts.length > 3) {
            position[1] = BasicParsers.parseCoordinate(parts[3], (class_1297)playerEntity, 1);
        }
        if (parts.length > 4) {
            position[2] = BasicParsers.parseCoordinate(parts[4], (class_1297)playerEntity, 2);
        }
        parameters.put("position", position);
        double[] delta = new double[]{0.0, 0.0, 0.0};
        if (parts.length > 5) {
            delta[0] = BasicParsers.parseCoordinate(parts[5], (class_1297)playerEntity, 0);
        }
        if (parts.length > 6) {
            delta[1] = BasicParsers.parseCoordinate(parts[6], (class_1297)playerEntity, 1);
        }
        if (parts.length > 7) {
            delta[2] = BasicParsers.parseCoordinate(parts[7], (class_1297)playerEntity, 2);
        }
        parameters.put("delta", delta);
        double speed = 0.0;
        if (parts.length > 8) {
            speed = Double.parseDouble(parts[8]);
        }
        parameters.put("speed", speed);
        int count = 1;
        if (parts.length > 9) {
            count = ParticleCommandParser.parseInt(parts[9]);
        }
        parameters.put("count", count);
        boolean forceMode = false;
        if (parts.length > 10) {
            String mode = parts[10];
            forceMode = "force".equalsIgnoreCase(mode);
        }
        parameters.put("forceMode", forceMode);
        return parameters;
    }

    private static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid integer format: " + str);
            return 1;
        }
    }
}

