/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.explosionVisualizer;

import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.EntityToDamage;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.SamplePointsData.RayCastPointInfo.RayCastData;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.SamplePointsData.SamplePointData;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionCastLines.ExplosionCastLine;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionCastLines.PointsOnLine.CastPoint;
import mypals.ml.rendering.InformationRender;
import mypals.ml.rendering.shapes.CubeShape;
import mypals.ml.rendering.shapes.LineShape;
import mypals.ml.rendering.shapes.TextShape;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2189;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;

public class ExplosionInformationManager {
    public static Set<class_2338> blocksToDestroy = new HashSet<class_2338>();
    public static Set<class_2338> blocksCantDestroy = new HashSet<class_2338>();
    public static Set<class_243> explotionCenters = new HashSet<class_243>();
    public static Set<EntityToDamage> entitysToDamage = new HashSet<EntityToDamage>();
    public static Set<SamplePointData> samplePointData = new HashSet<SamplePointData>();
    public static Set<ExplosionCastLine> explosionCastedLines = new HashSet<ExplosionCastLine>();

    public static void resolveExplosionInformations() {
        class_2338 pos = new class_2338(5, 0, 0);
        if (blocksToDestroy != null) {
            class_310 client = class_310.method_1551();
            if (LucidityConfig.showBlockDestroyInfo) {
                for (class_2338 class_23382 : blocksToDestroy) {
                    InformationRender.addText(new TextShape(new ArrayList<String>(Collections.singletonList(LucidityConfig.BlockDestroyIcon)), class_23382.method_46558(), LucidityConfig.BlockDestroyIconSize, new ArrayList<Color>(Collections.singletonList(LucidityConfig.BlockDestroyIconColor)), 1.0f, LucidityConfig.BlockDestroyIconSeeThrow));
                    InformationRender.addCube(new CubeShape(class_23382, 0.2f, LucidityConfig.BlockDestroyIconColor, LucidityConfig.BlockDestroyIconSeeThrow));
                }
                for (class_2338 class_23383 : blocksCantDestroy) {
                    InformationRender.addText(new TextShape(new ArrayList<String>(Collections.singletonList(LucidityConfig.BlockDestroyIcon)), class_23383.method_46558(), LucidityConfig.BlockDestroyIconSize, new ArrayList<Color>(List.of(ExplosionInformationManager.invertColor(LucidityConfig.BlockDestroyIconColor))), 1.0f, LucidityConfig.BlockDestroyIconSeeThrow));
                    InformationRender.addCube(new CubeShape(class_23383, 0.2f, ExplosionInformationManager.invertColor(LucidityConfig.BlockDestroyIconColor), LucidityConfig.BlockDestroyIconSeeThrow));
                }
            }
            if (LucidityConfig.showDamageInfo) {
                for (EntityToDamage entityToDamage : entitysToDamage) {
                    class_1297 class_12972 = entityToDamage.getEntity();
                    if (!(class_12972 instanceof class_1309)) continue;
                    class_1309 livingEntity = (class_1309)class_12972;
                    float health = livingEntity.method_6032() / 2.0f;
                    float height = livingEntity.method_17682();
                    float damage = entityToDamage.getDamage() / 2.0f;
                    float remainingHealth = Math.max(health - damage, 0.0f) > 0.0f ? Math.max(health - damage, 0.0f) : 0.0f;
                    String s = health + "\u2661 - \u2248" + damage + "\u2661";
                    Object s2 = remainingHealth > 0.0f ? "\u2248 " + remainingHealth + "\u2661" : "DIE?";
                    float damageFactor = Math.max(health - damage, 0.0f);
                    int red = (int)(255.0f * (1.0f - damageFactor));
                    int green = (int)(255.0f * damageFactor);
                    int color = red << 16 | green << 8;
                    InformationRender.addText(new TextShape(new ArrayList<CallSite>(List.of(s)), entityToDamage.getEntity().method_19538().method_1031(0.0, (double)height + 0.5, 0.0), 0.015f, new ArrayList<Color>(List.of(new Color(color))), 1.0f, false));
                    InformationRender.addText(new TextShape(new ArrayList<Object>(List.of(s2)), entityToDamage.getEntity().method_19538().method_1031(0.0, (double)height, 0.0), 0.015f, new ArrayList<Color>(List.of(new Color(color))), 1.0f, false));
                }
            }
            for (ExplosionCastLine explosionCastLine : explosionCastedLines) {
                int color = explosionCastLine.getLineColor();
                for (CastPoint p : explosionCastLine.getPoints()) {
                    if (LucidityConfig.EnableAlpha) {
                        color = ExplosionInformationManager.mapAlpha(color, explosionCastLine.getOrgBlastStrength(), p.getStrength());
                    }
                    if (!(p.getStrength() > 0.0f) || class_310.method_1551().field_1687.method_8320(class_2338.method_49638((class_2374)p.getPosition())).method_26204() instanceof class_2189) continue;
                    InformationRender.addText(new TextShape(new ArrayList<String>(Collections.singletonList(LucidityConfig.BlockDetectionRayIcon)), p.getPosition(), LucidityConfig.BlockDetectionRayIconSize, new ArrayList<Color>(List.of(new Color(color))), 1.0f, LucidityConfig.BlockDetectionRaySeeThrow));
                }
                if (explosionCastLine.getPoints().isEmpty()) continue;
                InformationRender.addLine(new LineShape(explosionCastLine.getPoints().getFirst().getPosition(), explosionCastLine.getPoints().getLast().getPosition(), new Color(color), 0.2f, LucidityConfig.BlockDetectionRaySeeThrow));
            }
            for (class_243 class_2432 : explotionCenters) {
                int orangeColor = 16753920;
                String s = "\ud83d\udca5";
                InformationRender.addText(new TextShape(new ArrayList<String>(List.of(s)), class_2432, 0.045f, new ArrayList<Color>(List.of(new Color(orangeColor))), 1.0f, true));
            }
            if (samplePointData != null && LucidityConfig.showRayCastInfo) {
                for (SamplePointData samplePointData : ExplosionInformationManager.samplePointData) {
                    if (samplePointData == null) continue;
                    for (RayCastData r : samplePointData.getCastPointData()) {
                        class_243 org = r.point;
                        class_243 collitionPoint = r.point_hit;
                        boolean hit_target = r.hit_target;
                        if (hit_target) {
                            InformationRender.addText(new TextShape(new ArrayList<String>(Collections.singletonList(LucidityConfig.EntitySamplePoion_Safe_Icon)), org, LucidityConfig.EntitySamplePoionIconSize, new ArrayList<Color>(Collections.singletonList(LucidityConfig.EntitySamplePoion_Safe_IconColor)), 1.0f, LucidityConfig.EntitySamplePointSeeThrow));
                            InformationRender.addLine(new LineShape(org, r.point_hit, LucidityConfig.EntitySamplePoion_Safe_IconColor, 0.2f, LucidityConfig.EntitySamplePointSeeThrow));
                            continue;
                        }
                        InformationRender.addText(new TextShape(new ArrayList<String>(Collections.singletonList(LucidityConfig.EntitySamplePoion_Danger_Icon)), org, LucidityConfig.EntitySamplePoionIconSize, new ArrayList<Color>(Collections.singletonList(LucidityConfig.EntitySamplePoion_Danger_IconColor)), 1.0f, LucidityConfig.EntitySamplePointSeeThrow));
                        InformationRender.addText(new TextShape(new ArrayList<String>(Collections.singletonList(LucidityConfig.EntitySamplePoion_Blocked_Icon)), collitionPoint, LucidityConfig.EntitySamplePoionIconSize - 0.005f, new ArrayList<Color>(Collections.singletonList(LucidityConfig.EntitySamplePoion_Blocked_IconColor)), 1.0f, LucidityConfig.EntitySamplePointSeeThrow));
                        InformationRender.addLine(new LineShape(org, collitionPoint, LucidityConfig.EntitySamplePoion_Blocked_IconColor, 0.5f, LucidityConfig.EntitySamplePointSeeThrow));
                    }
                }
            }
        }
    }

    public static int addAlphaWithDecay(int rgb, double value) {
        double k = 0.5;
        int alpha = (int)(255.0 * (1.0 - Math.exp(-k * value)));
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        int rgba = alpha << 24 | rgb & 0xFFFFFF;
        return rgba;
    }

    public static int mapAlpha(int rgb, double max, double v) {
        v = Math.max(0.0, Math.min(v, max));
        int alpha = (int)(v / (double)((float)max) * 255.0);
        int rgba = alpha << 24 | rgb & 0xFFFFFF;
        return rgba;
    }

    public static Color invertColor(Color color) {
        int r = 255 - color.getRed();
        int g = 255 - color.getGreen();
        int b = 255 - color.getBlue();
        return new Color(r, g, b);
    }

    public static void setBlocksToDestroy(Set<class_2338> blocks) {
        blocksToDestroy = blocks;
    }

    public static void setEntitysToDamage(Set<EntityToDamage> e) {
        entitysToDamage = e;
    }

    public static void setBlocksCantDamage(Set<class_2338> blocks) {
        blocksCantDestroy = blocks;
    }

    public static void setExplotionCenters(Set<class_243> v) {
        explotionCenters = v;
    }

    public static void setSamplePointData(Set<SamplePointData> d) {
        samplePointData = d;
    }

    public static void setCastedLines(Set<ExplosionCastLine> l) {
        explosionCastedLines = l;
    }
}

