/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.explosionVisualizer;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.explosionVisualizer.ExplosionInformationManager;
import mypals.ml.features.explosionVisualizer.ExplosiveObjectFinder;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.EntityToDamage;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.DamagedEntityData.SamplePointsData.SamplePointData;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionAffectedObjects;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionCastLines.ExplosionCastLine;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.ExplosionData;
import mypals.ml.features.explosionVisualizer.explotionAffectdDataManage.FakeExplosion;
import mypals.ml.features.explosionVisualizer.simulate.ExplosionSimulateManager;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class ExplosionVisualizer {
    public static Set<class_2338> blocksToDestroy = new HashSet<class_2338>();
    public static Set<class_2338> blocksCantDestroy = new HashSet<class_2338>();
    public static Set<class_243> explotionCenters = new HashSet<class_243>();
    public static Set<EntityToDamage> entitysToDamage = new HashSet<EntityToDamage>();
    public static Set<SamplePointData> samplePointDatas = new HashSet<SamplePointData>();
    public static Set<FakeExplosion> fakeExplosions = new HashSet<FakeExplosion>();
    public static Set<ExplosionCastLine> explosionCastedLines = new HashSet<ExplosionCastLine>();

    public static void FixRangeIssue() {
        LucidityConfig.CONFIG_HANDLER.instance();
        if (LucidityConfig.Xmax < LucidityConfig.Xmin) {
            LucidityConfig.Xmax = LucidityConfig.Xmin;
        }
        if (LucidityConfig.Ymax < LucidityConfig.Ymin) {
            LucidityConfig.Ymax = LucidityConfig.Ymin;
        }
        if (LucidityConfig.Zmax < LucidityConfig.Zmin) {
            LucidityConfig.Zmax = LucidityConfig.Zmin;
        }
        if (LucidityConfig.LayerMax < LucidityConfig.LayerMin) {
            LucidityConfig.LayerMax = LucidityConfig.LayerMin + 1;
        }
    }

    public static void tick(class_310 client) {
        assert (class_310.method_1551() != null);
        if (LucidityConfig.enableExplosionVisualizer) {
            try {
                explosionCastedLines.clear();
                blocksToDestroy.clear();
                blocksCantDestroy.clear();
                entitysToDamage.clear();
                explotionCenters.clear();
                samplePointDatas.clear();
                if (client.field_1687 != null && client.field_1724 != null) {
                    ExplosionAffectedObjects EAO;
                    class_638 world = client.field_1687;
                    class_2338 playerPos = client.field_1724.method_24515();
                    List<ExplosionData> exBlockPos = ExplosiveObjectFinder.findExplosiveBlocksInRange((class_1937)world, playerPos);
                    List<ExplosionData> exEntityPos = ExplosiveObjectFinder.findExplosiveEntitysInRange((class_1937)world, playerPos);
                    for (ExplosionData explotion : exBlockPos) {
                        class_243 p_d = new class_243(explotion.getPosition().method_46409());
                        class_2382 p_i = new class_2382((int)p_d.field_1352, (int)p_d.field_1351, (int)p_d.field_1350);
                        ExplosionAffectedObjects EAO2 = ExplosionSimulateManager.simulateExplosiveBlocks((class_1937)world, new class_2338(p_i), explotion.getStrength());
                        explosionCastedLines.addAll(EAO2.getExplotionCastedLines());
                        blocksToDestroy.addAll(EAO2.getBlocksToDestriy());
                        blocksCantDestroy.addAll(EAO2.getBlocksShouldBeFine());
                        entitysToDamage.addAll(EAO2.getEntitysToDamage());
                        explotionCenters.addAll(EAO2.getExplotionCenters());
                        samplePointDatas.addAll(EAO2.getSamplePointData());
                    }
                    for (ExplosionData explosion : exEntityPos) {
                        EAO = ExplosionSimulateManager.simulateExplosiveEntitys(explosion.getEntity(), (class_1937)world, explosion.getPosition(), explosion.getStrength());
                        explosionCastedLines.addAll(EAO.getExplotionCastedLines());
                        blocksToDestroy.addAll(EAO.getBlocksToDestriy());
                        blocksCantDestroy.addAll(EAO.getBlocksShouldBeFine());
                        entitysToDamage.addAll(EAO.getEntitysToDamage());
                        explotionCenters.addAll(EAO.getExplotionCenters());
                        samplePointDatas.addAll(EAO.getSamplePointData());
                    }
                    for (FakeExplosion fe : fakeExplosions) {
                        EAO = ExplosionSimulateManager.simulateFakeExplosions((class_1937)world, new class_243((double)fe.x, (double)fe.y, (double)fe.z), fe.power, fe.ignorBlockInside);
                        explosionCastedLines.addAll(EAO.getExplotionCastedLines());
                        blocksToDestroy.addAll(EAO.getBlocksToDestriy());
                        blocksCantDestroy.addAll(EAO.getBlocksShouldBeFine());
                        entitysToDamage.addAll(EAO.getEntitysToDamage());
                        explotionCenters.addAll(EAO.getExplotionCenters());
                        samplePointDatas.addAll(EAO.getSamplePointData());
                    }
                    ExplosionInformationManager.setCastedLines(explosionCastedLines);
                    ExplosionInformationManager.setBlocksToDestroy(blocksToDestroy);
                    ExplosionInformationManager.setBlocksCantDamage(blocksCantDestroy);
                    ExplosionInformationManager.setEntitysToDamage(entitysToDamage);
                    ExplosionInformationManager.setExplotionCenters(explotionCenters);
                    ExplosionInformationManager.setSamplePointData(samplePointDatas);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ExplosionInformationManager.resolveExplosionInformations();
    }
}

