/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.renderMobSpawn;

import java.util.Set;
import net.minecraft.class_1267;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1576;
import net.minecraft.class_1588;
import net.minecraft.class_1627;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7134;
import net.minecraft.class_746;

public class EntitySpawnChacker {
    public static final Set<class_1299<?>> OVERWORLD_ENTITIES = Set.of(class_1299.field_47754, class_1299.field_6108, class_1299.field_49148, class_1299.field_6084, class_1299.field_6132, class_1299.field_6085, class_1299.field_6046, class_1299.field_6067, class_1299.field_37419, class_1299.field_30052, class_1299.field_6139, class_1299.field_6071, class_1299.field_6147, class_1299.field_6074, class_1299.field_6143, class_1299.field_6057, class_1299.field_6104, class_1299.field_6093, class_1299.field_6105, class_1299.field_6042, class_1299.field_6140, class_1299.field_6115, class_1299.field_6137, class_1299.field_6075, class_1299.field_6069, class_1299.field_6079, class_1299.field_6098, class_1299.field_6113, class_1299.field_6077, class_1299.field_6145, class_1299.field_6055, class_1299.field_6051, class_1299.field_6054, class_1299.field_16281, class_1299.field_6090, class_1299.field_17943, class_1299.field_6146, class_1299.field_6134, class_1299.field_6117, class_1299.field_17713, class_1299.field_38095);
    public static final Set<class_1299<?>> NETHER_ENTITIES = Set.of(class_1299.field_6099, class_1299.field_6107, class_1299.field_21973, class_1299.field_6102, class_1299.field_22281, class_1299.field_23214, class_1299.field_6076, class_1299.field_6137, class_1299.field_6050);
    public static final Set<class_1299<?>> END_ENTITIES = Set.of();
    public static final Set<class_1299<?>> UNIVERSAL_ENTITIES = Set.of(class_1299.field_6091);

    public static boolean canSpawnInDark(class_1299<? extends class_1588> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return EntitySpawnChacker.canMobSpawn(type, world, spawnReason, pos, random);
    }

    public static boolean canMobSpawn(class_1299<?> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (!EntitySpawnChacker.isInRightDimension(type)) {
            return false;
        }
        class_2338 blockPos = pos.method_10074();
        return world.method_8320(blockPos).method_26170((class_1922)world, blockPos, type);
    }

    public static boolean isInRightDimension(class_1299<?> type) {
        class_746 player = class_310.method_1551().field_1724;
        class_5321 dimension = (class_5321)player.method_37908().method_40134().method_40230().get();
        if (dimension == class_7134.field_37667) {
            return NETHER_ENTITIES.contains(type) || UNIVERSAL_ENTITIES.contains(type);
        }
        if (dimension == class_7134.field_37668) {
            return END_ENTITIES.contains(type) || UNIVERSAL_ENTITIES.contains(type);
        }
        return OVERWORLD_ENTITIES.contains(type) || UNIVERSAL_ENTITIES.contains(type);
    }

    public static boolean canStraySpawn(class_1299<class_1627> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2338 blockPos = pos;
        while (world.method_8320(blockPos = blockPos.method_10084()).method_27852(class_2246.field_27879)) {
        }
        return EntitySpawnChacker.canSpawnInDark(type, world, spawnReason, pos, random) && (class_3730.method_54986((class_3730)spawnReason) || world.method_8311(blockPos.method_10074()));
    }

    public static boolean canHuskSpawn(class_1299<class_1576> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return EntitySpawnChacker.canSpawnInDark(type, world, spawnReason, pos, random) && world.method_8311(pos);
    }

    public static boolean canSpawnIgnoreLightLevel(class_1299<?> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8407() != class_1267.field_5801 && EntitySpawnChacker.canMobSpawn(type, world, spawnReason, pos, random);
    }

    public static boolean isSpawnDark(class_1936 world, class_2338 pos, class_5819 random) {
        if (world.method_8314(class_1944.field_9284, pos) > random.method_43048(32)) {
            return false;
        }
        class_2874 dimensionType = world.method_8597();
        int i = dimensionType.method_44223();
        if (i < 15 && world.method_8314(class_1944.field_9282, pos) > i) {
            return false;
        }
        int j = world.method_22339(pos);
        return j <= dimensionType.method_44222().method_35008(random);
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(class_3481.field_35567) && EntitySpawnChacker.isLightLevelValidForNaturalSpawn((class_1920)world, pos);
    }

    protected static boolean isLightLevelValidForNaturalSpawn(class_1920 world, class_2338 pos) {
        return world.method_22335(pos, 0) > 8;
    }
}

