/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.renderMobSpawn;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mypals.ml.config.LucidityConfig;
import mypals.ml.features.renderMobSpawn.PossibleSpawnChecker;
import mypals.ml.rendering.InformationRender;
import mypals.ml.rendering.shapes.CubeShape;
import mypals.ml.rendering.shapes.TextShape;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class SpaceScanner {
    public static void findExposedTopSurfaces(class_1937 world, class_2338 center, int range) {
        int minX = center.method_10263() - range;
        int maxX = center.method_10263() + range;
        int minY = center.method_10264() - range;
        int maxY = center.method_10264() + range;
        int minZ = center.method_10260() - range;
        int maxZ = center.method_10260() + range;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    ArrayList<String> mobs = PossibleSpawnChecker.getPossibleSpawnsAt((class_638)world, pos);
                    if (mobs.isEmpty()) continue;
                    InformationRender.addCube(new CubeShape(pos, 0.05f, Color.yellow, true));
                    InformationRender.addText(new TextShape(mobs, pos.method_46558(), LucidityConfig.renderMobSpawnSize, SpaceScanner.assignRainbowColors(mobs), 1.0f, true));
                }
            }
        }
    }

    public static void addSpawnDataToInformationRenderer() {
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        SpaceScanner.findExposedTopSurfaces((class_1937)world, client.field_1724.method_24515(), LucidityConfig.renderMobSpawnRange);
    }

    public static ArrayList<Color> assignRainbowColors(List<String> items) {
        ArrayList<Color> result = new ArrayList<Color>(items.size());
        int n = items.size();
        if (n == 0) {
            return result;
        }
        for (int i = 0; i < n; ++i) {
            float fraction = (float)i / (float)n;
            int rgb = Color.HSBtoRGB(fraction, 1.0f, 1.0f);
            Color color = new Color(rgb);
            result.add(color);
        }
        return result;
    }
}

