/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.features.specialStructureDisplays.treeStructures;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mypals.ml.features.specialStructureDisplays.treeStructures.TreeGrowingBox;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2975;
import net.minecraft.class_3037;
import net.minecraft.class_310;
import net.minecraft.class_4643;
import net.minecraft.class_5141;
import net.minecraft.class_5211;
import net.minecraft.class_5212;
import net.minecraft.class_5214;
import net.minecraft.class_5215;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7386;
import net.minecraft.class_7387;

public class TreeGrowingBoxCalculator {
    public static List<TreeGrowingBox> getStaticTreeBox(class_2338 pos, String treeType) {
        int foliageRadius;
        int secondRandomHeight;
        int firstRandomHeight;
        int baseHeight;
        ArrayList<TreeGrowingBox> boxes = new ArrayList<TreeGrowingBox>();
        class_638 world = class_310.method_1551().field_1687;
        int maxFoliageHeight = 0;
        boolean isLargeTrunk = false;
        switch (treeType) {
            case "OAK": {
                baseHeight = 4;
                firstRandomHeight = 2;
                secondRandomHeight = 0;
                foliageRadius = 2;
                break;
            }
            case "BIRCH": {
                baseHeight = 5;
                firstRandomHeight = 2;
                secondRandomHeight = 0;
                foliageRadius = 2;
                break;
            }
            case "SPRUCE": {
                baseHeight = 5;
                firstRandomHeight = 2;
                secondRandomHeight = 1;
                foliageRadius = 2;
                break;
            }
            case "JUNGLE_TREE": {
                baseHeight = 4;
                firstRandomHeight = 8;
                secondRandomHeight = 0;
                foliageRadius = 3;
                break;
            }
            case "MEGA_JUNGLE_TREE": {
                baseHeight = 10;
                firstRandomHeight = 2;
                secondRandomHeight = 19;
                foliageRadius = 3;
                isLargeTrunk = TreeGrowingBoxCalculator.isSapling2x2((class_1937)world, pos, class_2246.field_10276);
                break;
            }
            case "ACACIA": {
                baseHeight = 5;
                firstRandomHeight = 2;
                secondRandomHeight = 2;
                foliageRadius = 2;
                break;
            }
            case "DARK_OAK": {
                baseHeight = 6;
                firstRandomHeight = 2;
                secondRandomHeight = 1;
                foliageRadius = 2;
                isLargeTrunk = TreeGrowingBoxCalculator.isSapling2x2((class_1937)world, pos, class_2246.field_10160);
                break;
            }
            case "CHERRY": {
                baseHeight = 7;
                firstRandomHeight = 1;
                secondRandomHeight = 0;
                foliageRadius = 5;
                maxFoliageHeight = 16;
                break;
            }
            case "MANGROVE": {
                baseHeight = 4;
                firstRandomHeight = 1;
                secondRandomHeight = 9;
                foliageRadius = 3;
                break;
            }
            default: {
                baseHeight = 4;
                firstRandomHeight = 2;
                secondRandomHeight = 0;
                foliageRadius = 2;
            }
        }
        int maxTrunkHeight = baseHeight + firstRandomHeight + secondRandomHeight;
        class_2338 trunkPos1 = pos;
        class_2338 trunkPos2 = isLargeTrunk ? pos.method_10069(1, maxTrunkHeight, 1) : pos.method_10069(0, maxTrunkHeight, 0);
        boxes.add(new TreeGrowingBox(trunkPos1, trunkPos2, TreeGrowingBox.PartType.TRUNK));
        int foliageBottom = maxTrunkHeight - 3;
        if (treeType.equals("CHERRY")) {
            foliageBottom -= 2;
        }
        class_2338 foliagePos1 = pos.method_10069(-foliageRadius, foliageBottom, -foliageRadius);
        class_2338 foliagePos2 = pos.method_10069(foliageRadius, maxTrunkHeight, foliageRadius);
        boxes.add(new TreeGrowingBox(foliagePos1, foliagePos2, TreeGrowingBox.PartType.FOLIAGE));
        return boxes;
    }

    private static boolean isSapling2x2(class_1937 world, class_2338 pos, class_2248 saplingType) {
        return world.method_8320(pos).method_27852(saplingType) && world.method_8320(pos.method_10069(1, 0, 0)).method_27852(saplingType) && world.method_8320(pos.method_10069(0, 0, 1)).method_27852(saplingType) && world.method_8320(pos.method_10069(1, 0, 1)).method_27852(saplingType);
    }

    public static List<TreeGrowingBox> getTreeGrowingBoxes(class_638 world, class_2338 pos, class_6880<class_2975<?, ?>> registryEntry) {
        class_3037 class_30372;
        ArrayList<TreeGrowingBox> boxes = new ArrayList<TreeGrowingBox>();
        if (registryEntry != null && (class_30372 = ((class_2975)registryEntry.comp_349()).comp_333()) instanceof class_4643) {
            class_7387 rootPlacer;
            class_4643 treeConfig = (class_4643)class_30372;
            class_5141 trunkPlacer = treeConfig.field_24136;
            int baseHeight = trunkPlacer.field_23760;
            int firstRandomHeight = trunkPlacer.field_23761;
            int secondRandomHeight = trunkPlacer.field_23762;
            int maxTrunkHeight = baseHeight + firstRandomHeight + secondRandomHeight;
            int trunkWidth = 1;
            if (trunkPlacer instanceof class_5212 || trunkPlacer instanceof class_5215 || trunkPlacer instanceof class_5211) {
                trunkWidth = 2;
            } else if (trunkPlacer instanceof class_5214) {
                trunkWidth = 4;
            }
            class_2338 trunkPos1 = pos;
            class_2338 trunkPos2 = pos.method_10069(trunkWidth - 1, maxTrunkHeight, trunkWidth - 1);
            boxes.add(new TreeGrowingBox(trunkPos1, trunkPos2, TreeGrowingBox.PartType.TRUNK));
            int maxFoliageRadius = treeConfig.field_24135.field_21296.method_35011();
            int maxOffset = treeConfig.field_24135.field_23753.method_35011();
            class_2338 foliagePos1 = pos.method_10069(-maxFoliageRadius, maxTrunkHeight - 3 - maxOffset, -maxFoliageRadius);
            class_2338 foliagePos2 = pos.method_10069(maxFoliageRadius, maxTrunkHeight + 2 - maxOffset, maxFoliageRadius);
            boxes.add(new TreeGrowingBox(foliagePos1, foliagePos2, TreeGrowingBox.PartType.FOLIAGE));
            Optional rootPlacerOptional = treeConfig.field_38767;
            if (rootPlacerOptional.isPresent() && (rootPlacer = (class_7387)rootPlacerOptional.get()) instanceof class_7386) {
                class_7386 mangroveRootPlacer = (class_7386)rootPlacer;
                int maxRootLength = mangroveRootPlacer.field_38867.comp_723();
                int maxRootWidth = mangroveRootPlacer.field_38867.comp_722();
                class_2338 rootPos1 = pos.method_10069(-maxRootWidth, -maxRootLength, -maxRootWidth);
                class_2338 rootPos2 = pos.method_10069(maxRootWidth, 0, maxRootWidth);
                boxes.add(new TreeGrowingBox(rootPos1, rootPos2, TreeGrowingBox.PartType.ROOT));
            }
        }
        return boxes;
    }
}

