/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.rendering.shapes;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mypals.ml.Lucidity;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class CubeShape {
    public class_2338 pos;
    public float alpha;
    public Color color;
    public boolean seeThrough;

    public CubeShape(class_2338 pos, float alpha, Color color, boolean seeThrough) {
        this.pos = pos;
        this.alpha = alpha;
        this.color = color;
        this.seeThrough = seeThrough;
    }

    public static void drawCubes(class_4587 matrices, Map<class_2338, CubeShape> cubes, float sizeAdd, float tickDelta) {
        class_287 bufferBuilder;
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.field_1724 == null) {
            return;
        }
        matrices.method_22903();
        class_243 cameraPos = camera.method_19326();
        float lastTickPosX = (float)cameraPos.method_10216();
        float lastTickPosY = (float)cameraPos.method_10214();
        float lastTickPosZ = (float)cameraPos.method_10215();
        GlStateManager._enableBlend();
        Set<class_2338> cubePositions = cubes.keySet();
        List<CubeShape> opaqueCubes = cubes.values().stream().filter(cube -> !cube.seeThrough).collect(Collectors.toList());
        List<CubeShape> seeThroughCubes = cubes.values().stream().filter(cube -> cube.seeThrough).collect(Collectors.toList());
        if (!opaqueCubes.isEmpty()) {
            bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            CubeShape.drawCubes(bufferBuilder, matrices, opaqueCubes, sizeAdd, tickDelta, cameraPos, lastTickPosX, lastTickPosY, lastTickPosZ, cubePositions);
            GlStateManager._enableDepthTest();
            if (Lucidity.shaderEnabled()) {
                class_1921.method_49047().method_60895(bufferBuilder.method_60800());
            } else {
                class_1921.method_49042().method_60895(bufferBuilder.method_60800());
            }
        }
        if (!seeThroughCubes.isEmpty()) {
            bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            CubeShape.drawCubes(bufferBuilder, matrices, seeThroughCubes, 0.0f, tickDelta, cameraPos, lastTickPosX, lastTickPosY, lastTickPosZ, cubePositions);
            GlStateManager._disableDepthTest();
            if (Lucidity.shaderEnabled()) {
                class_1921.method_61046().method_60895(bufferBuilder.method_60800());
            } else {
                class_1921.method_49042().method_60895(bufferBuilder.method_60800());
            }
            GlStateManager._enableDepthTest();
        }
        GlStateManager._disableBlend();
        matrices.method_22909();
    }

    private static void drawCubes(class_287 bufferBuilder, class_4587 matrices, List<CubeShape> cubes, float sizeAdd, float tickDelta, class_243 cameraPos, float lastTickPosX, float lastTickPosY, float lastTickPosZ, Set<class_2338> cubePositions) {
        float minOffset = -0.001f - sizeAdd;
        float maxOffset = 1.001f + sizeAdd;
        for (CubeShape cube : cubes) {
            float x = (float)((double)cube.pos.method_10263() - class_3532.method_16436((double)tickDelta, (double)lastTickPosX, (double)cameraPos.method_10216()));
            float y = (float)((double)cube.pos.method_10264() - class_3532.method_16436((double)tickDelta, (double)lastTickPosY, (double)cameraPos.method_10214()));
            float z = (float)((double)cube.pos.method_10260() - class_3532.method_16436((double)tickDelta, (double)lastTickPosZ, (double)cameraPos.method_10215()));
            matrices.method_22903();
            matrices.method_46416(x, y, z);
            Matrix4f modelViewMatrix = matrices.method_23760().method_23761();
            float red = (float)(cube.color.getRGB() >> 16 & 0xFF) / 255.0f;
            float green = (float)(cube.color.getRGB() >> 8 & 0xFF) / 255.0f;
            float blue = (float)(cube.color.getRGB() & 0xFF) / 255.0f;
            class_2338 pos = cube.pos;
            boolean hasUp = cubePositions.contains(pos.method_10084());
            boolean hasDown = cubePositions.contains(pos.method_10074());
            boolean hasNorth = cubePositions.contains(pos.method_10095());
            boolean hasSouth = cubePositions.contains(pos.method_10072());
            boolean hasWest = cubePositions.contains(pos.method_10067());
            boolean hasEast = cubePositions.contains(pos.method_10078());
            if (!hasUp) {
                bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, minOffset).method_22915(red, green, blue, cube.alpha);
            }
            if (!hasDown) {
                bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
            }
            if (!hasWest) {
                bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
            }
            if (!hasEast) {
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, minOffset).method_22915(red, green, blue, cube.alpha);
            }
            if (!hasNorth) {
                bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, minOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, minOffset).method_22915(red, green, blue, cube.alpha);
            }
            if (!hasSouth) {
                bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
                bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, maxOffset).method_22915(red, green, blue, cube.alpha);
            }
            matrices.method_22909();
        }
    }

    public static void drawSingle(class_4587 matrices, class_2338 pos, float sizeAdd, float tickDelta, Color color, float alpha, boolean seeThrough) {
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.field_1724 == null) {
            return;
        }
        matrices.method_22903();
        class_243 cameraPos = camera.method_19326();
        float x = (float)((double)pos.method_10263() - class_3532.method_16436((double)tickDelta, (double)cameraPos.method_10216(), (double)cameraPos.method_10216()));
        float y = (float)((double)pos.method_10264() - class_3532.method_16436((double)tickDelta, (double)cameraPos.method_10214(), (double)cameraPos.method_10214()));
        float z = (float)((double)pos.method_10260() - class_3532.method_16436((double)tickDelta, (double)cameraPos.method_10215(), (double)cameraPos.method_10215()));
        matrices.method_46416(x, y, z);
        Matrix4f modelViewMatrix = matrices.method_23760().method_23761();
        GlStateManager._enableBlend();
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        float minOffset = -0.001f - sizeAdd;
        float maxOffset = 1.001f + sizeAdd;
        float red = (float)(color.getRGB() >> 16 & 0xFF) / 255.0f;
        float green = (float)(color.getRGB() >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color.getRGB() & 0xFF) / 255.0f;
        bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, minOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, maxOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, maxOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, maxOffset, minOffset, maxOffset).method_22915(red, green, blue, alpha);
        bufferBuilder.method_22918(modelViewMatrix, minOffset, minOffset, maxOffset).method_22915(red, green, blue, alpha);
        if (seeThrough) {
            GlStateManager._disableDepthTest();
        }
        if (Lucidity.shaderEnabled()) {
            class_1921.method_61046().method_60895(bufferBuilder.method_60800());
        } else {
            class_1921.method_49042().method_60895(bufferBuilder.method_60800());
        }
        GlStateManager._enableDepthTest();
        GlStateManager._disableBlend();
        matrices.method_22909();
    }
}

