/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.rendering.shapes;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mypals.ml.Lucidity;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.joml.Matrix4f;

public class OnGroundMarker {
    public class_2338 pos;
    public Color color;
    public float alpha;
    public boolean seeThrough;

    public OnGroundMarker(class_2338 pos, Color color, float alpha, boolean seeThrough) {
        this.pos = pos;
        this.color = color;
        this.alpha = alpha;
        this.seeThrough = seeThrough;
    }

    public void draw(class_4587 matrixStack) {
        OnGroundMarker.drawSingle(matrixStack, this);
    }

    private static void drawSingle(class_4587 matrixStack, OnGroundMarker marker) {
        OnGroundMarker.drawMultiple(matrixStack, Collections.singletonList(marker));
    }

    public static void draw(class_4587 matrixStack, class_2338 pos, Color color, float alpha, boolean seeThrough) {
        OnGroundMarker.drawMultiple(matrixStack, Collections.singletonList(new OnGroundMarker(pos, color, alpha, seeThrough)));
    }

    public static void drawMultiple(class_4587 matrixStack, List<OnGroundMarker> markers) {
        class_287 buffer;
        class_310 client = class_310.method_1551();
        class_4184 camera = client.field_1773.method_19418();
        if (!camera.method_19332() || client.method_1561().field_4692 == null || client.field_1724 == null || markers.isEmpty()) {
            return;
        }
        matrixStack.method_22903();
        class_243 cameraPos = camera.method_19326();
        GlStateManager._enableBlend();
        GlStateManager._disableCull();
        List<OnGroundMarker> opaqueMarkers = markers.stream().filter(m -> !m.seeThrough).collect(Collectors.toList());
        List<OnGroundMarker> seeThroughMarkers = markers.stream().filter(m -> m.seeThrough).collect(Collectors.toList());
        if (!opaqueMarkers.isEmpty()) {
            buffer = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            OnGroundMarker.drawMarkers(matrixStack, opaqueMarkers, cameraPos, buffer);
            GlStateManager._enableDepthTest();
            if (Lucidity.shaderEnabled()) {
                class_1921.method_61046().method_60895(buffer.method_60800());
            } else {
                class_1921.method_49042().method_60895(buffer.method_60800());
            }
        }
        if (!seeThroughMarkers.isEmpty()) {
            buffer = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
            OnGroundMarker.drawMarkers(matrixStack, seeThroughMarkers, cameraPos, buffer);
            GlStateManager._disableDepthTest();
            if (Lucidity.shaderEnabled()) {
                class_1921.method_61046().method_60895(buffer.method_60800());
            } else {
                class_1921.method_49042().method_60895(buffer.method_60800());
            }
            GlStateManager._enableDepthTest();
        }
        GlStateManager._enableCull();
        GlStateManager._disableBlend();
        matrixStack.method_22909();
    }

    private static void drawMarkers(class_4587 matrixStack, List<OnGroundMarker> markers, class_243 cameraPos, class_287 buffer) {
        for (OnGroundMarker marker : markers) {
            float size = 0.8f;
            float x = (float)(marker.pos.method_46558().field_1352 - cameraPos.method_10216());
            float y = (float)((double)marker.pos.method_10264() - cameraPos.method_10214());
            float z = (float)(marker.pos.method_46558().field_1350 - cameraPos.method_10215());
            float minX = -(size / 2.0f);
            float maxX = size / 2.0f;
            float minZ = -(size / 2.0f);
            float maxZ = size / 2.0f;
            float red = (float)marker.color.getRed() / 255.0f;
            float green = (float)marker.color.getGreen() / 255.0f;
            float blue = (float)marker.color.getBlue() / 255.0f;
            float alpha = marker.alpha;
            matrixStack.method_22903();
            matrixStack.method_46416(x, y, z);
            Matrix4f modelViewMatrix = matrixStack.method_23760().method_23761();
            buffer.method_22918(modelViewMatrix, minX, 1.0001f, minZ).method_22915(red, green, blue, alpha);
            buffer.method_22918(modelViewMatrix, maxX, 1.0001f, minZ).method_22915(red, green, blue, alpha);
            buffer.method_22918(modelViewMatrix, maxX, 1.0001f, maxZ).method_22915(red, green, blue, alpha);
            buffer.method_22918(modelViewMatrix, minX, 1.0001f, maxZ).method_22915(red, green, blue, alpha);
            matrixStack.method_22909();
        }
    }
}

