/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.animation;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.efekos.fancyhealthbar.client.animation.Animation;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_757;

public class AnimationTrack {
    private final Animation animation;
    private boolean paused = true;
    private boolean loop = false;
    private int frame = 0;
    private int x;
    private int y;
    private boolean invisibleWhenNotPlaying = true;

    public AnimationTrack(Animation animation) {
        this.animation = animation;
    }

    public void draw(class_332 context) {
        if (!(this.isInvisibleWhenNotPlaying() && this.isPaused() || class_3532.method_15340((int)this.frame, (int)0, (int)(this.animation.maxFrames() - 1)) != this.frame)) {
            RenderSystem.setShader(class_757::method_34498);
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            this.animation.getTexture(this.frame).draw(context, this.x, this.y, this.animation.width(), this.animation.height());
            RenderSystem.disableBlend();
            RenderSystem.disableCull();
        }
    }

    private String createDebugInfo() {
        StringBuilder builder = new StringBuilder();
        if (this.paused) {
            builder.append("P");
        }
        if (this.loop) {
            builder.append("L");
        }
        if (this.invisibleWhenNotPlaying) {
            builder.append("I");
        }
        return builder.append(":").append(this.frame).append(":").append(this.x).append(":").append(this.y).toString();
    }

    public boolean isInvisibleWhenNotPlaying() {
        return this.invisibleWhenNotPlaying;
    }

    public void setInvisibleWhenNotPlaying(boolean invisibleWhenNotPlaying) {
        this.invisibleWhenNotPlaying = invisibleWhenNotPlaying;
    }

    public void tick() {
        if (this.isPaused()) {
            return;
        }
        if (this.frame >= this.animation.maxFrames()) {
            if (this.isLoop()) {
                this.setFrame(0);
            } else {
                this.setPaused(true);
            }
        } else {
            this.setFrame(this.frame + 1);
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = class_3532.method_15340((int)frame, (int)0, (int)(this.animation.maxFrames() + 1));
    }

    public boolean isPlaying() {
        return !this.paused;
    }

    public void setPlaying(boolean playing) {
        this.paused = !playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void play() {
        this.setFrame(0);
        this.setPlaying(true);
    }

    public void pause() {
        this.setPlaying(false);
    }

    public void resume() {
        this.setPlaying(true);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void stop() {
        this.setPlaying(false);
    }

    public boolean isOver() {
        return this.isPlaying() && this.getFrame() >= this.animation.maxFrames();
    }
}

