/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.entity;

import net.minecraft.class_332;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2i;

public abstract class HudEntity {
    protected Vector2d velocity = new Vector2d(0.0, 0.0);
    protected Vector2d acceleration = new Vector2d(0.0, 0.0);
    protected double x;
    protected double y;
    protected int lifetime;
    protected int maxLifetime = 100;
    private double drag;

    public HudEntity(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public abstract void render(class_332 var1);

    public void tick() {
        ++this.lifetime;
        if (this.hasPhysics()) {
            this.x += this.velocity.x;
            this.y -= this.velocity.y;
            this.velocity.x *= this.acceleration.x;
            this.velocity.y += this.acceleration.y;
            double d = 1.0 - this.drag;
            this.acceleration.x *= d;
            this.acceleration.y *= d;
            this.velocity.x *= d;
            this.velocity.y *= d;
            if (Math.abs(this.acceleration.x) <= 0.1) {
                this.acceleration.x = 0.0;
            }
            if (Math.abs(this.acceleration.y) <= 0.1) {
                this.acceleration.y = 0.0;
            }
            if (Math.abs(this.velocity.x) <= 0.1) {
                this.velocity.x = 0.0;
            }
            if (Math.abs(this.velocity.y) <= 0.1) {
                this.velocity.y = 0.0;
            }
        }
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public abstract Vector2i getAreaTaken();

    public abstract boolean hasPhysics();

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public double getDrag() {
        return this.drag;
    }

    public void setDrag(double drag) {
        this.drag = drag;
    }

    public boolean isVisible(int screenWidth, int screenHeight) {
        Vector2i area = this.getAreaTaken();
        return this.x + (double)area.x <= (double)screenWidth || this.y + (double)area.y <= (double)screenHeight;
    }

    public void setAcceleration(Vector2d acceleration) {
        this.acceleration = acceleration;
    }

    public Vector2d getVelocity() {
        return this.velocity;
    }

    public HudEntity setVelocity(Vector2d velocity) {
        this.velocity = velocity;
        return this;
    }

    public void addVelocity(double x, double y) {
        this.velocity.add(x, y);
    }

    public void addVelocity(Vector2d v) {
        this.velocity.add((Vector2dc)v);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }
}

