/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.options;

import com.google.gson.JsonObject;
import dev.efekos.fancyhealthbar.client.options.HealthBarRenderingOptions;
import dev.efekos.fancyhealthbar.client.options.IntRange;
import dev.efekos.fancyhealthbar.client.options.Range;
import dev.efekos.fancyhealthbar.client.rendering.HealthBarRendering;
import dev.efekos.fancyhealthbar.client.rendering.VanillaHealthBarRendering;
import dev.efekos.fancyhealthbar.client.screen.FhbEnumToggleWidget;
import dev.efekos.fancyhealthbar.client.screen.FhbRangedDoubleSliderWidget;
import dev.efekos.fancyhealthbar.client.screen.FhbRangedSliderWidget;
import dev.efekos.fancyhealthbar.client.screen.FhbSliderWidget;
import dev.efekos.fancyhealthbar.client.screen.FhbToggleWidget;
import dev.efekos.fancyhealthbar.client.screen.RangedSliderWidget;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_7845;
import net.minecraft.class_8021;

public class VanillaRenderingOptions
implements HealthBarRenderingOptions {
    public static final int VERSION = 1;
    private int jiggle;
    private int lowHealthJiggleStart;
    private boolean regenIndexAccount;
    private boolean blinking;
    private HardcoreHearts hardcoreHearts;
    private int lowHealthJiggle;
    private Range<Integer> velocityX;
    private Range<Integer> velocityY;
    private Range<Double> accelerationX;
    private Range<Double> accelerationY;
    private Range<Double> drag;
    private Range<Integer> maxLifetime;

    @Override
    public void fillOptions(class_7845.class_7939 adder) {
        adder.method_47612((class_8021)new FhbSliderWidget(0, 10, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.jiggle"), this.getJiggle(), this::setJiggle));
        adder.method_47612((class_8021)new FhbSliderWidget(0, 10, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.low_health_jiggle"), this.getLowHealthJiggle(), this::setLowHealthJiggle));
        adder.method_47612((class_8021)new FhbToggleWidget((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.blinking"), this.isBlinking(), this::setBlinking));
        adder.method_47612((class_8021)new FhbSliderWidget(1, 100, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.low_health_jiggle_start"), this.getLowHealthJiggleStart(), this::setLowHealthJiggleStart));
        adder.method_47612(new FhbEnumToggleWidget<HardcoreHearts>(HardcoreHearts.class, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.hardcore_hearts"), this.getHardcoreHearts(), this::setHardcoreHearts));
        adder.method_47612((class_8021)new FhbToggleWidget((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.regen"), this.isRegenIndexAccount(), this::setRegenIndexAccount));
        adder.method_47612((class_8021)new FhbRangedSliderWidget(-50, 50, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.velocity_x"), this.getVelocityX().getMin(), this.getVelocityX().getMax(), this.getVelocityX()::setMin, this.getVelocityX()::setMax));
        adder.method_47612((class_8021)new FhbRangedSliderWidget(-50, 50, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.velocity_y"), this.getVelocityY().getMin(), this.getVelocityY().getMax(), this.getVelocityY()::setMin, this.getVelocityY()::setMax));
        adder.method_47612((class_8021)new FhbRangedDoubleSliderWidget(-1, 1, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.acceleration_x"), this.getAccelerationX()));
        adder.method_47612((class_8021)new FhbRangedDoubleSliderWidget(-1, 1, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.acceleration_y"), this.getAccelerationY()));
        adder.method_47612((class_8021)new FhbRangedDoubleSliderWidget(0, 1, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.drag"), this.getDrag()));
        adder.method_47612((class_8021)new FhbRangedSliderWidget(1, 150, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.lifetime"), this.getMaxLifetime()));
    }

    public VanillaRenderingOptions() {
        this.reset();
    }

    @Override
    public HealthBarRendering createRendering() {
        return new VanillaHealthBarRendering(this);
    }

    @Override
    public void read(JsonObject object) {
        this.jiggle = object.get("jiggle").getAsInt();
        this.regenIndexAccount = object.get("regenIndexAccount").getAsBoolean();
        this.blinking = object.get("blinking").getAsBoolean();
        this.lowHealthJiggle = object.get("lowHealthJiggle").getAsInt();
        this.hardcoreHearts = HardcoreHearts.valueOf(object.get("hardcoreHearts").getAsString());
        this.lowHealthJiggleStart = object.has("lowHealthJiggleStart") ? object.get("lowHealthJiggleStart").getAsInt() : 4;
        this.velocityX = this.readIntRange(object, "velocityX");
        this.velocityY = this.readIntRange(object, "velocityY");
        this.accelerationX = this.readDoubleRange(object, "accelerationX");
        this.accelerationY = this.readDoubleRange(object, "accelerationY");
        this.drag = this.readDoubleRange(object, "drag");
        this.maxLifetime = this.readIntRange(object, "maxLifetime");
    }

    private Range<Integer> readIntRange(JsonObject object, String key) {
        return new IntRange(object.get(key + "Min").getAsInt(), object.get(key + "Max").getAsInt());
    }

    private Range<Double> readDoubleRange(JsonObject object, String key) {
        return new RangedSliderWidget.Range(object.get(key + "Min").getAsDouble(), object.get(key + "Max").getAsDouble());
    }

    private void writeRange(JsonObject object, String key, Range<?> range) {
        object.addProperty(key + "Min", range.getMin());
        object.addProperty(key + "Max", range.getMax());
    }

    @Override
    public void write(JsonObject object) {
        object.addProperty("jiggle", (Number)this.jiggle);
        object.addProperty("regenIndexAccount", Boolean.valueOf(this.regenIndexAccount));
        object.addProperty("blinking", Boolean.valueOf(this.blinking));
        object.addProperty("lowHealthJiggle", (Number)this.lowHealthJiggle);
        object.addProperty("lowHealthJiggleStart", (Number)this.lowHealthJiggleStart);
        object.addProperty("hardcoreHearts", this.hardcoreHearts.name());
        this.writeRange(object, "velocityX", this.velocityX);
        this.writeRange(object, "velocityY", this.velocityY);
        this.writeRange(object, "accelerationX", this.accelerationX);
        this.writeRange(object, "accelerationY", this.accelerationY);
        this.writeRange(object, "drag", this.drag);
        this.writeRange(object, "maxLifetime", this.maxLifetime);
        object.addProperty("version", (Number)1);
    }

    @Override
    public void reset() {
        this.jiggle = 0;
        this.blinking = true;
        this.hardcoreHearts = HardcoreHearts.AUTO;
        this.lowHealthJiggle = 2;
        this.lowHealthJiggleStart = 4;
        this.regenIndexAccount = false;
        this.velocityX = new IntRange(-40, 40);
        this.velocityY = new IntRange(-20, 20);
        this.accelerationX = new RangedSliderWidget.Range(0.99, 0.99);
        this.accelerationY = new RangedSliderWidget.Range(-1.0, -1.0);
        this.drag = new RangedSliderWidget.Range(0.0, 0.0);
        this.maxLifetime = new IntRange(100, 100);
    }

    public void setRegenIndexAccount(boolean regenIndexAccount) {
        this.regenIndexAccount = regenIndexAccount;
    }

    public int getLowHealthJiggleStart() {
        return this.lowHealthJiggleStart;
    }

    public void setLowHealthJiggleStart(int lowHealthJiggleStart) {
        this.lowHealthJiggleStart = lowHealthJiggleStart;
    }

    public void setLowHealthJiggle(int lowHealthJiggle) {
        this.lowHealthJiggle = lowHealthJiggle;
    }

    public void setHardcoreHearts(HardcoreHearts hardcoreHearts) {
        this.hardcoreHearts = hardcoreHearts;
    }

    public void setBlinking(boolean blinking) {
        this.blinking = blinking;
    }

    public void setJiggle(int jiggle) {
        this.jiggle = jiggle;
    }

    public boolean isRegenIndexAccount() {
        return this.regenIndexAccount;
    }

    public int getLowHealthJiggle() {
        return this.lowHealthJiggle;
    }

    public HardcoreHearts getHardcoreHearts() {
        return this.hardcoreHearts;
    }

    public boolean isBlinking() {
        return this.blinking;
    }

    public int getJiggle() {
        return this.jiggle;
    }

    public Range<Integer> getVelocityX() {
        return this.velocityX;
    }

    public void setVelocityX(Range<Integer> velocityX) {
        this.velocityX = velocityX;
    }

    public Range<Integer> getVelocityY() {
        return this.velocityY;
    }

    public void setVelocityY(Range<Integer> velocityY) {
        this.velocityY = velocityY;
    }

    public Range<Double> getAccelerationX() {
        return this.accelerationX;
    }

    public void setAccelerationX(Range<Double> accelerationX) {
        this.accelerationX = accelerationX;
    }

    public Range<Double> getAccelerationY() {
        return this.accelerationY;
    }

    public void setAccelerationY(Range<Double> accelerationY) {
        this.accelerationY = accelerationY;
    }

    public Range<Double> getDrag() {
        return this.drag;
    }

    public void setDrag(Range<Double> drag) {
        this.drag = drag;
    }

    public Range<Integer> getMaxLifetime() {
        return this.maxLifetime;
    }

    public void setMaxLifetime(Range<Integer> maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public static enum HardcoreHearts implements Supplier<class_2561>
    {
        OFF(class_5244.field_24333),
        ON(class_5244.field_24332),
        AUTO((class_2561)class_2561.method_43471((String)"options.guiScale.auto"));

        private final class_2561 text;

        private HardcoreHearts(class_2561 text) {
            this.text = text;
        }

        public class_2561 text() {
            return this.text;
        }

        @Override
        public class_2561 get() {
            return this.text;
        }
    }
}

