/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.efekos.fancyhealthbar.client.Try;
import dev.efekos.fancyhealthbar.client.animation.AnimationController;
import dev.efekos.fancyhealthbar.client.animation.AnimationTrack;
import dev.efekos.fancyhealthbar.client.compat.Texture;
import dev.efekos.fancyhealthbar.client.entity.HudEntityManager;
import dev.efekos.fancyhealthbar.client.entity.LineJumpEntity;
import dev.efekos.fancyhealthbar.client.entity.ScissoredLineJumpEntity;
import dev.efekos.fancyhealthbar.client.options.LineRenderingOptions;
import dev.efekos.fancyhealthbar.client.rendering.HealthBarRendering;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class LineHealthBarRendering
implements HealthBarRendering {
    private final LineRenderingOptions options;
    private HudEntityManager manager;
    private AnimationTrack regenTrack;
    private AnimationTrack fulledTrack;
    private int healthDeltaW = -1;
    private float lastHealth = -1.0f;
    private float healthLossTicks = 0.0f;
    private float lastHealthL = -1.0f;

    @Override
    public void react(HudEntityManager manager, AnimationController controller, class_310 client) {
        controller.reset();
        this.initialize(manager, controller, client);
    }

    public LineHealthBarRendering(LineRenderingOptions options) {
        this.options = options;
    }

    @Override
    public LineHealthBarRendering initialize(HudEntityManager manager, AnimationController controller, class_310 client) {
        boolean hardcore = Try.orElse(() -> client.field_1724.method_37908().method_8401().method_152(), false);
        LineRenderingOptions.LineStyle lineStyle = hardcore ? this.options.hardcoreLineStyle() : this.options.normalLineStyle();
        this.regenTrack = controller.createTrack(lineStyle.regenAnim());
        this.regenTrack.setLoop(true);
        this.fulledTrack = controller.createTrack(lineStyle.fulledAnim());
        this.manager = manager;
        controller.addTrack(this.regenTrack);
        controller.addTrack(this.fulledTrack);
        return this;
    }

    @Override
    public void drawPreview(class_5819 random, class_332 context, int x, int y, int lines, int lastHealth, int health, boolean blinking, boolean hardcore) {
        LineRenderingOptions.LineStyle lineStyle = hardcore ? this.options.hardcoreLineStyle() : this.options.normalLineStyle();
        int healthW = (int)Math.floor((double)health / 20.0 * 90.0);
        if (this.healthDeltaW == -1) {
            this.healthDeltaW = healthW;
        }
        lineStyle.empty().draw(context, x, y, 90, 9);
        this.updatePositions(x, y);
        if (this.options.yellowDelta() && health > 0 && (this.options.deltaBehaviour() != LineRenderingOptions.DeltaBehaviour.BLINK || blinking)) {
            this.drawTxtr(context, lineStyle.delta(), x, y, this.healthDeltaW, lineStyle);
        }
        if (lineStyle.scissor()) {
            context.method_44379(x, y, x + healthW, y + 9);
            lineStyle.full().draw(context, x, y, 90, 9);
            context.method_44380();
        } else {
            lineStyle.full().draw(context, x, y, healthW, 9);
        }
        if (this.options.blinking() && blinking) {
            lineStyle.blink().draw(context, x, y, 90, 9);
        }
        if (this.options.notches() > 0) {
            Texture texture = lineStyle.notches(class_3532.method_15340((int)this.options.notches(), (int)1, (int)5));
            RenderSystem.enableBlend();
            texture.draw(context, x, y, 90, 9);
            RenderSystem.disableBlend();
        }
        this.updateAnimationState(health, 20.0f);
        this.updateDeltaWidth(health, 20.0f, healthW);
        this.updateLastHealth(health, 20.0f, lineStyle);
    }

    @Override
    public void draw(class_5819 random, class_332 context, class_1657 player, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int a, int health, int absorption, boolean blinking) {
        boolean hardcore = Try.orElse(() -> player.method_37908().method_8401().method_152(), false);
        LineRenderingOptions.LineStyle lineStyle = hardcore ? this.options.hardcoreLineStyle() : this.options.normalLineStyle();
        int healthW = (int)Math.floor(player.method_6032() / player.method_6063() * 90.0f);
        if (this.lastHealth == -1.0f) {
            this.lastHealth = player.method_6032();
        }
        if (this.healthDeltaW == -1) {
            this.healthDeltaW = healthW;
        }
        lineStyle.empty().draw(context, x, y, 90, 9);
        if (this.regenTrack.getY() != y) {
            this.updatePositions(x, y);
        }
        if (this.options.yellowDelta() && health > 0 && (this.options.deltaBehaviour() != LineRenderingOptions.DeltaBehaviour.BLINK || blinking)) {
            this.drawTxtr(context, lineStyle.delta(), x, y, this.healthDeltaW, lineStyle);
        }
        this.drawTxtr(context, LineHealthBarRendering.determineTexture(player, lineStyle), x, y, healthW, lineStyle);
        if (this.options.blinking() && blinking) {
            lineStyle.blink().draw(context, x, y, 90, 9);
        }
        if (this.options.notches() > 0) {
            Texture notches = lineStyle.notches(class_3532.method_15340((int)this.options.notches(), (int)1, (int)5));
            RenderSystem.enableBlend();
            notches.draw(context, x, y, 90, 9);
            RenderSystem.disableBlend();
        }
        this.updateAnimationState(player.method_6032(), player.method_6063());
        this.updateDeltaWidth(player.method_6032(), player.method_6063(), healthW);
        this.updateLastHealth(player.method_6032(), player.method_6063(), lineStyle);
    }

    private void updatePositions(int x, int y) {
        this.regenTrack.setX(x);
        this.regenTrack.setY(y);
        this.fulledTrack.setX(x);
        this.fulledTrack.setY(y);
    }

    private void updateLastHealth(float health, float maxHealth, LineRenderingOptions.LineStyle lineStyle) {
        if (this.lastHealth > health) {
            this.healthLossTicks = 60.0f;
            if (this.options.deltaBehaviour() == LineRenderingOptions.DeltaBehaviour.JUMP) {
                int oldWidth = (int)(this.lastHealth / maxHealth * 90.0f);
                int newWidth = (int)(health / maxHealth * 90.0f);
                int diff = oldWidth - newWidth;
                if (lineStyle.scissor()) {
                    this.manager.addEntity(new ScissoredLineJumpEntity(this.regenTrack.getX(), this.regenTrack.getY(), this.regenTrack.getX() + newWidth, diff, lineStyle.delta()));
                } else {
                    this.manager.addEntity(new LineJumpEntity(Math.max(this.regenTrack.getX(), this.regenTrack.getX() + newWidth - lineStyle.jumpOffset()), this.regenTrack.getY(), diff + (newWidth == 0 ? 0 : lineStyle.jumpOffset()), lineStyle.delta()));
                }
            }
        }
        if (Objects.requireNonNull(this.options.deltaBehaviour()) == LineRenderingOptions.DeltaBehaviour.LERP) {
            this.lastHealthL = (float)class_3532.method_16436((double)0.1, (double)this.lastHealthL, (double)health);
        }
        this.lastHealth = health;
    }

    private void updateAnimationState(float health, float maxHealth) {
        if (health > this.lastHealth && this.regenTrack.isPaused()) {
            this.regenTrack.play();
        } else if (this.regenTrack.isOver()) {
            this.regenTrack.stop();
        }
        if (health == maxHealth && health != this.lastHealth) {
            if (this.regenTrack.isPlaying()) {
                this.regenTrack.stop();
            }
            this.fulledTrack.play();
        }
    }

    private static Texture determineTexture(class_1657 player, LineRenderingOptions.LineStyle lineStyle) {
        return player.method_32314() ? lineStyle.freeze() : (player.method_5809() || player.method_5771() ? lineStyle.fire() : lineStyle.full());
    }

    private void drawTxtr(class_332 context, Texture texture, int x, int y, int width, LineRenderingOptions.LineStyle lineStyle) {
        if (lineStyle.scissor()) {
            context.method_44379(x, y, x + width, y + 9);
            texture.draw(context, x, y, 90, 9);
            context.method_44380();
        } else {
            texture.draw(context, x, y, width, 9);
        }
    }

    private void updateDeltaWidth(float health, float maxHealth, int healthW) {
        switch (this.options.deltaBehaviour()) {
            case FOLLOW: {
                if (this.healthDeltaW > healthW) {
                    --this.healthDeltaW;
                }
                if (this.healthDeltaW >= healthW) break;
                ++this.healthDeltaW;
                break;
            }
            case LERP: {
                this.healthDeltaW = (int)(this.lastHealthL / maxHealth * 90.0f);
                break;
            }
            case BLINK: {
                if (this.healthLossTicks <= 0.0f && this.lastHealth <= health) {
                    this.healthDeltaW = healthW;
                    break;
                }
                this.healthLossTicks -= 1.0f;
                break;
            }
            case JUMP: {
                this.healthDeltaW = 0;
            }
        }
    }

    @Override
    public boolean shouldTick() {
        return false;
    }

    @Override
    public void onDamage(HudEntityManager manager, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking) {
    }
}

