/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.screen;

import dev.efekos.fancyhealthbar.client.accessor.InGameHudRenderingAccessor;
import dev.efekos.fancyhealthbar.client.animation.AnimationController;
import dev.efekos.fancyhealthbar.client.compat.BlinkingTextures;
import dev.efekos.fancyhealthbar.client.compat.Texture;
import dev.efekos.fancyhealthbar.client.entity.HudEntityManager;
import dev.efekos.fancyhealthbar.client.options.FancyHealthBarOptions;
import dev.efekos.fancyhealthbar.client.options.HealthBarRenderingOptions;
import dev.efekos.fancyhealthbar.client.screen.DirectionalLayoutWidget;
import dev.efekos.fancyhealthbar.client.screen.FhbArrowButton;
import dev.efekos.fancyhealthbar.client.screen.FhbScrollWidget;
import dev.efekos.fancyhealthbar.client.screen.HealthBarWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3829;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8133;

public class FancyHealthBarOptionsScreen
extends class_437 {
    private static final class_2561 TITLE_TEXT = class_2561.method_43471((String)"options.fancyhealthbar.title");
    private final List<String> typeSet = new ArrayList<String>(HealthBarRenderingOptions.TYPES.keySet());
    private class_7845 healthBars;
    private HudEntityManager manager;
    private AnimationController controller;
    private final FancyHealthBarOptions options;
    private final class_8132 layout = new class_8132((class_437)this, 40);
    private final class_437 parent;
    public static final BlinkingTextures LEFT_ARROW_TEXTURES = new BlinkingTextures(Texture.mod("widget/arrow_left", "textures/gui/widgets.png", 0, 0, 16, 15), Texture.mod("widget/arrow_left_selected", "textures/gui/widgets.png", 16, 0, 16, 15));
    public static final BlinkingTextures RIGHT_ARROW_TEXTURES = new BlinkingTextures(Texture.mod("widget/arrow_right", "textures/gui/widgets.png", 32, 0, 16, 15), Texture.mod("widget/arrow_right_selected", "textures/gui/widgets.png", 48, 0, 16, 15));
    private HealthBarWidget damage1;
    private HealthBarWidget damage2;
    private HealthBarWidget damage3;
    private class_7842 healthBarName;
    private FhbScrollWidget scrollWidget;
    private class_7845.class_7939 adder;
    private int ticks;
    private int jumpEnd;

    public FancyHealthBarOptionsScreen(class_437 parent, FancyHealthBarOptions options) {
        super(TITLE_TEXT);
        this.options = options;
        this.parent = parent;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected void method_48640() {
        this.scrollWidget.method_25358(this.field_22789);
        this.scrollWidget.method_53533(this.field_22790 - 80 - 27 - 24 - 16);
        this.scrollWidget.method_46421(0);
        this.layout.method_48222();
        this.healthBars.method_48222();
    }

    protected void refreshWidgetPositions() {
        this.scrollWidget.method_25358(this.field_22789);
        this.scrollWidget.method_53533(this.field_22790 - 80 - 27 - 24 - 16);
        this.scrollWidget.method_46421(0);
        this.layout.method_48222();
        this.healthBars.method_48222();
    }

    protected void method_25426() {
        FhbScrollWidget optionsGrid;
        this.manager = new HudEntityManager();
        this.controller = new AnimationController();
        this.healthBarName = new class_7842((class_2561)class_2561.method_43470((String)"healthBarName"), this.field_22793);
        this.healthBarName.method_25358(100);
        this.layout.method_57726(TITLE_TEXT, this.field_22793);
        DirectionalLayoutWidget bodyLayout = new DirectionalLayoutWidget(0, 0, DirectionalLayoutWidget.DisplayAxis.VERTICAL).spacing(8);
        DirectionalLayoutWidget healthBarsWidget = new DirectionalLayoutWidget(0, 0, DirectionalLayoutWidget.DisplayAxis.HORIZONTAL).spacing(8);
        healthBarsWidget.add(new FhbArrowButton(16, 15, LEFT_ARROW_TEXTURES, this::previousRendering, (class_2561)class_2561.method_43473()), class_7847::method_46474);
        this.healthBars = new class_7845(0, 0);
        this.healthBars.method_48635(8);
        this.healthBars.method_48636(8);
        class_7845.class_7939 adder = this.healthBars.method_47610(3);
        adder.method_47612((class_8021)new HealthBarWidget(this.manager, () -> false).setHealthValue(20));
        adder.method_47612((class_8021)new HealthBarWidget(this.manager, () -> false).setHealthValue(10));
        adder.method_47612((class_8021)new HealthBarWidget(this.manager, () -> false).setHealthValue(0));
        this.damage1 = (HealthBarWidget)adder.method_47612((class_8021)new HealthBarWidget(this.manager, this::shouldBlink).setHealthValue(20));
        this.damage2 = (HealthBarWidget)adder.method_47612((class_8021)new HealthBarWidget(this.manager, this::shouldBlink).setHealthValue(10));
        this.damage3 = (HealthBarWidget)adder.method_47612((class_8021)new HealthBarWidget(this.manager, this::shouldBlink).setHealthValue(5));
        healthBarsWidget.add(this.healthBars);
        healthBarsWidget.add(new FhbArrowButton(16, 15, RIGHT_ARROW_TEXTURES, this::nextRendering, (class_2561)class_2561.method_43473()), class_7847::method_46474);
        bodyLayout.add(healthBarsWidget, class_7847::method_46467);
        bodyLayout.add(this.healthBarName, class_7847::method_46467);
        this.scrollWidget = optionsGrid = this.createRenderingOptionsGrid();
        bodyLayout.add(optionsGrid);
        this.layout.method_49000((class_8021)bodyLayout, class_7847::method_46467);
        this.layout.method_48996((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46431());
        this.healthBars.method_48227(this::add);
        this.layout.method_48206(this::add);
        this.add((class_8021)optionsGrid);
        this.updateRendering();
    }

    private FhbScrollWidget createRenderingOptionsGrid() {
        class_7845.class_7939 adder;
        class_7845 grid = new class_7845();
        grid.method_48635(4);
        grid.method_48636(2);
        this.adder = adder = grid.method_47610(2);
        this.options.getRenderingOptions().fillOptions(adder);
        return new FhbScrollWidget(this.field_22789, 100, (class_8133)grid);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.method_25399() != null && this.method_25397() && (button == 0 || button == 1) && this.method_25399().method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        for (class_364 element : this.method_25396()) {
            if (!element.method_25402(mouseX, mouseY, button)) continue;
            this.method_25395(element);
            if (button == 0 || button == 1) {
                this.method_25398(true);
            }
            return true;
        }
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.manager.render(context);
        this.controller.draw(context);
    }

    private void nextRendering(class_4185 widget) {
        int i = this.typeSet.indexOf(this.options.getSelectedRendering()) + 1;
        if (i >= this.typeSet.size()) {
            i = 0;
        }
        this.options.selectRendering(this.typeSet.get(i));
        this.updateRendering();
    }

    private void previousRendering(class_4185 widget) {
        int i = this.typeSet.indexOf(this.options.getSelectedRendering()) - 1;
        if (i < 0) {
            i = this.typeSet.size() - 1;
        }
        this.options.selectRendering(this.typeSet.get(i));
        this.updateRendering();
    }

    private void add(class_8021 widget) {
        if (widget instanceof class_339) {
            class_339 cl = (class_339)widget;
            this.method_25429((class_364)cl);
        }
        if (widget instanceof class_4068) {
            class_4068 d = (class_4068)widget;
            this.method_37060(d);
        }
    }

    public void method_25432() {
        this.options.write();
    }

    public boolean shouldBlink() {
        return (long)this.jumpEnd > (long)this.ticks && ((long)this.jumpEnd - (long)this.ticks) / 3L % 2L == 1L;
    }

    public void method_25393() {
        this.healthBars.method_48227(widget -> ((HealthBarWidget)widget).tick());
        this.manager.tick();
        this.controller.tick();
        ++this.ticks;
        if (this.ticks % 100 == 0) {
            this.damage1.setHealthValue(20);
            this.damage2.setHealthValue(10);
            this.damage3.setHealthValue(5);
            this.jumpEnd = this.ticks + 10;
        } else if (this.ticks % 50 == 0) {
            this.damage1.setHealthValue(10);
            this.damage2.setHealthValue(5);
            this.damage3.setHealthValue(0);
            this.jumpEnd = this.ticks + 20;
        }
    }

    private void updateRendering() {
        class_7845 gridWidget = this.adder.method_48638();
        FancyHealthBarOptionsScreen fancyHealthBarOptionsScreen = this;
        gridWidget.method_48206(x$0 -> fancyHealthBarOptionsScreen.method_37066((class_364)x$0));
        ((class_3829)this.adder).method_5448();
        this.options.getRenderingOptions().fillOptions(this.adder);
        this.layout.method_48222();
        this.manager.reset();
        this.controller.reset();
        this.healthBars.method_48227(widget -> ((HealthBarWidget)widget).setRendering(this.options.getRenderingOptions().createRendering().initialize(this.manager, this.controller, this.field_22787)));
        ((InGameHudRenderingAccessor)class_310.method_1551().field_1705).fhb$setRendering(this.options.getRenderingOptions().createRendering());
        this.healthBarName.method_25355((class_2561)class_2561.method_43471((String)("options.fancyhealthbar.rendering." + this.options.getSelectedRendering())));
    }
}

