/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.efekos.fancyhealthbar.client.compat.Texture;
import dev.efekos.fancyhealthbar.client.compat.TextureNineSlice;
import java.text.NumberFormat;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_8494;

public abstract class RangedSliderWidget
extends class_339 {
    private static final Texture TEXTURE = Texture.vanilla("widget/slider", "textures/gui/widgets.png", 0, 46, 200, 20, new TextureNineSlice(3, 200, 20));
    private static final Texture HIGHLIGHTED_TEXTURE = Texture.vanilla("widget/slider_highlighted", "textures/gui/widgets.png", 0, 46, 200, 20, new TextureNineSlice(3, 200, 20));
    private static final Texture HANDLE_TEXTURE = Texture.vanilla("widget/slider_handle", "textures/gui/widgets.png", 0, 66, 200, 20, new TextureNineSlice(3, 200, 20));
    private static final Texture HANDLE_HIGHLIGHTED_TEXTURE = Texture.vanilla("widget/slider_handle_highlighted", "textures/gui/widgets.png", 0, 86, 200, 20, new TextureNineSlice(3, 200, 20));
    private static final Texture HANDLE_START_HIGHLIGHTED_TEXTURE = Texture.mod("widget/slider_handle_start_highlighted", "textures/gui/widgets.png", 69, 0, 5, 20);
    private static final Texture HANDLE_START_TEXTURE = Texture.mod("widget/slider_handle_start", "textures/gui/widgets.png", 64, 0, 5, 20);
    private static final Texture HANDLE_END_HIGHLIGHTED_TEXTURE = Texture.mod("widget/slider_handle_end_highlighted", "textures/gui/widgets.png", 79, 0, 5, 20);
    private static final Texture HANDLE_END_TEXTURE = Texture.mod("widget/slider_handle_end", "textures/gui/widgets.png", 74, 0, 5, 20);
    protected Range value;
    private boolean sliderFocused;

    public static class_2561 rangeText(double min, double max) {
        return min == max ? class_2561.method_43470((String)NumberFormat.getInstance().format(min)) : class_2561.method_43469((String)"options.range", (Object[])new Object[]{NumberFormat.getInstance().format(min), NumberFormat.getInstance().format(max)});
    }

    public RangedSliderWidget(int x, int y, int width, int height, class_2561 text, Range value) {
        super(x, y, width, height, text);
        this.value = value;
    }

    private Texture getTexture() {
        return this.method_25370() && !this.sliderFocused ? HIGHLIGHTED_TEXTURE : TEXTURE;
    }

    private Texture getHandleStartTexture() {
        return this.field_22762 || this.sliderFocused ? HANDLE_START_HIGHLIGHTED_TEXTURE : HANDLE_START_TEXTURE;
    }

    private Texture getHandleEndTexture() {
        return this.field_22762 || this.sliderFocused ? HANDLE_END_HIGHLIGHTED_TEXTURE : HANDLE_END_TEXTURE;
    }

    private Texture getHandleTexture() {
        return this.field_22762 || this.sliderFocused ? HANDLE_HIGHLIGHTED_TEXTURE : HANDLE_TEXTURE;
    }

    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            if (this.method_25370()) {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.focused"));
            } else {
                builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)"narration.slider.usage.hovered"));
            }
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_310 minecraftClient = class_310.method_1551();
        context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.getTexture().draw(context, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        if (this.value.min == this.value.max) {
            this.getHandleTexture().draw(context, this.method_46426() + (int)(this.value.min * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364());
        } else {
            this.getHandleStartTexture().draw(context, this.method_46426() + (int)(this.value.min * (double)(this.field_22758 - 5)), this.method_46427(), 5, this.method_25364());
            this.getHandleEndTexture().draw(context, this.method_46426() + (int)(this.value.max * (double)(this.field_22758 - 5)), this.method_46427(), 5, this.method_25364());
        }
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.method_49604(context, minecraftClient.field_1772, 2, i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (!focused) {
            this.sliderFocused = false;
        } else {
            class_8015 guiNavigationType = class_310.method_1551().method_48186();
            if (guiNavigationType == class_8015.field_41778 || guiNavigationType == class_8015.field_41780) {
                this.sliderFocused = true;
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_8494.method_51255((int)keyCode)) {
            this.sliderFocused = !this.sliderFocused;
            return true;
        }
        if (this.sliderFocused) {
            boolean bl;
            boolean bl2 = bl = keyCode == 263;
            if (bl || keyCode == 262) {
                float f = bl ? -1.0f : 1.0f;
                this.setValue(this.value.min + (double)(f / (float)(this.field_22758 - 8)));
                return true;
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setMaxValueFromMouse(double mouseX) {
        this.setMaxValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setMaxValue(double value) {
        double d = this.value.max;
        this.value.setMax(class_3532.method_15350((double)value, (double)this.value.min, (double)1.0));
        if (d != this.value.max) {
            this.applyValue();
        }
        this.updateMessage();
    }

    private void setValue(double value) {
        double d = this.value.min;
        this.value.set(class_3532.method_15350((double)value, (double)0.0, (double)1.0));
        if (d != this.value.min) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public void onRightClick(double mouseX, double mouseY) {
        this.setMaxValueFromMouse(mouseX);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void onRightDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setMaxValueFromMouse(mouseX);
        super.method_25349(mouseX, mouseY, deltaX, deltaY);
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(mouseX);
        super.method_25349(mouseX, mouseY, deltaX, deltaY);
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25354(class_310.method_1551().method_1483());
    }

    public void method_25354(class_1144 soundManager) {
    }

    protected abstract void updateMessage();

    protected abstract void applyValue();

    protected boolean method_25351(int button) {
        return button == 0 || button == 1;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl;
        if (this.field_22763 && this.field_22764 && this.method_25351(button) && (bl = this.method_25361(mouseX, mouseY))) {
            this.method_25354(class_310.method_1551().method_1483());
            if (button == 0) {
                this.method_25348(mouseX, mouseY);
            } else {
                this.onRightClick(mouseX, mouseY);
            }
            return true;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.method_25351(button)) {
            if (button == 0) {
                this.method_25349(mouseX, mouseY, deltaX, deltaY);
            } else {
                this.onRightDrag(mouseX, mouseY, deltaX, deltaY);
            }
            return true;
        }
        return false;
    }

    public static class Range
    implements dev.efekos.fancyhealthbar.client.options.Range<Double> {
        double min;
        double max;

        @Override
        public Double random() {
            return class_3532.method_15390((double)this.min, (double)this.max, (double)Math.random());
        }

        @Override
        public Double getMin() {
            return this.min;
        }

        @Override
        public Double getMax() {
            return this.max;
        }

        @Override
        public void setMin(Double min) {
            this.min = min;
        }

        @Override
        public void setMax(Double max) {
            this.max = max;
        }

        public Range(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public void set(double v) {
            this.min = v;
            this.max = v;
        }
    }
}

