/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.efekos.fancyhealthbar.client.compat.Texture;
import dev.efekos.fancyhealthbar.client.entity.HudEntity;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Vector2i;

public class PixelEntity
extends HudEntity {
    private final Texture texture;
    private final int u;
    private final int v;
    private final boolean guiMode;
    private int size = 1;
    private int maxLifetime;

    public PixelEntity(double x, double y, Texture texture, int u, int v, boolean guiMode) {
        super(x, y);
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.guiMode = guiMode;
    }

    @Override
    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public int getSize() {
        return this.size;
    }

    public PixelEntity setSize(int size) {
        this.size = size;
        return this;
    }

    public void draw(class_332 context) {
        int x1 = (int)this.x - 1;
        int x2 = x1 + this.size;
        int y1 = (int)this.y - 1;
        int y2 = y1 + this.size;
        this.drawTexturedQuad(context, this.texture.atlasId(), x1, x2, y1, y2, 0, this.u, this.u, this.v, this.v);
    }

    void drawTexture(class_332 context, class_2960 texture, int x1, int x2, int y1, int y2, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        this.drawTexturedQuad(context, texture, x1, x2, y1, y2, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
    }

    void drawTexturedQuad(class_332 context, class_2960 texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_22913(u1, v1);
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_22913(u1, v2);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y2, (float)z).method_22913(u2, v2);
        bufferBuilder.method_22918(matrix4f, (float)x2, (float)y1, (float)z).method_22913(u2, v1);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
    }

    @Override
    public void render(class_332 context) {
        if (this.guiMode) {
            context.method_48585(this.texture.atlasId(), (int)this.x, (int)this.y, 1, 1, this.texture.atlasPosition().u1() + this.u, this.texture.atlasPosition().v1() + this.v, 1, 1);
        } else {
            this.draw(context);
        }
    }

    @Override
    public Vector2i getAreaTaken() {
        return new Vector2i(this.size, this.size);
    }

    @Override
    public boolean hasPhysics() {
        return true;
    }
}

