/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.options;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.efekos.fancyhealthbar.client.Try;
import dev.efekos.fancyhealthbar.client.options.HealthBarRenderingOptions;
import dev.efekos.fancyhealthbar.client.options.VanillaRenderingOptions;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FancyHealthBarOptions {
    public static final int VERSION = 1;
    private static final Gson GSON = new GsonBuilder().disableJdkUnsafe().disableHtmlEscaping().setPrettyPrinting().create();
    private static final Logger log = LoggerFactory.getLogger(FancyHealthBarOptions.class);
    private final File optionsDirectory;
    private final File selectedFile;
    private String selectedRendering;
    private HealthBarRenderingOptions renderingOptions;

    public FancyHealthBarOptions(File optionsDirectory) {
        this.optionsDirectory = optionsDirectory;
        this.selectedFile = new File(optionsDirectory, "selected");
        this.defaultConfig();
        this.load();
    }

    public void defaultConfig() {
        this.selectedRendering = "vanilla";
        VanillaRenderingOptions options = (VanillaRenderingOptions)HealthBarRenderingOptions.TYPES.get("vanilla");
        options.reset();
        this.renderingOptions = options;
    }

    public void write() {
        if (!this.optionsDirectory.exists()) {
            this.optionsDirectory.mkdir();
        }
        if (!this.selectedFile.exists()) {
            Try.error(this.selectedFile::createNewFile, log, "Could not create selected file!");
        }
        Try.error(() -> {
            FileWriter writer = new FileWriter(this.selectedFile);
            writer.write(this.selectedRendering);
            writer.flush();
            writer.close();
            return 0;
        }, log, "Could not save selected rendering!");
        File file = this.getRenderingOptionsFile(this.selectedRendering);
        if (!file.exists()) {
            Try.error(file::createNewFile, log, "Could not create rendering options file!");
        }
        try (FileWriter writer = new FileWriter(file);){
            JsonObject object = new JsonObject();
            this.renderingOptions.write(object);
            GSON.toJson((JsonElement)object, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            log.error("Could not save rendering options file!", (Throwable)e);
        }
    }

    public void load() {
        if (!this.optionsDirectory.exists()) {
            return;
        }
        if (!this.selectedFile.exists()) {
            return;
        }
        Try.error(() -> {
            String s = Files.readString(this.selectedFile.toPath());
            HealthBarRenderingOptions options = HealthBarRenderingOptions.TYPES.get(s);
            if (options == null) {
                log.error("Invalid selected rendering!");
                return 0;
            }
            File file = this.getRenderingOptionsFile(s);
            if (!file.exists()) {
                options.reset();
                return 0;
            }
            FileReader reader = new FileReader(file);
            JsonObject object = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            reader.close();
            options.read(object);
            this.renderingOptions = options;
            this.selectedRendering = s;
            return 0;
        }, log, "Couldn't read FHB options.");
    }

    private File getRenderingOptionsFile(String s) {
        return new File(this.optionsDirectory, s + ".json");
    }

    public String getSelectedRendering() {
        return this.selectedRendering;
    }

    public HealthBarRenderingOptions getRenderingOptions() {
        return this.renderingOptions;
    }

    public void selectRendering(String rendering) {
        Try.error(() -> {
            HealthBarRenderingOptions options = HealthBarRenderingOptions.TYPES.get(rendering);
            if (options == null) {
                log.error("Invalid selected rendering!");
                return 0;
            }
            File file = this.getRenderingOptionsFile(rendering);
            if (!file.exists()) {
                options.reset();
            } else {
                FileReader reader = new FileReader(file);
                JsonObject object = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                reader.close();
                options.read(object);
            }
            this.renderingOptions = options;
            this.selectedRendering = rendering;
            return 0;
        }, log, "Couldn't change FHB rendering.");
    }
}

