/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.options;

import com.google.gson.JsonObject;
import dev.efekos.fancyhealthbar.client.Try;
import dev.efekos.fancyhealthbar.client.accessor.InGameHudRenderingAccessor;
import dev.efekos.fancyhealthbar.client.animation.Animation;
import dev.efekos.fancyhealthbar.client.compat.Texture;
import dev.efekos.fancyhealthbar.client.compat.TextureList;
import dev.efekos.fancyhealthbar.client.compat.TextureNineSlice;
import dev.efekos.fancyhealthbar.client.options.HealthBarRenderingOptions;
import dev.efekos.fancyhealthbar.client.rendering.HealthBarRendering;
import dev.efekos.fancyhealthbar.client.rendering.LineHealthBarRendering;
import dev.efekos.fancyhealthbar.client.screen.FhbEnumToggleWidget;
import dev.efekos.fancyhealthbar.client.screen.FhbSliderWidget;
import dev.efekos.fancyhealthbar.client.screen.FhbToggleWidget;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7845;
import net.minecraft.class_8021;

public class LineRenderingOptions
implements HealthBarRenderingOptions {
    private boolean blinking;
    private boolean yellowDelta;
    private int notches = 0;
    private LineStyle normalLineStyle;
    private LineStyle hardcoreLineStyle;
    private DeltaBehaviour deltaBehaviour;

    public LineRenderingOptions() {
        this.reset();
    }

    @Override
    public void fillOptions(class_7845.class_7939 adder) {
        adder.method_47612((class_8021)new FhbToggleWidget((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.vanilla.blinking"), this.blinking(), this::setBlinking));
        adder.method_47612((class_8021)new FhbToggleWidget((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.delta"), this.yellowDelta, this::setYellowDelta));
        adder.method_47612((class_8021)new FhbSliderWidget(0, 5, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.notches"), this.notches, this::setNotches));
        adder.method_47612(new FhbEnumToggleWidget<DeltaBehaviour>(DeltaBehaviour.class, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.delta_behaviour"), this.deltaBehaviour, this::setDeltaBehaviour));
        adder.method_47612(new FhbEnumToggleWidget<LineStyle>(LineStyle.class, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.normal_style"), this.normalLineStyle, this::setNormalLineStyle));
        adder.method_47612(new FhbEnumToggleWidget<LineStyle>(LineStyle.class, (class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.hardcore_style"), this.hardcoreLineStyle, this::setHardcoreLineStyle));
    }

    public DeltaBehaviour deltaBehaviour() {
        return this.deltaBehaviour;
    }

    public void setDeltaBehaviour(DeltaBehaviour deltaBehaviour) {
        this.deltaBehaviour = deltaBehaviour;
    }

    public void setNormalLineStyle(LineStyle normalLineStyle) {
        this.normalLineStyle = normalLineStyle;
        Try.ignore(() -> {
            ((InGameHudRenderingAccessor)class_310.method_1551().field_1705).fhb$react();
            return null;
        });
    }

    public void setHardcoreLineStyle(LineStyle hardcoreLineStyle) {
        this.hardcoreLineStyle = hardcoreLineStyle;
        Try.ignore(() -> {
            ((InGameHudRenderingAccessor)class_310.method_1551().field_1705).fhb$react();
            return null;
        });
    }

    public LineStyle normalLineStyle() {
        return this.normalLineStyle;
    }

    public LineStyle hardcoreLineStyle() {
        return this.hardcoreLineStyle;
    }

    public int notches() {
        return this.notches;
    }

    public void setNotches(int notches) {
        this.notches = notches;
    }

    public boolean yellowDelta() {
        return this.yellowDelta;
    }

    public void setYellowDelta(boolean yellowDelta) {
        this.yellowDelta = yellowDelta;
    }

    public boolean blinking() {
        return this.blinking;
    }

    public void setBlinking(boolean blinking) {
        this.blinking = blinking;
    }

    @Override
    public HealthBarRendering createRendering() {
        return new LineHealthBarRendering(this);
    }

    @Override
    public void read(JsonObject object) {
        if (object.has("blinking")) {
            this.blinking = object.get("blinking").getAsBoolean();
        }
        if (object.has("delta")) {
            this.yellowDelta = object.get("delta").getAsBoolean();
        }
        if (object.has("notches")) {
            this.notches = object.get("notches").getAsInt();
        }
        if (object.has("normal_style")) {
            this.normalLineStyle = Try.orElse(() -> LineStyle.valueOf(object.get("normal_style").getAsString()), LineStyle.DEFAULT);
        }
        if (object.has("hardcore_style")) {
            this.hardcoreLineStyle = Try.orElse(() -> LineStyle.valueOf(object.get("hardcore_style").getAsString()), LineStyle.HARDCORE);
        }
        if (object.has("delta_behaviour")) {
            this.deltaBehaviour = Try.orElse(() -> DeltaBehaviour.valueOf(object.get("delta_behaviour").getAsString()), DeltaBehaviour.FOLLOW);
        }
    }

    @Override
    public void write(JsonObject object) {
        object.addProperty("blinking", Boolean.valueOf(this.blinking));
        object.addProperty("delta", Boolean.valueOf(this.yellowDelta));
        object.addProperty("notches", (Number)this.notches);
        object.addProperty("normal_style", this.normalLineStyle.name());
        object.addProperty("hardcore_style", this.hardcoreLineStyle.name());
        object.addProperty("delta_behaviour", this.deltaBehaviour.name());
    }

    @Override
    public void reset() {
        this.notches = 0;
        this.blinking = true;
        this.yellowDelta = true;
        this.normalLineStyle = LineStyle.DEFAULT;
        this.hardcoreLineStyle = LineStyle.HARDCORE;
        this.deltaBehaviour = DeltaBehaviour.FOLLOW;
    }

    public static enum DeltaBehaviour implements Supplier<class_2561>
    {
        FOLLOW((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.delta_behaviour.follow"), true),
        LERP((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.delta_behaviour.lerp"), true),
        BLINK((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.delta_behaviour.blink"), false),
        JUMP((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.delta_behaviour.jump"), false);

        private final boolean liveUpdates;
        private final class_2561 name;

        public boolean liveUpdates() {
            return this.liveUpdates;
        }

        private DeltaBehaviour(class_2561 name, boolean liveUpdates) {
            this.name = name;
            this.liveUpdates = liveUpdates;
        }

        @Override
        public class_2561 get() {
            return this.name;
        }
    }

    public static enum LineStyle implements Supplier<class_2561>
    {
        DEFAULT((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.style.default"), false, "default", Texture.mod("hud/health_bar/line/default/full", "textures/gui/line_bar_default.png", 60, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/default/freeze", "textures/gui/line_bar_default.png", 45, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/default/fire", "textures/gui/line_bar_default.png", 30, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/default/empty", "textures/gui/line_bar_default.png", 15, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/default/delta", "textures/gui/line_bar_default.png", 0, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/default/blink", "textures/gui/line_bar_default.png", 0, 0, 90, 9), TextureList.verticalStrip(Texture.mod("hud/health_bar/line/default/notches", "textures/gui/line_bar_default.png", 0, 52, 90, 9), 5), Animation.verticalStrip(Texture.mod("hud/health_bar/line/default/regenerating", "textures/gui/line_bar_default.png", 0, 97, 90, 9), 11), Animation.verticalStrip(Texture.mod("hud/health_bar/line/default/fulled", "textures/gui/line_bar_default.png", 90, 0, 90, 9), 14)),
        HARDCORE((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.style.hardcore"), false, "hardcore", Texture.mod("hud/health_bar/line/hardcore/full", "textures/gui/line_bar_default.png", 54, 33, 18, new TextureNineSlice(6, 18, 18)), Texture.mod("hud/health_bar/line/hardcore/freeze", "textures/gui/line_bar_default.png", 36, 33, 18, new TextureNineSlice(6, 18, 18)), Texture.mod("hud/health_bar/line/hardcore/fire", "textures/gui/line_bar_default.png", 18, 33, 18, new TextureNineSlice(6, 18, 18)), Texture.mod("hud/health_bar/line/hardcore/empty", "textures/gui/line_bar_default.png", 15, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/hardcore/delta", "textures/gui/line_bar_default.png", 0, 33, 18, new TextureNineSlice(6, 18, 18)), Texture.mod("hud/health_bar/line/hardcore/blink", "textures/gui/line_bar_default.png", 0, 24, 90, 9), TextureList.verticalStrip(Texture.mod("hud/health_bar/line/hardcore/notches", "textures/gui/line_bar_default.png", 0, 52, 90, 9), 5), Animation.verticalStrip(Texture.mod("hud/health_bar/line/hardcore/regenerating", "textures/gui/line_bar_default.png", 0, 97, 90, 9), 11), Animation.verticalStrip(Texture.mod("hud/health_bar/line/hardcore/fulled", "textures/gui/line_bar_default.png", 90, 0, 90, 9), 14)),
        FLAT((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.style.flat"), false, "flat", 0, Texture.mod("hud/health_bar/line/flat/full", "textures/gui/line_bar_flat.png", 60, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat/freeze", "textures/gui/line_bar_flat.png", 45, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat/fire", "textures/gui/line_bar_flat.png", 30, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat/empty", "textures/gui/line_bar_flat.png", 15, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat/delta", "textures/gui/line_bar_flat.png", 0, 9, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat/blink", "textures/gui/line_bar_flat.png", 0, 0, 90, 9), TextureList.verticalStrip(Texture.mod("hud/health_bar/line/flat/notches", "textures/gui/line_bar_flat.png", 0, 147, 90, 9), 5), Animation.verticalStrip(Texture.mod("hud/health_bar/line/flat/regenerating", "textures/gui/line_bar_flat.png", 0, 48, 90, 9), 10), Animation.verticalStrip(Texture.mod("hud/health_bar/line/flat/fulled", "textures/gui/line_bar_flat.png", 90, 0, 90, 9), 14)),
        FLAT_HARDCORE((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.style.flat_hardcore"), false, "flat_hardcore", 0, Texture.mod("hud/health_bar/line/flat_hardcore/full", "textures/gui/line_bar_flat.png", 60, 33, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat_hardcore/freeze", "textures/gui/line_bar_flat.png", 45, 33, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat_hardcore/fire", "textures/gui/line_bar_flat.png", 30, 33, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat_hardcore/empty", "textures/gui/line_bar_flat.png", 15, 33, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat_hardcore/delta", "textures/gui/line_bar_flat.png", 0, 33, 15, new TextureNineSlice(5, 15, 15)), Texture.mod("hud/health_bar/line/flat_hardcore/blink", "textures/gui/line_bar_flat.png", 0, 0, 90, 9), TextureList.verticalStrip(Texture.mod("hud/health_bar/line/flat_hardcore/notches", "textures/gui/line_bar_flat.png", 0, 147, 90, 9), 5), Animation.verticalStrip(Texture.mod("hud/health_bar/line/flat_hardcore/regenerating", "textures/gui/line_bar_flat.png", 0, 48, 90, 9), 11), Animation.verticalStrip(Texture.mod("hud/health_bar/line/flat_hardcore/fulled", "textures/gui/line_bar_flat.png", 90, 0, 90, 9), 14)),
        PIXELATED((class_2561)class_2561.method_43471((String)"options.fancyhealthbar.line.style.pixelated"), true, "pixelated", 0, Texture.mod("hud/health_bar/line/pixelated/full", "textures/gui/line_bar_pixelated.png", 0, 45, 90, 9), Texture.mod("hud/health_bar/line/pixelated/freeze", "textures/gui/line_bar_pixelated.png", 0, 36, 90, 9), Texture.mod("hud/health_bar/line/pixelated/fire", "textures/gui/line_bar_pixelated.png", 0, 27, 90, 9), Texture.mod("hud/health_bar/line/pixelated/empty", "textures/gui/line_bar_pixelated.png", 0, 18, 90, 9), Texture.mod("hud/health_bar/line/pixelated/delta", "textures/gui/line_bar_pixelated.png", 0, 9, 90, 9), Texture.mod("hud/health_bar/line/pixelated/blink", "textures/gui/line_bar_pixelated.png", 0, 0, 90, 9), TextureList.verticalStrip(Texture.mod("hud/health_bar/line/pixelated/notches", "textures/gui/line_bar_pixelated.png", 0, 153, 90, 9), 5), Animation.verticalStrip(Texture.mod("hud/health_bar/line/pixelated/regenerating", "textures/gui/line_bar_pixelated.png", 0, 54, 90, 9), 11), Animation.verticalStrip(Texture.mod("hud/health_bar/line/pixelated/fulled", "textures/gui/line_bar_pixelated.png", 90, 0, 90, 9), 9));

        private final class_2561 text;
        private final String id;
        private final int jumpOffset;
        private final Animation regenAnim;
        private final Animation fulledAnim;
        private final boolean scissor;
        private final Texture full;
        private final Texture freeze;
        private final Texture fire;
        private final Texture empty;
        private final Texture delta;
        private final Texture blink;
        private final List<Texture> notches;

        private LineStyle(class_2561 text, boolean scissor, String id, int offset, Texture full, Texture freeze, Texture fire, Texture empty, Texture delta, Texture blink, List<Texture> notches, Animation regenAnim, Animation fulledAnim) {
            this.text = text;
            this.id = id;
            this.scissor = scissor;
            this.regenAnim = regenAnim;
            this.fulledAnim = fulledAnim;
            this.jumpOffset = offset;
            this.full = full;
            this.fire = fire;
            this.empty = empty;
            this.delta = delta;
            this.blink = blink;
            this.notches = notches;
            this.freeze = freeze;
        }

        private LineStyle(class_2561 text, boolean scissor, String id, Texture full, Texture freeze, Texture fire, Texture empty, Texture delta, Texture blink, List<Texture> notches, Animation regenAnim, Animation fulledAnim) {
            this.text = text;
            this.id = id;
            this.scissor = scissor;
            this.regenAnim = regenAnim;
            this.fulledAnim = fulledAnim;
            this.jumpOffset = 5;
            this.full = full;
            this.fire = fire;
            this.empty = empty;
            this.delta = delta;
            this.blink = blink;
            this.notches = notches;
            this.freeze = freeze;
        }

        public int jumpOffset() {
            return this.jumpOffset;
        }

        public Texture full() {
            return this.full;
        }

        public Texture freeze() {
            return this.freeze;
        }

        public Texture fire() {
            return this.fire;
        }

        public Texture empty() {
            return this.empty;
        }

        public Texture delta() {
            return this.delta;
        }

        public Texture blink() {
            return this.blink;
        }

        public Texture notches(int notches) {
            return this.notches.get(notches - 1);
        }

        public Animation fulledAnim() {
            return this.fulledAnim;
        }

        public Animation regenAnim() {
            return this.regenAnim;
        }

        public boolean scissor() {
            return this.scissor;
        }

        public class_2561 text() {
            return this.text;
        }

        @Override
        public class_2561 get() {
            return this.text;
        }
    }
}

