/*
 * Decompiled with CFR 0.152.
 */
package dev.efekos.fancyhealthbar.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.efekos.fancyhealthbar.client.HeartTextureSet;
import dev.efekos.fancyhealthbar.client.animation.AnimationController;
import dev.efekos.fancyhealthbar.client.compat.Texture;
import dev.efekos.fancyhealthbar.client.entity.HudEntityManager;
import dev.efekos.fancyhealthbar.client.entity.PixelEntity;
import dev.efekos.fancyhealthbar.client.options.VanillaRenderingOptions;
import dev.efekos.fancyhealthbar.client.rendering.HealthBarRendering;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Unique;

public class VanillaHealthBarRendering
implements HealthBarRendering {
    private final VanillaRenderingOptions options;

    @Override
    public VanillaHealthBarRendering initialize(HudEntityManager manager, AnimationController controller, class_310 client) {
        return this;
    }

    @Override
    public void react(HudEntityManager manager, AnimationController controller, class_310 client) {
    }

    public VanillaHealthBarRendering(VanillaRenderingOptions options) {
        this.options = options;
    }

    @Override
    public void drawPreview(class_5819 random, class_332 context, int x, int y, int lines, int lastHealth, int health, boolean blinking, boolean hardcore) {
        HeartTextureSet heartType = HeartTextureSet.NORMAL;
        int maxHearts = 10;
        int absorptionHearts = 0;
        if (this.options.getHardcoreHearts() == VanillaRenderingOptions.HardcoreHearts.ON) {
            hardcore = true;
        }
        if (this.options.getHardcoreHearts() == VanillaRenderingOptions.HardcoreHearts.OFF) {
            hardcore = false;
        }
        blinking = blinking && this.options.isBlinking();
        for (int i = maxHearts + absorptionHearts - 1; i >= 0; --i) {
            boolean bl4;
            Vector2i heartLoc = this.getHeartLocation(random, x, y, lines, -1, lastHealth, 0, i, maxHearts);
            this.legacyHeart(context, HeartTextureSet.CONTAINER, heartLoc.x, heartLoc.y, hardcore, blinking, false);
            int q = i * 2;
            if (blinking && q < health) {
                bl4 = q + 1 == health;
                this.legacyHeart(context, heartType, heartLoc.x, heartLoc.y, hardcore, true, bl4);
            }
            if (q >= lastHealth) continue;
            bl4 = q + 1 == lastHealth;
            this.legacyHeart(context, heartType, heartLoc.x, heartLoc.y, hardcore, false, bl4);
        }
    }

    @Override
    public void draw(class_5819 random, class_332 context, class_1657 player, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking) {
        HeartTextureSet heartType = HeartTextureSet.tryGetFromPlayer(player);
        boolean hardcore = player.method_37908().method_8401().method_152();
        int maxHearts = class_3532.method_15384((double)((double)maxHealth / 2.0));
        int absorptionHearts = class_3532.method_15384((double)((double)absorption / 2.0));
        int maxHealthI = maxHearts * 2;
        boolean bl = blinking = blinking && this.options.isBlinking();
        if (this.options.getHardcoreHearts() == VanillaRenderingOptions.HardcoreHearts.ON) {
            hardcore = true;
        }
        if (this.options.getHardcoreHearts() == VanillaRenderingOptions.HardcoreHearts.OFF) {
            hardcore = false;
        }
        for (int i = maxHearts + absorptionHearts - 1; i >= 0; --i) {
            boolean bl4;
            int r;
            Vector2i heartLoc = this.getHeartLocation(random, x, y, lines, regeneratingHeartIndex, lastHealth, absorption, i, maxHearts);
            this.legacyHeart(context, HeartTextureSet.CONTAINER, heartLoc.x, heartLoc.y, hardcore, blinking, false);
            int q = i * 2;
            if (i >= maxHearts && (r = q - maxHealthI) < absorption) {
                boolean bl3 = r + 1 == absorption;
                this.legacyHeart(context, heartType == HeartTextureSet.WITHERED ? heartType : HeartTextureSet.ABSORBING, heartLoc.x, heartLoc.y(), hardcore, false, bl3);
            }
            if (blinking && q < health) {
                bl4 = q + 1 == health;
                this.legacyHeart(context, heartType, heartLoc.x, heartLoc.y, hardcore, true, bl4);
            }
            if (q >= lastHealth) continue;
            bl4 = q + 1 == lastHealth;
            this.legacyHeart(context, heartType, heartLoc.x, heartLoc.y, hardcore, false, bl4);
        }
    }

    @NotNull
    private Vector2i getHeartLocation(class_5819 random, int x, int y, int lines, int regeneratingHeartIndex, int lastHealth, int absorption, int i, int maxHearts) {
        int m = i / 10;
        int n = i % 10;
        int heartX = x + n * 8;
        int heartY = y - m * lines;
        if (this.options.getJiggle() > 0) {
            heartY += random.method_43048(this.options.getJiggle());
        }
        if (this.options.getLowHealthJiggle() > 0 && lastHealth + absorption <= this.options.getLowHealthJiggleStart()) {
            heartY += random.method_43048(this.options.getLowHealthJiggle());
        }
        if (i < maxHearts && i == regeneratingHeartIndex && this.options.isRegenIndexAccount()) {
            heartY -= 2;
        }
        return new Vector2i(heartX, heartY);
    }

    @Override
    public boolean shouldTick() {
        return false;
    }

    @Override
    public void onDamage(HudEntityManager manager, int x, int y, int lines, int regenHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking) {
        Vector2i location;
        boolean startHalfLost;
        class_746 player = class_310.method_1551().field_1724;
        HeartTextureSet heartType = player == null ? HeartTextureSet.NORMAL : HeartTextureSet.tryGetFromPlayer((class_1657)player);
        boolean hardcore = player != null && this.options.getHardcoreHearts() != VanillaRenderingOptions.HardcoreHearts.AUTO && player.method_37908().method_8401().method_152() || this.options.getHardcoreHearts() == VanillaRenderingOptions.HardcoreHearts.ON;
        int maxHearts = class_3532.method_15384((double)((double)maxHealth / 2.0));
        int hearts = class_3532.method_15384((double)((double)health / 2.0));
        int lastHearts = class_3532.method_15384((double)((double)lastHealth / 2.0));
        int heartDif = lastHealth - health == 1 ? 1 : lastHearts - hearts;
        int healthDif = lastHealth - health;
        Texture texture = heartType.getTexture(hardcore, false, blinking);
        boolean bothLost = lastHealth % 2 != 0 && health % 2 != 0;
        boolean endHalfLost = lastHealth % 2 == 0 && health % 2 != 0;
        boolean bl = startHalfLost = lastHealth % 2 != 0 && health % 2 == 0;
        if (bothLost) {
            location = this.getHeartLocation(class_5819.method_43047(), x, y, lines, regenHeartIndex, lastHealth, absorption, hearts - 1, maxHearts);
            this.spawnHeart(4, 9, manager, location, texture);
            Vector2i location2 = this.getHeartLocation(class_5819.method_43047(), x, y, lines, regenHeartIndex, lastHealth, absorption, hearts + heartDif - 1, maxHearts);
            this.spawnHeart(0, 5, manager, location2, texture);
        }
        if (endHalfLost) {
            location = this.getHeartLocation(class_5819.method_43047(), x, y, lines, regenHeartIndex, lastHealth, absorption, hearts - 1, maxHearts);
            this.spawnHeart(4, 9, manager, location, texture);
        }
        if (startHalfLost) {
            location = this.getHeartLocation(class_5819.method_43047(), x, y, lines, regenHeartIndex, lastHealth, absorption, hearts + heartDif - 1, maxHearts);
            this.spawnHeart(0, 5, manager, location, texture);
        }
        if (healthDif > 1) {
            for (int i = 0; i < heartDif; ++i) {
                if ((startHalfLost || bothLost) && i + 1 == heartDif) continue;
                Vector2i location2 = this.getHeartLocation(class_5819.method_43047(), x, y, lines, regenHeartIndex, lastHealth, absorption, hearts + i, maxHearts);
                this.spawnHeart(0, 9, manager, location2, texture);
            }
        }
    }

    private void spawnHeart(int us, int ul, HudEntityManager manager, Vector2i location, Texture texture) {
        for (int u = us; u < ul; ++u) {
            for (int v = 0; v < 9; ++v) {
                this.a(manager, location, texture, u, v);
            }
        }
    }

    private void a(HudEntityManager manager, Vector2i location, Texture texture, int a, int b) {
        PixelEntity entity = new PixelEntity(location.x + a, location.y + b, texture, a, b, true);
        entity.setVelocity(new Vector2d((double)this.options.getVelocityX().random().intValue(), (double)this.options.getVelocityY().random().intValue()));
        entity.setAcceleration(new Vector2d(this.options.getAccelerationX().random().doubleValue(), this.options.getAccelerationY().random().doubleValue()));
        entity.setDrag(this.options.getDrag().random());
        entity.setMaxLifetime(this.options.getMaxLifetime().random());
        manager.addEntity(entity);
    }

    @Unique
    private void legacyHeart(class_332 context, HeartTextureSet set, int x, int y, boolean hardcore, boolean blinking, boolean half) {
        RenderSystem.enableBlend();
        Texture setTexture = set.getTexture(hardcore, half, blinking);
        setTexture.draw(context, x, y, 9, 9);
        RenderSystem.disableBlend();
    }
}

