/*
 * Decompiled with CFR 0.152.
 */
package org.scubakay.dynamic_resource_pack.util;

import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2720;
import net.minecraft.class_3806;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.scubakay.dynamic_resource_pack.DynamicResourcePack;
import org.scubakay.dynamic_resource_pack.config.Config;
import org.scubakay.dynamic_resource_pack.util.ConfigFileWatcher;

public class ConfigFileHandler {
    private static ConfigFileHandler instance;
    private final MinecraftServer server;
    private ConfigFileWatcher watcher;
    private final Path file;
    private MinecraftServer.class_7460 packProperties;
    private boolean started;

    private ConfigFileHandler(MinecraftServer server) {
        this.server = server;
        this.file = ConfigFileHandler.getConfigFile(server);
    }

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ConfigFileHandler.getInstance(server).startConfigFileWatcher());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ConfigFileHandler.getInstance(server).stopConfigFileWatcher());
    }

    public class_2720 getResourcePackSendS2CPacket() {
        return new class_2720(this.packProperties.comp_2156(), this.packProperties.comp_784(), this.packProperties.comp_785(), this.packProperties.comp_786(), Optional.ofNullable(this.packProperties.comp_787()));
    }

    public static ConfigFileHandler getInstance(MinecraftServer server) {
        if (instance == null) {
            instance = new ConfigFileHandler(server);
        }
        return instance;
    }

    private void startConfigFileWatcher() {
        this.onConfigFileChange();
        if (this.watcher == null) {
            this.watcher = new ConfigFileWatcher(ConfigFileHandler.getConfigDirectory(this.server), ConfigFileHandler.getConfigFile(this.server), this::onConfigFileChange);
            this.watcher.setDaemon(true);
            this.watcher.start();
        }
    }

    private void onConfigFileChange() {
        class_3806.method_16714((Path)this.file).field_39093.ifPresentOrElse(prop -> {
            this.packProperties = prop;
            if (!this.started) {
                this.started = true;
            } else {
                if (Config.runReloadOnResourcePackUpdate.booleanValue()) {
                    this.reloadDatapacks();
                }
                this.notifyPlayers();
            }
        }, () -> DynamicResourcePack.LOGGER.error("Something went wrong trying to load the new server pack properties"));
    }

    private void stopConfigFileWatcher() {
        if (this.watcher != null) {
            this.watcher.stopThread();
        }
    }

    private void reloadDatapacks() {
        class_2170 manager = this.server.method_3734();
        class_2168 source = this.server.method_3739();
        manager.method_44252(source, "reload");
    }

    private void notifyPlayers() {
        class_5250 message = class_2561.method_43470((String)Config.reloadResourcePackMessage).method_10852((class_2561)class_2561.method_43470((String)Config.reloadResourcePackAction).method_27694(style -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11750, "/resourcepack")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)Config.reloadResourcePackTooltip)))));
        this.server.method_3760().method_43514((class_2561)message, false);
    }

    public static Path getConfigDirectory(MinecraftServer server) {
        return server.method_3831();
    }

    public static Path getConfigFile(MinecraftServer server) {
        return ConfigFileHandler.getConfigDirectory(server).resolve("server.properties");
    }

    public static MinecraftServer.class_7460 getResourcePackProperties(MinecraftServer server) {
        ConfigFileHandler handler = ConfigFileHandler.getInstance(server);
        return handler.packProperties;
    }
}

