package org.scubakay.dynamic_resource_pack.util;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2720;
import net.minecraft.class_3806;
import net.minecraft.server.MinecraftServer;
import org.scubakay.dynamic_resource_pack.DynamicResourcePack;

import java.nio.file.Path;
import java.util.Optional;

/**
 * Responsible for keeping track of the ServerProperties file
 */
public class ConfigFileHandler {
    private static ConfigFileHandler instance;

    private final MinecraftServer server;
    private ConfigFileWatcher watcher;
    private final Path file;
    private MinecraftServer.class_7460 packProperties;
    private boolean started;

    private ConfigFileHandler(MinecraftServer server) {
        this.server = server;
        this.file = getConfigFile(server);
    }

    public static void registerEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register((MinecraftServer server) ->
                getInstance(server).startConfigFileWatcher());
        ServerLifecycleEvents.SERVER_STOPPING.register((MinecraftServer server) ->
                getInstance(server).stopConfigFileWatcher());
    }

    public class_2720 getResourcePackSendS2CPacket() {
        return new class_2720(
                this.packProperties.comp_2156(),
                this.packProperties.comp_784(),
                this.packProperties.comp_785(),
                this.packProperties.comp_786(),
                Optional.ofNullable(this.packProperties.comp_787())
        );
    }

    public static ConfigFileHandler getInstance(MinecraftServer server) {
        if (instance == null) {
            instance = new ConfigFileHandler(server);
        }
        return instance;
    }

    private void startConfigFileWatcher() {
        onConfigFileChange();
        if (watcher == null) {
            watcher = new ConfigFileWatcher(
                    getConfigDirectory(server),
                    getConfigFile(server),
                    this::onConfigFileChange
            );
            watcher.setDaemon(true);
            watcher.start();
        }
    }

    private void onConfigFileChange() {
        class_3806.method_16714(file).field_39093.ifPresentOrElse(prop -> {
            this.packProperties = prop;
            if (!started) {
                started = true;
            } else {
                if (DynamicResourcePack.modConfig.runReloadOnResourcePackUpdate.get()) {
                    reloadDatapacks();
                }
                notifyPlayers();
            }
        }, () -> DynamicResourcePack.LOGGER.error("Something went wrong trying to load the new server pack properties"));
    }

    private void stopConfigFileWatcher() {
        if (watcher != null) {
            watcher.stopThread();
        }
    }

    /**
     * Just executes the /reload command
     */
    private void reloadDatapacks() {
        class_2170 manager = server.method_3734();
        class_2168 source = server.method_3739();
        //? if >= 1.21.10 {
        /*manager.parseAndExecute(source, "reload");
        *///?} else {
        manager.method_44252(source, "reload");
        //?}
    }

    private void notifyPlayers() {
        class_2561 message = class_2561.method_43470(DynamicResourcePack.modConfig.reloadResourcePackMessage.get()).method_10852(
                class_2561.method_43470(DynamicResourcePack.modConfig.reloadResourcePackAction.get()).method_27694(style -> style.method_10977(class_124.field_1060)
                                //? if >= 1.21.5 {
                                .method_10958(new class_2558.class_10609("/resourcepack"))
                                .method_10949(new class_2568.class_10613(class_2561.method_43470(DynamicResourcePack.modConfig.reloadResourcePackTooltip.get())))
                        //?} else {
                /*.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/resourcepack"))
                .withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Text.literal(DynamicResourcePack.modConfig.reloadResourcePackTooltip.get())))
                *///?}
                ));
        server.method_3760().method_43514(message, false);
    }

    public static Path getConfigDirectory(MinecraftServer server) {
        return server.method_3831();
    }

    public static Path getConfigFile(MinecraftServer server) {
        return getConfigDirectory(server).resolve("server.properties");
    }

    /**
     * Returns the current ServerResourcePackProperties, or null if not loaded yet.
     */
    public static MinecraftServer.class_7460 getResourcePackProperties(MinecraftServer server) {
        ConfigFileHandler handler = getInstance(server);
        return handler.packProperties;
    }
}
