/*
 * Decompiled with CFR 0.152.
 */
package org.scubakay.dynamic_resource_pack.util;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.scubakay.dynamic_resource_pack.DynamicResourcePack;

public class ConfigFileWatcher
extends Thread {
    private final AtomicBoolean stop = new AtomicBoolean(false);
    private final Runnable runnable;
    private final Path directory;
    private final Path file;
    private static final int DEBOUNCE_MILLIS = 5000;
    private volatile long lastTriggerTime = 0L;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private volatile ScheduledFuture<?> scheduledTask = null;

    public ConfigFileWatcher(Path directory, Path file, Runnable runnable) {
        this.runnable = runnable;
        this.file = file;
        this.directory = directory;
    }

    public void stopThread() {
        this.stop.set(true);
        this.executor.shutdownNow();
    }

    @Override
    public void run() {
        DynamicResourcePack.LOGGER.info("Watching " + String.valueOf(this.file.getFileName()) + " for changes");
        try (WatchService watchService = FileSystems.getDefault().newWatchService();){
            this.directory.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            while (!this.stop.get()) {
                Thread.sleep(50L);
                WatchKey wk = watchService.take();
                for (WatchEvent<?> event : wk.pollEvents()) {
                    Path changed = (Path)event.context();
                    if (!changed.endsWith(this.file.getFileName())) continue;
                    long now = System.currentTimeMillis();
                    if (now - this.lastTriggerTime > 5000L) {
                        this.lastTriggerTime = now;
                        if (this.scheduledTask != null && !this.scheduledTask.isDone()) {
                            this.scheduledTask.cancel(false);
                        }
                        DynamicResourcePack.LOGGER.info("{} has changed, scheduling resource pack reload...", (Object)this.file.getFileName());
                        this.scheduledTask = this.executor.schedule(this.runnable, 1L, TimeUnit.SECONDS);
                        continue;
                    }
                    DynamicResourcePack.LOGGER.info("Debounced duplicate event {} for {}", (Object)event.kind().name(), (Object)this.file.getFileName());
                }
                boolean valid = wk.reset();
                if (valid) continue;
                DynamicResourcePack.LOGGER.error("Key has been unregistered");
            }
        }
        catch (Exception ex) {
            DynamicResourcePack.LOGGER.error(ex.toString());
        }
    }
}

