/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.modifySwords;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class ModifySwords
extends JavaPlugin
implements Listener {
    private final Map<Player, Long> cooldowns = new HashMap<Player, Long>();

    public void onEnable() {
        this.getCommand("modifyswords").setExecutor((CommandExecutor)this);
        this.getCommand("modify").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 2 && args[0].equalsIgnoreCase("get")) {
            if (player.hasPermission("modifyswords.get")) {
                if (args[1].equalsIgnoreCase("Strike")) {
                    player.getInventory().addItem(new ItemStack[]{this.createStrikeSword()});
                    player.sendMessage("You have received the \u26a1 Strike Sword!");
                } else if (args[1].equalsIgnoreCase("dash")) {
                    player.getInventory().addItem(new ItemStack[]{this.createDashSword()});
                    player.sendMessage("You have received the \ud83d\ude80 Dash Sword!");
                } else if (args[1].equalsIgnoreCase("executioner")) {
                    player.getInventory().addItem(new ItemStack[]{this.createExecutionerSword()});
                    player.sendMessage("You have received the \ud83d\udc80 Executioner Sword!");
                } else if (args[1].equalsIgnoreCase("void")) {
                    player.getInventory().addItem(new ItemStack[]{this.createVoidSword()});
                    player.sendMessage("You have received the \u2600\ufe0f Void Sword!");
                } else {
                    player.sendMessage("Unknown sword name.");
                }
            } else {
                player.sendMessage("You do not have permission to use this command.");
            }
            return true;
        }
        return false;
    }

    public ItemStack createStrikeSword() {
        ItemStack sword = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta meta = sword.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7e\u26a1 Strike Sword");
            meta.addEnchant(Enchantment.SHARPNESS, 5, true);
            meta.addEnchant(Enchantment.SWEEPING_EDGE, 3, true);
            meta.addEnchant(Enchantment.FIRE_ASPECT, 2, true);
            meta.setLore(List.of("\u00a77Sharpness V", "\u00a77Sweeping Edge III", "\u00a77Fire Aspect II", "\u00a77A chance to strike enemies with lightning"));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            sword.setItemMeta(meta);
        }
        return sword;
    }

    public ItemStack createDashSword() {
        ItemStack sword = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta meta = sword.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7a\ud83d\ude80 Dash Sword");
            meta.addEnchant(Enchantment.SHARPNESS, 5, true);
            meta.addEnchant(Enchantment.SWEEPING_EDGE, 3, true);
            meta.addEnchant(Enchantment.FIRE_ASPECT, 2, true);
            meta.setLore(List.of("\u00a77Sharpness V", "\u00a77Sweeping Edge III", "\u00a77Fire Aspect II", "\u00a77Lets you dash through the air!", "\u00a77Can be activated by shift right clicking on or doing \u00a7a/modifyswords ability \u00a77while holding the sword"));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            sword.setItemMeta(meta);
        }
        return sword;
    }

    public ItemStack createExecutionerSword() {
        ItemStack sword = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta meta = sword.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76\ud83d\udc80 Executioner Sword");
            meta.addEnchant(Enchantment.SHARPNESS, 5, true);
            meta.addEnchant(Enchantment.SWEEPING_EDGE, 3, true);
            meta.addEnchant(Enchantment.FIRE_ASPECT, 2, true);
            meta.setLore(List.of("\u00a77Sharpness V", "\u00a77Sweeping Edge III", "\u00a77Fire Aspect II", "\u00a77A chance to drop player's heads when you kill them"));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            sword.setItemMeta(meta);
        }
        return sword;
    }

    public ItemStack createVoidSword() {
        ItemStack sword = new ItemStack(Material.NETHERITE_SWORD);
        ItemMeta meta = sword.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a78\u2600\ufe0f Void Sword");
            meta.addEnchant(Enchantment.SHARPNESS, 5, true);
            meta.addEnchant(Enchantment.SWEEPING_EDGE, 3, true);
            meta.addEnchant(Enchantment.FIRE_ASPECT, 2, true);
            meta.setLore(List.of("\u00a77Sharpness V", "\u00a77Sweeping Edge III", "\u00a77Fire Aspect II", "\u00a77A chance to take enemies' vision!"));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            sword.setItemMeta(meta);
        }
        return sword;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            List lore;
            Player player = (Player)event.getDamager();
            Entity entity = event.getEntity();
            if (player.getInventory().getItemInMainHand().hasItemMeta() && player.getInventory().getItemInMainHand().getItemMeta().hasLore() && (lore = player.getInventory().getItemInMainHand().getItemMeta().getLore()).contains("\u00a77A chance to strike enemies with lightning") && Math.random() < 0.2 && entity instanceof LivingEntity) {
                entity.getWorld().strikeLightning(entity.getLocation());
            }
            if (player.getInventory().getItemInMainHand().hasItemMeta() && player.getInventory().getItemInMainHand().getItemMeta().hasLore() && (lore = player.getInventory().getItemInMainHand().getItemMeta().getLore()).contains("\u00a77A chance to take enemies' vision!") && Math.random() < 0.1 && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 100, 1));
            }
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        List lore;
        Player player = event.getPlayer();
        if (event.getAction().toString().contains("RIGHT_CLICK") && player.isSneaking() && player.getInventory().getItemInMainHand().hasItemMeta() && player.getInventory().getItemInMainHand().getItemMeta().hasLore() && (lore = player.getInventory().getItemInMainHand().getItemMeta().getLore()).contains("\u00a77Lets you dash through the air!")) {
            if (this.isOnCooldown(player)) {
                long timeLeft = (20000L - (System.currentTimeMillis() - this.cooldowns.get(player))) / 1000L;
                player.sendMessage("\u00a7aYou must wait " + timeLeft + " seconds before using this ability again.");
            } else {
                Vector direction = player.getLocation().getDirection().normalize();
                player.setVelocity(direction.multiply(2));
                player.sendMessage("You have dashed through the air!");
                this.setCooldown(player);
            }
        }
    }

    private boolean isOnCooldown(Player player) {
        return this.cooldowns.containsKey(player) && System.currentTimeMillis() - this.cooldowns.get(player) < 20000L;
    }

    private void setCooldown(Player player) {
        this.cooldowns.put(player, System.currentTimeMillis());
    }
}

