package mod.shoulder_surfing.irons_spells_integration;

import com.github.exopandora.shouldersurfing.api.callback.ICameraCouplingCallback;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingPlugin;
import com.github.exopandora.shouldersurfing.api.plugin.IShoulderSurfingRegistrar;
import net.minecraft.client.Minecraft;

// Referenced in src/main/resources/shouldersurfing_plugin.json
@SuppressWarnings("unused")
public class ShoulderSurfingIronsSpellsPlugin implements IShoulderSurfingPlugin {
    @Override
    public void register(IShoulderSurfingRegistrar registrar) {
        registrar.registerCameraCouplingCallback(new CameraCouplingCallback());
    }

    // TODO: Once this PR is released: https://github.com/Exopandora/ShoulderSurfing/pull/346
    //  use a better callback that ensures the player looks at the crosshair target (overriding isAttacking)
    //  instead of forcing camera coupling for more accurate aiming.
    //  For more info: https://github.com/Exopandora/ShoulderSurfing/issues/345#issuecomment-3412713167
    private static class CameraCouplingCallback implements ICameraCouplingCallback {
        @Override
        public boolean isForcingCameraCoupling(Minecraft minecraft) {
            return ShoulderSurfingIronsSpellsIntegrationClient.shouldForceCameraCoupling();
        }
    }
}
