/*
 * Decompiled with CFR 0.152.
 */
package mod.shoulder_surfing.irons_spells_integration;

import com.github.exopandora.shouldersurfing.client.ShoulderSurfingImpl;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@Mod(value="shoulder_surfing_irons_spells_integration", dist={Dist.CLIENT})
public class ShoulderSurfingIronsSpellsIntegrationClient {
    private boolean temporarilyOverrodeCameraDecoupling = false;

    public ShoulderSurfingIronsSpellsIntegrationClient(ModContainer container) {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private static ShoulderSurfingImpl getShoulderSurfing() {
        return ShoulderSurfingImpl.getInstance();
    }

    private static void toggleShoulderSurfingCameraCoupling() {
        ShoulderSurfingIronsSpellsIntegrationClient.getShoulderSurfing().toggleCameraCoupling();
    }

    private static void lookAtCrosshairTarget() {
        ShoulderSurfingIronsSpellsIntegrationClient.getShoulderSurfing().lookAtCrosshairTarget();
    }

    private static boolean isShoulderSurfingCameraDecoupled() {
        ShoulderSurfingImpl shoulderSurfing = ShoulderSurfingIronsSpellsIntegrationClient.getShoulderSurfing();
        return shoulderSurfing.isShoulderSurfing() && shoulderSurfing.isCameraDecoupled();
    }

    private static boolean isContinuousSpell(CastType castType) {
        return castType == CastType.CONTINUOUS;
    }

    private static void lookAtCrosshairTargetIfCameraDecoupled() {
        if (ShoulderSurfingIronsSpellsIntegrationClient.isShoulderSurfingCameraDecoupled()) {
            ShoulderSurfingIronsSpellsIntegrationClient.lookAtCrosshairTarget();
        }
    }

    public static void onCastSpellUsingSpellBook() {
        ShoulderSurfingIronsSpellsIntegrationClient.lookAtCrosshairTargetIfCameraDecoupled();
    }

    public static void onUseScrollItem() {
        ShoulderSurfingIronsSpellsIntegrationClient.lookAtCrosshairTargetIfCameraDecoupled();
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (!player.level().isClientSide) {
            return;
        }
        boolean isCasting = ClientMagicData.isCasting();
        boolean isContinuous = ShoulderSurfingIronsSpellsIntegrationClient.isContinuousSpell(ClientMagicData.getCastType());
        if (isCasting) {
            if (isContinuous && ShoulderSurfingIronsSpellsIntegrationClient.isShoulderSurfingCameraDecoupled()) {
                ShoulderSurfingIronsSpellsIntegrationClient.toggleShoulderSurfingCameraCoupling();
                this.temporarilyOverrodeCameraDecoupling = true;
            }
        } else if (this.temporarilyOverrodeCameraDecoupling) {
            this.temporarilyOverrodeCameraDecoupling = false;
            ShoulderSurfingIronsSpellsIntegrationClient.toggleShoulderSurfingCameraCoupling();
        }
    }
}

