/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.commands.format;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github._4drian3d.titleannouncer.common.adapter.PlatformAdapter;
import io.github._4drian3d.titleannouncer.common.commands.format.AnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.TargetSuggestions;
import io.github._4drian3d.titleannouncer.common.configuration.Configuration;
import io.github._4drian3d.titleannouncer.common.configuration.ConfigurationContainer;
import io.github._4drian3d.titleannouncer.common.configuration.Messages;
import io.github._4drian3d.titleannouncer.common.format.Formatter;
import io.github._4drian3d.titleannouncer.common.manager.BossBarManager;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;

public record BossbarAnnounceNode<C>(Formatter formatter, PlatformAdapter<?, C> platformAdapter, BossBarManager bossBarManager, ConfigurationContainer<Configuration> configurationContainer, ConfigurationContainer<Messages> messagesContainer) implements AnnounceNode<C>
{
    @Override
    public LiteralArgumentBuilder<C> provideNode(TargetSuggestions<C> targetSuggestions) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"bossbar").requires(src -> this.platformAdapter.hasPermission(src, "titleannouncer.command.bossbar"))).then(RequiredArgumentBuilder.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests(targetSuggestions).then(RequiredArgumentBuilder.argument((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)1)).then(RequiredArgumentBuilder.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            BossBar.Color.NAMES.keys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"overlay", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            BossBar.Overlay.NAMES.keys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"content", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            Audience executor = this.platformAdapter.nativeToAudience(ctx.getSource());
            Optional<Audience> optionalTarget = this.platformAdapter.destinationFromString(StringArgumentType.getString((CommandContext)ctx, (String)"target"), executor);
            if (optionalTarget.isEmpty()) {
                executor.sendMessage(this.formatter.globalFormat(this.messagesContainer.get().invalidTarget()));
                return -1;
            }
            Audience target = optionalTarget.get();
            int seconds = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds");
            BossBar.Color color = (BossBar.Color)BossBar.Color.NAMES.valueOrThrow((Object)StringArgumentType.getString((CommandContext)ctx, (String)"color"));
            BossBar.Overlay overlay = (BossBar.Overlay)BossBar.Overlay.NAMES.valueOrThrow((Object)StringArgumentType.getString((CommandContext)ctx, (String)"overlay"));
            String content = StringArgumentType.getString((CommandContext)ctx, (String)"content");
            this.bossBarManager.sendBossBar(target, seconds, content, color, overlay);
            return 1;
        }))))));
    }
}

