/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.commands;

import com.google.inject.Inject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github._4drian3d.titleannouncer.common.adapter.PlatformAdapter;
import io.github._4drian3d.titleannouncer.common.commands.format.ActionbarAnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.format.AnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.format.BossbarAnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.format.ChatAnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.format.SoundAnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.format.TitleAnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.PlayerSuggestionType;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.TargetSuggestionType;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.TargetSuggestions;
import io.github._4drian3d.titleannouncer.common.configuration.Configuration;
import io.github._4drian3d.titleannouncer.common.configuration.ConfigurationContainer;
import io.github._4drian3d.titleannouncer.common.configuration.Messages;
import io.github._4drian3d.titleannouncer.common.format.Formatter;
import io.github._4drian3d.titleannouncer.common.manager.BossBarManager;
import java.util.List;
import net.kyori.adventure.audience.Audience;

public final class AnnouncerCommand<P extends Audience, C> {
    @Inject
    private Formatter formatter;
    @Inject
    private ConfigurationContainer<Configuration> configurationContainer;
    @Inject
    private ConfigurationContainer<Messages> messagesContainer;
    @Inject
    private PlatformAdapter<P, C> platformAdapter;
    @Inject
    private BossBarManager bossBarManager;

    public LiteralCommandNode<C> buildCommand(String prefix, TargetSuggestionType nativeTargetSuggestions) {
        LiteralArgumentBuilder announceBuilder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)(prefix + "announce")).requires(src -> this.platformAdapter.hasPermission(src, "titleannouncer.command"));
        PlayerSuggestionType playerSuggestionType = new PlayerSuggestionType(this.platformAdapter);
        TargetSuggestions targetSuggestions = new TargetSuggestions(playerSuggestionType, nativeTargetSuggestions);
        List<SoundAnnounceNode<C>> nodes = List.of(new TitleAnnounceNode<C>(this.formatter, this.platformAdapter, this.configurationContainer, this.messagesContainer), new ActionbarAnnounceNode<C>(this.formatter, this.platformAdapter, this.configurationContainer, this.messagesContainer), new ChatAnnounceNode<C>(this.formatter, this.platformAdapter, this.configurationContainer, this.messagesContainer), new BossbarAnnounceNode<C>(this.formatter, this.platformAdapter, this.bossBarManager, this.configurationContainer, this.messagesContainer), new SoundAnnounceNode<C>(this.formatter, this.platformAdapter, this.configurationContainer, this.messagesContainer));
        for (AnnounceNode announceNode : nodes) {
            announceBuilder.then(announceNode.provideNode(targetSuggestions));
        }
        return announceBuilder.build();
    }
}

