/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.commands;

import com.google.inject.Inject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github._4drian3d.titleannouncer.common.adapter.PlatformAdapter;
import io.github._4drian3d.titleannouncer.common.configuration.Configuration;
import io.github._4drian3d.titleannouncer.common.configuration.ConfigurationContainer;
import io.github._4drian3d.titleannouncer.common.configuration.Messages;
import io.github._4drian3d.titleannouncer.common.format.Formatter;
import io.github._4drian3d.titleannouncer.libs.desertwell.about.AboutMenu;
import io.github._4drian3d.titleannouncer.libs.desertwell.util.Version;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class TitleAnnouncerCommand<P extends Audience, C> {
    public static final Component INFO = AboutMenu.builder().title(MiniMessage.miniMessage().deserialize((Object)"<b><gradient:green:aqua>TitleAnnouncer</b>")).description((Component)Component.text((String)"A lightweight Paper and Velocity plugin to send Titles, Actionbars, Bossbars and Chat announces")).credits("Author", AboutMenu.Credit.of("4drian3d").url("https://github.com/4drian3d")).buttons(AboutMenu.Link.of("https://discord.gg/5NMMzK5mAn").text("Discord").color(TextColor.color((int)7506394)).icon("\u2b50"), AboutMenu.Link.of("https://modrinth.com/plugin/titleannouncer").text("Downloads").color(TextColor.color((int)16730478)).icon("\u2193")).version(Version.fromString("3.0.0")).build().toComponent();
    @Inject
    private PlatformAdapter<P, C> platformAdapter;
    @Inject
    private ConfigurationContainer<Configuration> configurationContainer;
    @Inject
    private ConfigurationContainer<Messages> messagesContainer;
    @Inject
    private Formatter formatter;

    public LiteralCommandNode<C> buildCommand(String prefix) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)(prefix + "titleannouncer")).requires(src -> this.platformAdapter.hasPermission(src, "titleannouncer.command.admin"))).executes(ctx -> {
            this.platformAdapter.nativeToAudience(ctx.getSource()).sendMessage(INFO);
            return 1;
        })).then(LiteralArgumentBuilder.literal((String)"reload").executes(ctx -> {
            Audience audience = this.platformAdapter.nativeToAudience(ctx.getSource());
            this.configurationContainer.reload().thenCombine(this.messagesContainer.reload(), (configurationReloaded, messagesReloaded) -> {
                Messages.Reload reloadMessages = this.messagesContainer.get().reload();
                if (configurationReloaded.booleanValue() && messagesReloaded.booleanValue()) {
                    audience.sendMessage(this.formatter.globalFormat(reloadMessages.successfullyReloaded()));
                } else {
                    audience.sendMessage(this.formatter.globalFormat(reloadMessages.errorWhileReloadingConfiguration()));
                }
                return null;
            });
            return 1;
        }))).build();
    }
}

