/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.commands.format;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github._4drian3d.titleannouncer.common.adapter.PlatformAdapter;
import io.github._4drian3d.titleannouncer.common.commands.format.AnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.SoundSuggestions;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.TargetSuggestions;
import io.github._4drian3d.titleannouncer.common.configuration.Configuration;
import io.github._4drian3d.titleannouncer.common.configuration.ConfigurationContainer;
import io.github._4drian3d.titleannouncer.common.configuration.Messages;
import io.github._4drian3d.titleannouncer.common.format.Formatter;
import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public record SoundAnnounceNode<C>(Formatter formatter, PlatformAdapter<?, C> platformAdapter, ConfigurationContainer<Configuration> configurationContainer, ConfigurationContainer<Messages> messagesContainer) implements AnnounceNode<C>
{
    @Override
    public LiteralArgumentBuilder<C> provideNode(TargetSuggestions<C> targetSuggestions) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"sound").requires(src -> this.platformAdapter.hasPermission(src, "titleannouncer.command.sound"))).then(RequiredArgumentBuilder.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests(targetSuggestions).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"sound", (ArgumentType)StringArgumentType.string()).suggests(new SoundSuggestions()).executes(ctx -> {
            Audience executor = this.platformAdapter.nativeToAudience(ctx.getSource());
            Optional<Audience> optionalTarget = this.platformAdapter.destinationFromString(StringArgumentType.getString((CommandContext)ctx, (String)"target"), executor);
            if (optionalTarget.isEmpty()) {
                executor.sendMessage(this.formatter.globalFormat(this.messagesContainer.get().invalidTarget()));
                return -1;
            }
            Audience target = optionalTarget.get();
            String soundArgument = StringArgumentType.getString((CommandContext)ctx, (String)"sound").trim().toLowerCase(Locale.ROOT);
            if (!Key.parseable((String)soundArgument)) {
                target.sendMessage(this.formatter.globalWithExtraResolver(this.messagesContainer.get().sound().invalidSoundProvided(), (TagResolver)Placeholder.parsed((String)"sound", (String)soundArgument)));
                return -1;
            }
            Configuration.Sound soundConfiguration = this.configurationContainer.get().sound();
            Key soundKey = Key.key((String)soundArgument);
            target.playSound(Sound.sound((Key)soundKey, (Sound.Source)soundConfiguration.defaultSource(), (float)soundConfiguration.defaultVolume(), (float)soundConfiguration.defaultPitch()), Sound.Emitter.self());
            executor.sendMessage(this.formatter.globalWithExtraResolver(this.messagesContainer.get().sound().playingSound(), (TagResolver)Placeholder.parsed((String)"sound", (String)soundKey.asString())));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"source", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            Sound.Source.NAMES.keys().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).then(RequiredArgumentBuilder.argument((String)"volume", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).then(RequiredArgumentBuilder.argument((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> {
            Audience executor = this.platformAdapter.nativeToAudience(ctx.getSource());
            Optional<Audience> optionalTarget = this.platformAdapter.destinationFromString(StringArgumentType.getString((CommandContext)ctx, (String)"target"), executor);
            if (optionalTarget.isEmpty()) {
                executor.sendMessage(this.formatter.globalFormat(this.messagesContainer.get().invalidTarget()));
                return -1;
            }
            Audience target = optionalTarget.get();
            String soundArgument = StringArgumentType.getString((CommandContext)ctx, (String)"sound").trim().toLowerCase(Locale.ROOT);
            if (!Key.parseable((String)soundArgument)) {
                target.sendMessage(this.formatter.globalWithExtraResolver(this.messagesContainer.get().sound().invalidSoundProvided(), (TagResolver)Placeholder.parsed((String)"sound", (String)soundArgument)));
                return -1;
            }
            Sound.Source source = (Sound.Source)Sound.Source.NAMES.valueOrThrow((Object)StringArgumentType.getString((CommandContext)ctx, (String)"source").toLowerCase(Locale.ROOT));
            float volume = FloatArgumentType.getFloat((CommandContext)ctx, (String)"volume");
            float pitch = FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitch");
            Key soundKey = Key.key((String)soundArgument);
            target.playSound(Sound.sound((Key)soundKey, (Sound.Source)source, (float)volume, (float)pitch), Sound.Emitter.self());
            executor.sendMessage(this.formatter.globalWithExtraResolver(this.messagesContainer.get().sound().playingSound(), (TagResolver)Placeholder.parsed((String)"sound", (String)soundKey.asString())));
            return 1;
        }))))));
    }
}

