/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.commands.suggestions;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public final class SoundSuggestions<C>
implements SuggestionProvider<C> {
    public CompletableFuture<Suggestions> getSuggestions(CommandContext<C> context, SuggestionsBuilder builder) {
        String remainingBeforeSeparator;
        boolean namespaced;
        String remaining = builder.getRemaining();
        int indexOfSeparator = remaining.indexOf(58);
        boolean bl = namespaced = indexOfSeparator != -1;
        if (remaining.isBlank() || !namespaced) {
            if (!namespaced && this.isNotLowercased(remaining)) {
                builder.suggest(remaining.toLowerCase(Locale.ROOT));
            }
            return builder.suggest("\"minecraft:").buildFuture();
        }
        int remainingLength = remaining.length();
        if (remainingLength > 2 && !(remainingBeforeSeparator = remaining.substring(1)).isBlank()) {
            if (this.isNotLowercased(remainingBeforeSeparator)) {
                String remainingLowerCased = remainingBeforeSeparator.toLowerCase(Locale.ROOT);
                return builder.suggest("\"" + remainingLowerCased).buildFuture();
            }
            if (remainingLength - 1 > indexOfSeparator) {
                String remainingAfterSeparator = remaining.substring(indexOfSeparator + 1);
                SuggestionsBuilder offsetBuilder = builder.createOffset(builder.getStart() + indexOfSeparator + 1);
                if (remaining.charAt(remainingLength - 1) != '\"') {
                    offsetBuilder.suggest(remainingAfterSeparator.toLowerCase(Locale.ROOT) + "\"");
                }
                return offsetBuilder.buildFuture();
            }
        }
        return builder.buildFuture();
    }

    private boolean isNotLowercased(String string) {
        String lowerCased = string.toLowerCase(Locale.ROOT);
        return !Objects.equals(string, lowerCased);
    }
}

