/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.manager;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.github._4drian3d.titleannouncer.common.format.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Range;

@Singleton
public final class BossBarManager {
    private static final ScheduledExecutorService BOSSBAR_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final Map<UUID, Map<BossBarTask, ScheduledFuture<?>>> BOSSBAR_TASKS = new ConcurrentHashMap();
    @Inject
    private Formatter formatter;

    public void sendBossBar(Audience audience, @Range(from=1L, to=0x7FFFFFFFL) int seconds, String content, BossBar.Color color, BossBar.Overlay type) {
        if (audience instanceof ForwardingAudience) {
            ForwardingAudience forwardingAudience = (ForwardingAudience)audience;
            for (Audience singleAudience : forwardingAudience.audiences()) {
                this.sendBossBar(singleAudience, seconds, content, color, type);
            }
            return;
        }
        BossBar bar = BossBar.bossBar((Component)this.formatter.audienceFormat(content, audience), (float)1.0f, (BossBar.Color)color, (BossBar.Overlay)type);
        audience.showBossBar(bar);
        audience.get(Identity.UUID).ifPresent(id -> BOSSBAR_TASKS.compute((UUID)id, (a, b) -> {
            if (b == null) {
                b = new HashMap();
            }
            float finalTime = 1.0f / (float)seconds;
            BossBarTask task = new BossBarTask(this.formatter, content, bar, audience, finalTime);
            b.put(task, BOSSBAR_EXECUTOR.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.SECONDS));
            return b;
        }));
    }

    private record BossBarTask(Formatter formatter, String content, BossBar bossBar, Audience viewer, float percentageToRemove) implements Runnable
    {
        @Override
        public void run() {
            this.calculateTitle();
            this.calculateProgress();
        }

        void calculateTitle() {
            this.bossBar.name(this.formatter.audienceFormat(this.content, this.viewer));
        }

        void calculateProgress() {
            float progress = this.bossBar.progress();
            float toRest = progress - this.percentageToRemove;
            if (toRest < 0.0f) {
                this.stop();
                return;
            }
            this.bossBar.progress(toRest);
        }

        void stop() {
            this.viewer.hideBossBar(this.bossBar);
            BOSSBAR_TASKS.remove(this.viewer.get(Identity.UUID).orElseThrow()).get(this).cancel(false);
        }
    }
}

