/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.velocity;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import io.github._4drian3d.titleannouncer.common.commands.AnnouncerCommand;
import io.github._4drian3d.titleannouncer.common.commands.TitleAnnouncerCommand;
import io.github._4drian3d.titleannouncer.velocity.TitleAnnouncerVelocityModule;
import io.github._4drian3d.titleannouncer.velocity.adapter.ServerSuggestionType;
import java.nio.file.Path;

@Plugin(id="titleannouncer", name="TitleAnnouncer", version="3.0.0", authors={"4drian3d"}, url="https://modrinth.com/plugin/titleannouncer", description="A lightweight Paper and Velocity plugin to send Titles, Actionbars, Bossbars and Chat announces", dependencies={@Dependency(id="miniplaceholders", optional=true)})
public final class TitleAnnouncerVelocity {
    @Inject
    private Injector injector;
    @Inject
    @DataDirectory
    private Path path;
    @Inject
    private ProxyServer proxyServer;
    @Inject
    private CommandManager commandManager;

    @Subscribe
    public void onStartup(ProxyInitializeEvent event) {
        this.injector = this.injector.createChildInjector(new Module[]{new TitleAnnouncerVelocityModule(this.path)});
        LiteralCommandNode announceNode = ((AnnouncerCommand)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<AnnouncerCommand<Player, CommandSource>>(this){}))).buildCommand("v", new ServerSuggestionType(this.proxyServer));
        LiteralCommandNode mainCommandNode = ((TitleAnnouncerCommand)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<TitleAnnouncerCommand<Player, CommandSource>>(this){}))).buildCommand("v");
        BrigadierCommand announceCommand = new BrigadierCommand(announceNode);
        CommandMeta announceCommandMeta = this.commandManager.metaBuilder(announceCommand).plugin((Object)this).build();
        this.commandManager.register(announceCommandMeta, (Command)announceCommand);
        BrigadierCommand mainCommand = new BrigadierCommand(mainCommandNode);
        CommandMeta mainCommandMeta = this.commandManager.metaBuilder(mainCommand).plugin((Object)this).build();
        this.commandManager.register(mainCommandMeta, (Command)mainCommand);
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
    }
}

