/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.velocity.adapter;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.TargetSuggestionType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public record ServerSuggestionType(ProxyServer proxyServer) implements TargetSuggestionType
{
    @Override
    public String targetPrefix() {
        return "server";
    }

    @Override
    public boolean canSuggest(String lowerCasedArgument) {
        return lowerCasedArgument.indexOf(34) == 0 ? lowerCasedArgument.startsWith(this.targetPrefix(), 1) : lowerCasedArgument.startsWith(this.targetPrefix());
    }

    @Override
    public CompletableFuture<Suggestions> provideSuggestions(String remaining, SuggestionsBuilder builder) {
        if (remaining.isBlank() || remaining.indexOf(58) == -1) {
            return builder.restart().suggest("\"server:").suggest("server").buildFuture();
        }
        return this.provideListSuggestions(remaining, builder.restart(), this::serverNames);
    }

    @Override
    public void suggestSelf(SuggestionsBuilder builder) {
        builder.suggest("server").suggest("\"server:");
    }

    private List<String> serverNames() {
        ArrayList<String> serverNames = new ArrayList<String>();
        for (RegisteredServer server : this.proxyServer.getAllServers()) {
            serverNames.add(server.getServerInfo().getName());
        }
        return serverNames;
    }
}

