/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.commands.format;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github._4drian3d.titleannouncer.common.adapter.PlatformAdapter;
import io.github._4drian3d.titleannouncer.common.commands.format.AnnounceNode;
import io.github._4drian3d.titleannouncer.common.commands.suggestions.TargetSuggestions;
import io.github._4drian3d.titleannouncer.common.configuration.Configuration;
import io.github._4drian3d.titleannouncer.common.configuration.ConfigurationContainer;
import io.github._4drian3d.titleannouncer.common.configuration.Messages;
import io.github._4drian3d.titleannouncer.common.format.Formatter;
import java.time.Duration;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;

public record TitleAnnounceNode<C>(Formatter formatter, PlatformAdapter<?, C> platformAdapter, ConfigurationContainer<Configuration> configurationContainer, ConfigurationContainer<Messages> messagesContainer) implements AnnounceNode<C>
{
    @Override
    public LiteralArgumentBuilder<C> provideNode(TargetSuggestions<C> targetSuggestions) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"title").requires(src -> this.platformAdapter.hasPermission(src, "titleannouncer.command.title"))).then(RequiredArgumentBuilder.argument((String)"target", (ArgumentType)StringArgumentType.string()).suggests(targetSuggestions).then(RequiredArgumentBuilder.argument((String)"title", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"subtitle", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            Audience executor = this.platformAdapter.nativeToAudience(ctx.getSource());
            Optional<Audience> optionalTarget = this.platformAdapter.destinationFromString(StringArgumentType.getString((CommandContext)ctx, (String)"target"), executor);
            if (optionalTarget.isEmpty()) {
                executor.sendMessage(this.formatter.globalFormat(this.messagesContainer.get().invalidTarget()));
                return -1;
            }
            Audience target = optionalTarget.get();
            Component title = this.formatter.audienceFormat(StringArgumentType.getString((CommandContext)ctx, (String)"title"), target);
            Component subtitle = this.formatter.audienceFormat(StringArgumentType.getString((CommandContext)ctx, (String)"subtitle"), target);
            Configuration.Title titleConfiguration = this.configurationContainer.get().title();
            target.sendTitlePart(TitlePart.TITLE, (Object)title);
            target.sendTitlePart(TitlePart.SUBTITLE, (Object)subtitle);
            target.sendTitlePart(TitlePart.TIMES, (Object)Title.Times.times((Duration)Duration.ofMillis(titleConfiguration.defaultFadeIn()), (Duration)Duration.ofMillis(titleConfiguration.defaultStay()), (Duration)Duration.ofMillis(titleConfiguration.defaultFadeOut())));
            return 1;
        })).then(RequiredArgumentBuilder.argument((String)"fadein", (ArgumentType)IntegerArgumentType.integer((int)1)).then(RequiredArgumentBuilder.argument((String)"stay", (ArgumentType)IntegerArgumentType.integer((int)1)).then(RequiredArgumentBuilder.argument((String)"fadeout", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            Audience executor = this.platformAdapter.nativeToAudience(ctx.getSource());
            Optional<Audience> optionalTarget = this.platformAdapter.destinationFromString(StringArgumentType.getString((CommandContext)ctx, (String)"target"), executor);
            if (optionalTarget.isEmpty()) {
                executor.sendMessage(this.formatter.globalFormat(this.messagesContainer.get().invalidTarget()));
                return -1;
            }
            Audience target = optionalTarget.get();
            Component title = this.formatter.audienceFormat(StringArgumentType.getString((CommandContext)ctx, (String)"title"), target);
            Component subtitle = this.formatter.audienceFormat(StringArgumentType.getString((CommandContext)ctx, (String)"subtitle"), target);
            int fadeIn = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"fadein");
            int stay = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"stay");
            int fadeout = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"fadeout");
            target.sendTitlePart(TitlePart.TITLE, (Object)title);
            target.sendTitlePart(TitlePart.SUBTITLE, (Object)subtitle);
            target.sendTitlePart(TitlePart.TIMES, (Object)Title.Times.times((Duration)Duration.ofMillis(fadeIn), (Duration)Duration.ofMillis(stay), (Duration)Duration.ofMillis(fadeout)));
            return 1;
        })))))));
    }
}

