/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.titleannouncer.common.configuration;

import io.github._4drian3d.titleannouncer.common.configuration.Section;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;

public final class ConfigurationContainer<C extends Section> {
    private final AtomicReference<C> config;
    private final HoconConfigurationLoader loader;
    private final Class<C> clazz;
    private final Logger logger;

    private ConfigurationContainer(C config, Class<C> clazz, HoconConfigurationLoader loader, Logger logger) {
        this.config = new AtomicReference<C>(config);
        this.loader = loader;
        this.clazz = clazz;
        this.logger = logger;
    }

    public CompletableFuture<Boolean> reload() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                CommentedConfigurationNode node = (CommentedConfigurationNode)this.loader.load();
                Section newConfig = (Section)node.get(this.clazz);
                node.set(this.clazz, (Object)newConfig);
                this.loader.save((ConfigurationNode)node);
                this.config.set(newConfig);
                return true;
            }
            catch (ConfigurateException exception) {
                this.logger.error("Could not reload {} configuration file", (Object)this.clazz.getSimpleName(), (Object)exception);
                return false;
            }
        });
    }

    @NotNull
    public C get() {
        return (C)((Section)this.config.get());
    }

    public static <C extends Section> ConfigurationContainer<C> load(Logger logger, Path path, Class<C> clazz, String file) {
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().defaultOptions(opts -> opts.shouldCopyDefaults(true).header("TitleAnnouncer | by 4drian3d\n"))).path(path.resolve(file + ".conf"))).build();
        try {
            CommentedConfigurationNode node = (CommentedConfigurationNode)loader.load();
            Section config = (Section)node.get(clazz);
            node.set(clazz, (Object)config);
            loader.save((ConfigurationNode)node);
            return new ConfigurationContainer<Section>(config, clazz, loader, logger);
        }
        catch (ConfigurateException exception) {
            logger.error("Could not load {} configuration file", (Object)clazz.getSimpleName(), (Object)exception);
            return null;
        }
    }
}

